/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objects.ObjectWrapper;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

class SetObjectMaintenanceState
extends AbstractHandler {
    private boolean maintained;

    protected SetObjectMaintenanceState(boolean maintained) {
        this.maintained = maintained;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = window.getActivePage().getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        final Object[] objects = ((IStructuredSelection)selection).toArray();
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SetObjectManagementState_JobTitle, null, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof AbstractObject) {
                        session.setObjectMaintenanceMode(((AbstractObject)o).getObjectId(), SetObjectMaintenanceState.this.maintained);
                    } else if (o instanceof ObjectWrapper) {
                        session.setObjectMaintenanceMode(((ObjectWrapper)o).getObjectId(), SetObjectMaintenanceState.this.maintained);
                    }
                    ++n2;
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SetObjectManagementState_JobError;
            }
        }.start();
        return null;
    }
}

