/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.WinPerfCounter;
import org.netxms.client.datacollection.WinPerfObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.WinPerfObjectTreeContentProvider;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.WinPerfObjectTreeLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.StringComparator;

public class WinPerfCounterSelectionDialog
extends Dialog
implements IParameterSelectionDialog {
    private long nodeId;
    private TreeViewer objectTree;
    private TableViewer instanceList;
    private WinPerfCounter selectedCounter = null;
    private String selectedInstance = null;

    public WinPerfCounterSelectionDialog(Shell parentShell, long nodeId) {
        super(parentShell);
        this.nodeId = nodeId;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.WinPerfCounterSelectionDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.WinPerfCounterSelectionDialog_ObjectsAndCounters);
        Label label2 = new Label(dialogArea, 0);
        Messages.get();
        label2.setText(Messages.WinPerfCounterSelectionDialog_Instances);
        this.objectTree = new TreeViewer(dialogArea, 67584);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        gd.widthHint = 350;
        this.objectTree.getControl().setLayoutData((Object)gd);
        this.objectTree.setContentProvider((IContentProvider)new WinPerfObjectTreeContentProvider());
        this.objectTree.setLabelProvider((IBaseLabelProvider)new WinPerfObjectTreeLabelProvider());
        this.objectTree.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = e1 instanceof WinPerfCounter ? ((WinPerfCounter)e1).getName() : ((WinPerfObject)e1).getName();
                String s2 = e2 instanceof WinPerfCounter ? ((WinPerfCounter)e2).getName() : ((WinPerfObject)e2).getName();
                return s1.compareToIgnoreCase(s2);
            }
        });
        this.objectTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WinPerfCounterSelectionDialog.this.onObjectSelection();
            }
        });
        this.instanceList = new TableViewer(dialogArea, 67584);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 350;
        this.instanceList.getControl().setLayoutData((Object)gd);
        this.instanceList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.instanceList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.instanceList.setComparator((ViewerComparator)new StringComparator());
        this.fillData();
        return dialogArea;
    }

    private void fillData() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.WinPerfCounterSelectionDialog_JobName, null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List objects = session.getNodeWinPerfObjects(WinPerfCounterSelectionDialog.this.nodeId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        WinPerfCounterSelectionDialog.this.objectTree.setInput((Object)objects);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.WinPerfCounterSelectionDialog_JobError;
            }
        }.start();
    }

    private void onObjectSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        if (selection.size() == 0) {
            this.instanceList.setInput((Object)new String[0]);
            return;
        }
        WinPerfObject object = selection.getFirstElement() instanceof WinPerfObject ? (WinPerfObject)selection.getFirstElement() : ((WinPerfCounter)selection.getFirstElement()).getObject();
        this.instanceList.setInput((Object)object.getInstances());
        this.instanceList.getTable().setEnabled(object.hasInstances());
        this.selectedCounter = selection.getFirstElement() instanceof WinPerfCounter ? (WinPerfCounter)selection.getFirstElement() : null;
    }

    protected void okPressed() {
        if (this.selectedCounter == null) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.WinPerfCounterSelectionDialog_Warning, (String)Messages.WinPerfCounterSelectionDialog_PleaseSelectCounter);
            return;
        }
        if (this.selectedCounter.getObject().hasInstances()) {
            IStructuredSelection selection = (IStructuredSelection)this.instanceList.getSelection();
            if (selection.size() != 1) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.WinPerfCounterSelectionDialog_Warning, (String)Messages.WinPerfCounterSelectionDialog_PleaseSelectCounter);
                return;
            }
            this.selectedInstance = (String)selection.getFirstElement();
        } else {
            this.selectedInstance = null;
        }
        super.okPressed();
    }

    @Override
    public String getParameterName() {
        if (this.selectedInstance == null) {
            return "\\" + this.selectedCounter.getObject().getName() + "\\" + this.selectedCounter.getName();
        }
        return "\\" + this.selectedCounter.getObject().getName() + "(" + this.selectedInstance + ")\\" + this.selectedCounter.getName();
    }

    @Override
    public String getParameterDescription() {
        if (this.selectedInstance == null) {
            return String.valueOf(this.selectedCounter.getObject().getName()) + ": " + this.selectedCounter.getName();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.selectedCounter.getObject().getName())).append(": ").append(this.selectedCounter.getName());
        Messages.get();
        return stringBuilder.append(Messages.WinPerfCounterSelectionDialog_for).append(this.selectedInstance).toString();
    }

    @Override
    public int getParameterDataType() {
        return 2;
    }

    @Override
    public String getInstanceColumn() {
        return "";
    }
}

