/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FONT_COLOR = new Color((Device)Display.getDefault(), new RGB(126, 137, 185));
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<Integer, String> originTexts = new HashMap();
    private HashMap<Integer, String> dtTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        Integer n = 1;
        Messages.get();
        this.originTexts.put(n, Messages.DciLabelProvider_SourceAgent);
        Integer n2 = 3;
        Messages.get();
        this.originTexts.put(n2, Messages.DciLabelProvider_SourceCPSNMP);
        Integer n3 = 10;
        Messages.get();
        this.originTexts.put(n3, Messages.DciLabelProvider_SourceDeviceDriver);
        Integer n4 = 0;
        Messages.get();
        this.originTexts.put(n4, Messages.DciLabelProvider_SourceInternal);
        Integer n5 = 9;
        Messages.get();
        this.originTexts.put(n5, Messages.DciLabelProvider_SourceMQTT);
        Integer n6 = 4;
        Messages.get();
        this.originTexts.put(n6, Messages.DciLabelProvider_SourcePush);
        Integer n7 = 7;
        Messages.get();
        this.originTexts.put(n7, Messages.DciLabelProvider_SourceScript);
        Integer n8 = 6;
        Messages.get();
        this.originTexts.put(n8, Messages.DciLabelProvider_SourceILO);
        Integer n9 = 2;
        Messages.get();
        this.originTexts.put(n9, Messages.DciLabelProvider_SourceSNMP);
        Integer n10 = 8;
        Messages.get();
        this.originTexts.put(n10, Messages.DciLabelProvider_SourceSSH);
        Integer n11 = 5;
        Messages.get();
        this.originTexts.put(n11, Messages.DciLabelProvider_SourceWinPerf);
        Integer n12 = 0;
        Messages.get();
        this.statusTexts.put(n12, Messages.DciLabelProvider_Active);
        Integer n13 = 1;
        Messages.get();
        this.statusTexts.put(n13, Messages.DciLabelProvider_Disabled);
        Integer n14 = 2;
        Messages.get();
        this.statusTexts.put(n14, Messages.DciLabelProvider_NotSupported);
        Integer n15 = 0;
        Messages.get();
        this.dtTexts.put(n15, Messages.DciLabelProvider_DT_int32);
        Integer n16 = 1;
        Messages.get();
        this.dtTexts.put(n16, Messages.DciLabelProvider_DT_uint32);
        Integer n17 = 2;
        Messages.get();
        this.dtTexts.put(n17, Messages.DciLabelProvider_DT_int64);
        Integer n18 = 3;
        Messages.get();
        this.dtTexts.put(n18, Messages.DciLabelProvider_DT_uint64);
        Integer n19 = 5;
        Messages.get();
        this.dtTexts.put(n19, Messages.DciLabelProvider_DT_float);
        Integer n20 = 4;
        Messages.get();
        this.dtTexts.put(n20, Messages.DciLabelProvider_DT_string);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    return this.dtTexts.get(((DataCollectionItem)dci).getDataType());
                }
                Messages.get();
                return Messages.DciLabelProvider_Table;
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    Messages.get();
                    return Messages.DciLabelProvider_CustomSchedule;
                }
                if (dci.getPollingInterval() <= 0) {
                    Messages.get();
                    return Messages.DciLabelProvider_Default;
                }
                return Integer.toString(dci.getPollingInterval());
            }
            case 6: {
                String string;
                if ((dci.getFlags() & 0x200) != 0) {
                    Messages.get();
                    return Messages.DciLabelProvider_None;
                }
                int days = dci.getRetentionTime();
                if (days <= 0) {
                    Messages.get();
                    return Messages.DciLabelProvider_Default;
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Integer.toString(days)));
                if (days == 1) {
                    Messages.get();
                    string = Messages.DciLabelProvider_Day;
                } else {
                    Messages.get();
                    string = Messages.DciLabelProvider_Days;
                }
                return stringBuilder.append(string).toString();
            }
            case 7: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                int i;
                List list;
                StringBuilder thresholds = new StringBuilder();
                if (dci instanceof DataCollectionItem) {
                    list = ((DataCollectionItem)dci).getThresholds();
                    i = 0;
                    while (i < ((ArrayList)list).size()) {
                        Threshold tr = (Threshold)((ArrayList)list).get(i);
                        thresholds.append(tr.getTextualRepresentation());
                        if (i < ((ArrayList)list).size() - 1) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                if (dci instanceof DataCollectionTable) {
                    list = ((DataCollectionTable)dci).getThresholds();
                    i = 0;
                    while (i < list.size()) {
                        thresholds.append(((TableThreshold)list.get(i)).getConditionAsText());
                        if (i + 1 != list.size()) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                return thresholds.toString();
            }
            case 9: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(dci.getTemplateId());
                if (object == null) {
                    Messages.get();
                    return Messages.DciLabelProvider_Unknown;
                }
                if (!(object instanceof Template)) {
                    return object.getObjectName();
                }
                Set parents = object.getAllParents(null);
                StringBuilder sb = new StringBuilder();
                for (AbstractObject parent : parents) {
                    sb.append(parent.getObjectName());
                    sb.append("/");
                }
                sb.append(object.getObjectName());
                return sb.toString();
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element) {
        if (((DataCollectionObject)element).getTemplateId() != 0L) {
            return FONT_COLOR;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

