/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ColumnFilterSetOperation {
    AND(0),
    OR(1),
    UNKNOWN(2);

    private int value;
    private static Map<Integer, ColumnFilterSetOperation> lookupTable;

    static {
        lookupTable = new HashMap<Integer, ColumnFilterSetOperation>();
        ColumnFilterSetOperation[] columnFilterSetOperationArray = ColumnFilterSetOperation.values();
        int n = columnFilterSetOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnFilterSetOperation element = columnFilterSetOperationArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ColumnFilterSetOperation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ColumnFilterSetOperation getByValue(int value) {
        ColumnFilterSetOperation element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)ColumnFilterSetOperation.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

