/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.interfaces.EntityLayout;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;

public class SparseTree
implements LayoutAlgorithm {
    private static final int ROW_BINDING_DELTA = 10;
    private static final int MINIMAL_DISTANCE = 10;
    private LayoutContext context;

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    public void applyLayout(boolean clean) {
        ArrayList<EntityLayout> row;
        EntityLayout[] entitiesToLayout = this.context.getEntities();
        ArrayList<ArrayList<EntityLayout>> rows = new ArrayList<ArrayList<EntityLayout>>();
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.addToRow(rows, entitiesToLayout[i]);
            ++i;
        }
        Collections.sort(rows, new Comparator<ArrayList<EntityLayout>>(){

            @Override
            public int compare(ArrayList<EntityLayout> o1, ArrayList<EntityLayout> o2) {
                return (int)(o1.get((int)0).getLocation().y - o2.get((int)0).getLocation().y);
            }
        });
        int currRowIdx = 0;
        while (currRowIdx < rows.size()) {
            row = rows.get(currRowIdx);
            Collections.sort(row, new Comparator<EntityLayout>(){

                @Override
                public int compare(EntityLayout node1, EntityLayout node2) {
                    return (int)(node1.getLocation().x - node2.getLocation().x);
                }
            });
            int currNodeIdx = 1;
            while (currNodeIdx < row.size()) {
                EntityLayout currNode = row.get(currNodeIdx);
                EntityLayout prevNode = row.get(currNodeIdx - 1);
                double currNodePos = currNode.getLocation().x;
                double prevNodePos = prevNode.getLocation().x;
                double minimalPos = prevNodePos + prevNode.getSize().width + 10.0;
                if (currNodePos < minimalPos) {
                    currNode.setLocation(minimalPos, currNode.getLocation().y);
                }
                ++currNodeIdx;
            }
            ++currRowIdx;
        }
        currRowIdx = rows.size() - 1;
        while (currRowIdx > 0) {
            row = rows.get(currRowIdx);
            double leftmostX = row.get((int)0).getLocation().x;
            int firstChildIdx = 0;
            EntityLayout parent = this.getParentNode(row.get(0));
            int currNodeIdx = 1;
            while (currNodeIdx < row.size()) {
                EntityLayout currNode = row.get(currNodeIdx);
                EntityLayout nextParent = this.getParentNode(currNode);
                if (parent != nextParent) {
                    if (parent != null) {
                        this.centerNode(rows, currRowIdx, firstChildIdx, parent, leftmostX, row.get((int)(currNodeIdx - 1)).getLocation().x + row.get((int)(currNodeIdx - 1)).getSize().width);
                    }
                    parent = nextParent;
                    leftmostX = currNode.getLocation().x;
                    firstChildIdx = currNodeIdx;
                }
                ++currNodeIdx;
            }
            if (parent != null) {
                EntityLayout currNode = row.get(row.size() - 1);
                this.centerNode(rows, currRowIdx, firstChildIdx, parent, leftmostX, currNode.getLocation().x + currNode.getSize().width);
            }
            --currRowIdx;
        }
    }

    private EntityLayout getParentNode(EntityLayout e) {
        EntityLayout[] parents = e.getPredecessingEntities();
        return parents.length > 0 ? parents[0] : null;
    }

    private void centerNode(ArrayList<ArrayList<EntityLayout>> rows, int currRowIdx, int firstChildIdx, EntityLayout node, double leftmostX, double rightmostX) {
        block3: {
            double shift;
            block2: {
                double newX = leftmostX + (rightmostX - leftmostX) / 2.0 - node.getSize().width / 2.0;
                shift = newX - node.getLocation().x;
                if (!(shift > 0.0)) break block2;
                ArrayList<EntityLayout> row = rows.get(currRowIdx - 1);
                node.setLocation(newX, node.getLocation().y);
                int index = row.indexOf(node);
                if (index == -1) break block3;
                int i = index + 1;
                while (i < row.size()) {
                    EntityLayout n = row.get(i);
                    n.setLocation(n.getLocation().x + shift, n.getLocation().y);
                    ++i;
                }
                break block3;
            }
            ArrayList<EntityLayout> row = rows.get(currRowIdx);
            int i = firstChildIdx;
            while (i < row.size()) {
                EntityLayout n = row.get(i);
                n.setLocation(n.getLocation().x - shift, n.getLocation().y);
                this.shiftChildNodes(rows, currRowIdx + 1, n, -shift);
                ++i;
            }
        }
    }

    private void shiftChildNodes(ArrayList<ArrayList<EntityLayout>> rows, int currRowIdx, EntityLayout parent, double shift) {
        if (rows.size() <= currRowIdx) {
            return;
        }
        ArrayList<EntityLayout> row = rows.get(currRowIdx);
        for (EntityLayout n : row) {
            if (this.getParentNode(n) != parent) continue;
            n.setLocation(n.getLocation().x + shift, n.getLocation().y);
            this.shiftChildNodes(rows, currRowIdx + 1, n, shift);
        }
    }

    private void addToRow(ArrayList<ArrayList<EntityLayout>> rows, EntityLayout node) {
        double nodeY = node.getLocation().y;
        for (ArrayList<EntityLayout> row : rows) {
            double rowY = row.get((int)0).getLocation().y;
            if (!(Math.abs(nodeY - rowY) <= 10.0)) continue;
            row.add(node);
            return;
        }
        ArrayList<EntityLayout> newRow = new ArrayList<EntityLayout>();
        newRow.add(node);
        rows.add(newRow);
    }
}

