/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.objecttabs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.perfview.objecttabs.internal.PerfTabGraph;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.widgets.AnimatedImage;

public class PerformanceTab
extends ObjectTab {
    private Map<String, PerfTabGraph> charts = new HashMap<String, PerfTabGraph>();
    private ScrolledComposite scroller;
    private Composite chartArea;
    private AnimatedImage waitingImage = null;

    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.chartArea = new Composite((Composite)this.scroller, 0);
        this.chartArea.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.chartArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.chartArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PerformanceTab.this.scroller.getClientArea();
                PerformanceTab.this.scroller.setMinSize(PerformanceTab.this.chartArea.computeSize(r.width, -1));
            }
        });
    }

    public void objectChanged(final AbstractObject object) {
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        if (object == null) {
            return;
        }
        if (this.waitingImage != null) {
            this.waitingImage.dispose();
        }
        this.waitingImage = new AnimatedImage(this.chartArea, 0);
        this.waitingImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 2, 1));
        try {
            this.waitingImage.setImage(new URL("platform:/plugin/org.netxms.ui.eclipse.console/icons/loading.gif"));
        }
        catch (MalformedURLException malformedURLException) {}
        this.updateChartAreaLayout();
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        Job job = new Job(Messages.PerformanceTab_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final PerfTabDci[] items = session.getPerfTabItems(object.getObjectId());
                    Display display = PerformanceTab.this.getClientArea().getDisplay();
                    Messages.get();
                    new UIJob(display, Messages.PerformanceTab_JobName){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!PerformanceTab.this.getClientArea().isDisposed() && PerformanceTab.this.getObject() != null && PerformanceTab.this.getObject().getObjectId() == object.getObjectId()) {
                                PerformanceTab.this.update(items);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (Exception e) {
                    Activator.logError("Exception in performance tab loading job", e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void update(PerfTabDci[] items) {
        if (this.waitingImage != null) {
            this.waitingImage.dispose();
            this.waitingImage = null;
        }
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        ArrayList<PerfTabGraphSettings> settings = new ArrayList<PerfTabGraphSettings>(items.length);
        int i = 0;
        while (i < items.length) {
            try {
                PerfTabGraphSettings s = PerfTabGraphSettings.createFromXml(items[i].getPerfTabSettings());
                if (s.isEnabled()) {
                    s.setRuntimeDciInfo(items[i]);
                    settings.add(s);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        Collections.sort(settings, new Comparator<PerfTabGraphSettings>(){

            @Override
            public int compare(PerfTabGraphSettings o1, PerfTabGraphSettings o2) {
                int result = Integer.signum(o1.getOrder() - o2.getOrder());
                if (result == 0) {
                    result = o1.getGroupName().compareToIgnoreCase(o2.getGroupName());
                }
                if (result == 0) {
                    result = o1.getGroupName().isEmpty() ? o1.getRuntimeTitle().compareToIgnoreCase(o2.getRuntimeTitle()) : o1.getRuntimeName().compareToIgnoreCase(o2.getRuntimeName());
                }
                return result;
            }
        });
        for (PerfTabGraphSettings s : settings) {
            PerfTabGraph chart;
            String groupName = s.getGroupName();
            PerfTabGraph perfTabGraph = chart = groupName.isEmpty() ? null : this.charts.get(groupName);
            if (chart == null) {
                chart = new PerfTabGraph(this.chartArea, this.getObject().getObjectId(), s.getRuntimeDciInfo(), s, (IViewPart)this.getViewPart(), new VisibilityValidator(){

                    public boolean isVisible() {
                        return PerformanceTab.this.isActive();
                    }
                });
                this.charts.put(groupName.isEmpty() ? "##" + Long.toString(s.getRuntimeDciInfo().getId()) : groupName, chart);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.heightHint = 320;
                chart.setLayoutData(gd);
                continue;
            }
            chart.addItem(s.getRuntimeDciInfo(), s);
        }
        for (PerfTabGraph chart : this.charts.values()) {
            chart.start();
        }
        this.updateChartAreaLayout();
    }

    private void updateChartAreaLayout() {
        this.chartArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.chartArea.computeSize(r.width, -1));
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof AbstractNode || object instanceof Cluster || object instanceof MobileDevice;
    }

    public void selected() {
        super.selected();
        for (PerfTabGraph chart : this.charts.values()) {
            chart.refreshData();
        }
    }
}

