/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class MaintanenceScheduleDialog
extends Dialog {
    private Date startDate;
    private Date endDate;
    private String comments;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private Label labelStartDate;
    private Label labelEndDate;
    private LabeledText commentsEditor;

    public MaintanenceScheduleDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.MaintanenceScheduleDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.labelStartDate = new Label(dialogArea, 0);
        Messages.get();
        this.labelStartDate.setText(Messages.MaintanenceScheduleDialog_StartDate);
        this.startDateSelector = new DateTimeSelector(dialogArea, 0);
        this.startDateSelector.setValue(new Date());
        Messages.get();
        this.startDateSelector.setToolTipText(Messages.MaintanenceScheduleDialog_StartDate);
        this.labelEndDate = new Label(dialogArea, 0);
        Messages.get();
        this.labelEndDate.setText(Messages.MaintanenceScheduleDialog_EndDate);
        this.endDateSelector = new DateTimeSelector(dialogArea, 0);
        this.endDateSelector.setValue(new Date());
        Messages.get();
        this.startDateSelector.setToolTipText(Messages.MaintanenceScheduleDialog_EndDate);
        this.commentsEditor = new LabeledText(dialogArea, 0);
        this.commentsEditor.setLabel("Comments");
        this.commentsEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        this.startDate = this.startDateSelector.getValue();
        this.endDate = this.endDateSelector.getValue();
        this.comments = this.commentsEditor.getText();
        if (this.startDate.after(this.endDate)) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.MaintanenceScheduleDialog_Warning, (String)Messages.MaintanenceScheduleDialog_WarningText);
            return;
        }
        super.okPressed();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getComments() {
        return this.comments;
    }
}

