/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class InterfaceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String[] ifaceExpectedState;
    private AbstractNode node = null;
    private NXCSession session = ConsoleSharedData.getSession();

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.InterfaceListLabelProvider_StateUp;
        Messages.get();
        stringArray[1] = Messages.InterfaceListLabelProvider_StateDown;
        Messages.get();
        stringArray[2] = Messages.InterfaceListLabelProvider_StateIgnore;
        Messages.get();
        stringArray[3] = Messages.InterfaceListLabelProvider_Auto;
        ifaceExpectedState = stringArray;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.node == null) {
            return null;
        }
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 22: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xBackendStateAsText();
                }
                return null;
            }
            case 21: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xPaeStateAsText();
                }
                return null;
            }
            case 17: {
                return iface.getAdminStateAsText();
            }
            case 2: {
                return iface.getAlias();
            }
            case 9: {
                return iface.getDescription();
            }
            case 19: {
                return ifaceExpectedState[iface.getExpectedState()];
            }
            case 0: {
                return Long.toString(iface.getObjectId());
            }
            case 4: {
                return Integer.toString(iface.getIfIndex());
            }
            case 7: {
                return Integer.toString(iface.getMtu());
            }
            case 1: {
                return iface.getObjectName();
            }
            case 18: {
                return iface.getOperStateAsText();
            }
            case 6: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getPort());
                }
                return null;
            }
            case 5: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getSlot());
                }
                return null;
            }
            case 20: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)iface.getStatus());
            }
            case 3: {
                String typeName = iface.getIfTypeName();
                return typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType());
            }
            case 10: {
                return iface.getMacAddress().toString();
            }
            case 11: {
                return iface.getIpAddressListAsString();
            }
            case 13: {
                return this.getPeerName(iface);
            }
            case 14: {
                return this.getPeerMacAddress(iface);
            }
            case 15: {
                return this.getPeerIpAddress(iface);
            }
            case 16: {
                return this.getPeerProtocol(iface);
            }
            case 8: {
                return iface.getSpeed() > 0L ? InterfaceListLabelProvider.ifSpeedTotext(iface.getSpeed()) : "";
            }
            case 12: {
                return InterfaceListLabelProvider.getVlanList(iface);
            }
        }
        return null;
    }

    private String getPeerIpAddress(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        if (peer == null) {
            return null;
        }
        if (!peer.getPrimaryIP().isValidUnicastAddress()) {
            return null;
        }
        return peer.getPrimaryIP().getHostAddress();
    }

    private String getPeerMacAddress(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getMacAddress().toString() : null;
    }

    private String getPeerProtocol(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? iface.getPeerDiscoveryProtocol().toString() : null;
    }

    private String getPeerName(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : null;
    }

    public void setNode(AbstractNode node) {
        this.node = node;
    }

    public Color getForeground(Object element, int columnIndex) {
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 20: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)iface.getStatus());
            }
            case 18: {
                switch (iface.getOperState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)(iface.getAdminState() == 2 ? ObjectStatus.DISABLED : ObjectStatus.CRITICAL));
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                    case 4: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.MINOR);
                    }
                    case 5: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
            case 17: {
                switch (iface.getAdminState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    private static String divideSpeed(long speed, int power) {
        String s = Long.toString(speed);
        StringBuilder sb = new StringBuilder(s.substring(0, s.length() - power));
        char[] rem = s.substring(s.length() - power, s.length()).toCharArray();
        int l = rem.length - 1;
        while (l >= 0 && rem[l] == '0') {
            --l;
        }
        if (l >= 0) {
            sb.append('.');
            int i = 0;
            while (i <= l) {
                sb.append(rem[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String ifSpeedTotext(long speed) {
        if (speed < 1000L) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(speed)));
            Messages.get();
            return stringBuilder.append(Messages.InterfaceListLabelProvider_bps).toString();
        }
        if (speed < 1000000L) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(InterfaceListLabelProvider.divideSpeed(speed, 3)));
            Messages.get();
            return stringBuilder.append(Messages.InterfaceListLabelProvider_Kbps).toString();
        }
        if (speed < 1000000000L) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(InterfaceListLabelProvider.divideSpeed(speed, 6)));
            Messages.get();
            return stringBuilder.append(Messages.InterfaceListLabelProvider_Mbps).toString();
        }
        if (speed < 1000000000000L) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(InterfaceListLabelProvider.divideSpeed(speed, 9)));
            Messages.get();
            return stringBuilder.append(Messages.InterfaceListLabelProvider_Gbps).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(InterfaceListLabelProvider.divideSpeed(speed, 12)));
        Messages.get();
        return stringBuilder.append(Messages.InterfaceListLabelProvider_Tbps).toString();
    }

    private static String getVlanList(Interface iface) {
        long[] vlans = iface.getVlans();
        if (vlans.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(vlans[0]);
        int i = 1;
        while (i < vlans.length) {
            sb.append(", ");
            sb.append(vlans[i]);
            ++i;
        }
        return sb.toString();
    }
}

