/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDPublic;
import com.wutka.dtd.DTDSequence;
import com.wutka.dtd.DTDSystem;
import com.wutka.dtd.EntityExpansion;
import com.wutka.dtd.Scanner;
import com.wutka.dtd.Token;
import com.wutka.dtd.TokenType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class DTDParser
implements EntityExpansion {
    protected Scanner scanner;
    protected DTD dtd;
    protected Object defaultLocation;

    public DTDParser(Reader in) {
        this.scanner = new Scanner(in, false, this);
        this.dtd = new DTD();
    }

    public DTDParser(Reader in, boolean trace2) {
        this.scanner = new Scanner(in, trace2, this);
        this.dtd = new DTD();
    }

    public DTDParser(File in) throws IOException {
        this.defaultLocation = in.getParentFile();
        this.scanner = new Scanner(new BufferedReader(new FileReader(in)), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(File in, boolean trace2) throws IOException {
        this.defaultLocation = in.getParentFile();
        this.scanner = new Scanner(new BufferedReader(new FileReader(in)), trace2, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL in) throws IOException {
        String file = in.getFile();
        this.defaultLocation = new URL(in.getProtocol(), in.getHost(), in.getPort(), file.substring(0, file.lastIndexOf(47) + 1));
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(in.openStream())), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL in, boolean trace2) throws IOException {
        String file = in.getFile();
        this.defaultLocation = new URL(in.getProtocol(), in.getHost(), in.getPort(), file.substring(0, file.lastIndexOf(47) + 1));
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(in.openStream())), trace2, this);
        this.dtd = new DTD();
    }

    public DTD parse() throws IOException {
        return this.parse(false);
    }

    public DTD parse(boolean guessRootElement) throws IOException {
        while (true) {
            Token token2 = this.scanner.peek();
            if (token2.type == Scanner.EOF) break;
            this.parseTopLevelElement();
        }
        if (guessRootElement) {
            DTDElement element;
            Hashtable<String, DTDElement> roots = new Hashtable<String, DTDElement>();
            Enumeration e = this.dtd.elements.elements();
            while (e.hasMoreElements()) {
                element = (DTDElement)e.nextElement();
                roots.put(element.name, element);
            }
            e = this.dtd.elements.elements();
            while (e.hasMoreElements()) {
                element = (DTDElement)e.nextElement();
                if (!(element.content instanceof DTDContainer)) continue;
                Enumeration items = ((DTDContainer)element.content).getItemsVec().elements();
                while (items.hasMoreElements()) {
                    this.removeElements(roots, this.dtd, (DTDItem)items.nextElement());
                }
            }
            if (roots.size() == 1) {
                e = roots.elements();
                this.dtd.rootElement = (DTDElement)e.nextElement();
            } else {
                this.dtd.rootElement = null;
            }
        } else {
            this.dtd.rootElement = null;
        }
        return this.dtd;
    }

    protected void removeElements(Hashtable h, DTD dtd, DTDItem item) {
        if (item instanceof DTDName) {
            h.remove(((DTDName)item).value);
        } else if (item instanceof DTDContainer) {
            Enumeration e = ((DTDContainer)item).getItemsVec().elements();
            while (e.hasMoreElements()) {
                this.removeElements(h, dtd, (DTDItem)e.nextElement());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseTopLevelElement() throws IOException {
        Token token2 = this.scanner.get();
        if (token2.type == Scanner.LTQUES) {
            StringBuffer textBuffer = new StringBuffer();
            while (true) {
                String text2 = this.scanner.getUntil('?');
                textBuffer.append(text2);
                token2 = this.scanner.peek();
                if (token2.type == Scanner.GT) break;
                textBuffer.append('?');
            }
            this.scanner.get();
            DTDProcessingInstruction instruct = new DTDProcessingInstruction(textBuffer.toString());
            this.dtd.items.addElement(instruct);
            return;
        }
        if (token2.type == Scanner.CONDITIONAL) {
            token2 = this.expect(Scanner.IDENTIFIER);
            if (token2.value.equals("IGNORE")) {
                this.scanner.skipConditional();
                return;
            } else {
                if (!token2.value.equals("INCLUDE")) throw new DTDParseException(this.scanner.getUriId(), "Invalid token in conditional: " + token2.value, this.scanner.getLineNumber(), this.scanner.getColumn());
                this.scanner.skipUntil('[');
            }
            return;
        } else {
            if (token2.type == Scanner.ENDCONDITIONAL) return;
            if (token2.type == Scanner.COMMENT) {
                this.dtd.items.addElement(new DTDComment(token2.value));
                return;
            } else {
                if (token2.type != Scanner.LTBANG) throw new DTDParseException(this.scanner.getUriId(), "Unexpected token: " + token2.type.name + "(" + token2.value + ")", this.scanner.getLineNumber(), this.scanner.getColumn());
                token2 = this.expect(Scanner.IDENTIFIER);
                if (token2.value.equals("ELEMENT")) {
                    this.parseElement();
                    return;
                } else if (token2.value.equals("ATTLIST")) {
                    this.parseAttlist();
                    return;
                } else if (token2.value.equals("ENTITY")) {
                    this.parseEntity();
                    return;
                } else if (token2.value.equals("NOTATION")) {
                    this.parseNotation();
                    return;
                } else {
                    this.skipUntil(Scanner.GT);
                }
            }
        }
    }

    protected void skipUntil(TokenType stopToken) throws IOException {
        Token token2 = this.scanner.get();
        while (token2.type != stopToken) {
            token2 = this.scanner.get();
        }
    }

    protected Token expect(TokenType expected) throws IOException {
        Token token2 = this.scanner.get();
        if (token2.type != expected) {
            if (token2.value == null) {
                throw new DTDParseException(this.scanner.getUriId(), "Expected " + expected.name + " instead of " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            throw new DTDParseException(this.scanner.getUriId(), "Expected " + expected.name + " instead of " + token2.type.name + "(" + token2.value + ")", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        return token2;
    }

    protected void parseElement() throws IOException {
        Token name = this.expect(Scanner.IDENTIFIER);
        DTDElement element = (DTDElement)this.dtd.elements.get(name.value);
        if (element == null) {
            element = new DTDElement(name.value);
            this.dtd.elements.put(element.name, element);
        } else if (element.content != null) {
            throw new DTDParseException(this.scanner.getUriId(), "Found second definition of element: " + name.value, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        this.dtd.items.addElement(element);
        this.parseContentSpec(this.scanner, element);
        this.expect(Scanner.GT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseContentSpec(Scanner scanner2, DTDElement element) throws IOException {
        Token token2 = scanner2.get();
        if (token2.type == Scanner.IDENTIFIER) {
            if (token2.value.equals("EMPTY")) {
                element.content = new DTDEmpty();
                return;
            } else {
                if (!token2.value.equals("ANY")) throw new DTDParseException(scanner2.getUriId(), "Invalid token in entity content spec " + token2.value, scanner2.getLineNumber(), scanner2.getColumn());
                element.content = new DTDAny();
            }
            return;
        } else {
            if (token2.type != Scanner.LPAREN) return;
            token2 = scanner2.peek();
            if (token2.type == Scanner.IDENTIFIER) {
                if (token2.value.equals("#PCDATA")) {
                    this.parseMixed(element);
                    return;
                } else {
                    this.parseChildren(element);
                }
                return;
            } else {
                if (token2.type != Scanner.LPAREN) return;
                this.parseChildren(element);
            }
        }
    }

    protected void parseMixed(DTDElement element) throws IOException {
        Token token2;
        boolean isPcdataOnly = true;
        DTDMixed mixed = new DTDMixed();
        mixed.add(new DTDPCData());
        this.scanner.get();
        element.content = mixed;
        while (true) {
            token2 = this.scanner.get();
            if (token2.type == Scanner.RPAREN) {
                token2 = this.scanner.peek();
                if (token2.type == Scanner.ASTERISK) {
                    this.scanner.get();
                    mixed.cardinal = DTDCardinal.ZEROMANY;
                } else {
                    if (!isPcdataOnly) {
                        throw new DTDParseException(this.scanner.getUriId(), "Invalid token in Mixed content type, '*' required after (#PCDATA|xx ...): " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
                    }
                    mixed.cardinal = DTDCardinal.NONE;
                }
                return;
            }
            if (token2.type != Scanner.PIPE) break;
            token2 = this.scanner.get();
            mixed.add(new DTDName(token2.value));
            isPcdataOnly = false;
        }
        throw new DTDParseException(this.scanner.getUriId(), "Invalid token in Mixed content type: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected void parseChildren(DTDElement element) throws IOException {
        DTDContainer choiceSeq = this.parseChoiceSequence();
        Token token2 = this.scanner.peek();
        choiceSeq.cardinal = this.parseCardinality();
        choiceSeq.cardinal = token2.type == Scanner.QUES ? DTDCardinal.OPTIONAL : (token2.type == Scanner.ASTERISK ? DTDCardinal.ZEROMANY : (token2.type == Scanner.PLUS ? DTDCardinal.ONEMANY : DTDCardinal.NONE));
        element.content = choiceSeq;
    }

    protected DTDContainer parseChoiceSequence() throws IOException {
        Token token2;
        DTDItem item;
        TokenType separator = null;
        DTDContainer cs = null;
        while (true) {
            item = this.parseCP();
            token2 = this.scanner.get();
            if (token2.type != Scanner.PIPE && token2.type != Scanner.COMMA) break;
            if (separator != null && separator != token2.type) {
                throw new DTDParseException(this.scanner.getUriId(), "Can't mix separators in a choice/sequence", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            separator = token2.type;
            if (cs == null) {
                cs = token2.type == Scanner.PIPE ? new DTDChoice() : new DTDSequence();
            }
            cs.add(item);
        }
        if (token2.type == Scanner.RPAREN) {
            if (cs == null) {
                cs = new DTDSequence();
            }
            cs.add(item);
            return cs;
        }
        throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected DTDItem parseCP() throws IOException {
        Token token2 = this.scanner.get();
        DTDItem item = null;
        if (token2.type == Scanner.IDENTIFIER) {
            item = new DTDName(token2.value);
        } else if (token2.type == Scanner.LPAREN) {
            item = this.parseChoiceSequence();
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        item.cardinal = this.parseCardinality();
        return item;
    }

    protected DTDCardinal parseCardinality() throws IOException {
        Token token2 = this.scanner.peek();
        if (token2.type == Scanner.QUES) {
            this.scanner.get();
            return DTDCardinal.OPTIONAL;
        }
        if (token2.type == Scanner.ASTERISK) {
            this.scanner.get();
            return DTDCardinal.ZEROMANY;
        }
        if (token2.type == Scanner.PLUS) {
            this.scanner.get();
            return DTDCardinal.ONEMANY;
        }
        return DTDCardinal.NONE;
    }

    protected void parseAttlist() throws IOException {
        Token token2 = this.expect(Scanner.IDENTIFIER);
        DTDElement element = (DTDElement)this.dtd.elements.get(token2.value);
        DTDAttlist attlist = new DTDAttlist(token2.value);
        this.dtd.items.addElement(attlist);
        if (element == null) {
            element = new DTDElement(token2.value);
            this.dtd.elements.put(token2.value, element);
        }
        token2 = this.scanner.peek();
        while (token2.type != Scanner.GT) {
            this.parseAttdef(this.scanner, element, attlist);
            token2 = this.scanner.peek();
        }
        this.expect(Scanner.GT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseAttdef(Scanner scanner2, DTDElement element, DTDAttlist attlist) throws IOException {
        Token token2 = this.expect(Scanner.IDENTIFIER);
        DTDAttribute attr = new DTDAttribute(token2.value);
        attlist.attributes.addElement(attr);
        element.attributes.put(token2.value, attr);
        token2 = scanner2.get();
        if (token2.type == Scanner.IDENTIFIER) {
            attr.type = token2.value.equals("NOTATION") ? this.parseNotationList() : token2.value;
        } else if (token2.type == Scanner.LPAREN) {
            attr.type = this.parseEnumeration();
        }
        token2 = scanner2.peek();
        if (token2.type == Scanner.IDENTIFIER) {
            scanner2.get();
            if (token2.value.equals("#FIXED")) {
                attr.decl = DTDDecl.FIXED;
                token2 = scanner2.get();
                attr.defaultValue = token2.value;
                return;
            } else if (token2.value.equals("#REQUIRED")) {
                attr.decl = DTDDecl.REQUIRED;
                return;
            } else {
                if (!token2.value.equals("#IMPLIED")) throw new DTDParseException(scanner2.getUriId(), "Invalid token in attribute declaration: " + token2.value, scanner2.getLineNumber(), scanner2.getColumn());
                attr.decl = DTDDecl.IMPLIED;
            }
            return;
        } else {
            if (token2.type != Scanner.STRING) return;
            scanner2.get();
            attr.decl = DTDDecl.VALUE;
            attr.defaultValue = token2.value;
        }
    }

    protected DTDNotationList parseNotationList() throws IOException {
        DTDNotationList notation = new DTDNotationList();
        Token token2 = this.scanner.get();
        if (token2.type != Scanner.LPAREN) {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        while (true) {
            token2 = this.scanner.get();
            if (token2.type != Scanner.IDENTIFIER) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            notation.add(token2.value);
            token2 = this.scanner.peek();
            if (token2.type == Scanner.RPAREN) {
                this.scanner.get();
                return notation;
            }
            if (token2.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected DTDEnumeration parseEnumeration() throws IOException {
        DTDEnumeration enumeration = new DTDEnumeration();
        while (true) {
            Token token2 = this.scanner.get();
            if (token2.type != Scanner.IDENTIFIER && token2.type != Scanner.NMTOKEN) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            enumeration.add(token2.value);
            token2 = this.scanner.peek();
            if (token2.type == Scanner.RPAREN) {
                this.scanner.get();
                return enumeration;
            }
            if (token2.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token2.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected void parseEntity() throws IOException {
        boolean isParsed = false;
        Token name = this.scanner.get();
        if (name.type == Scanner.PERCENT) {
            isParsed = true;
            name = this.expect(Scanner.IDENTIFIER);
        } else if (name.type != Scanner.IDENTIFIER) {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        DTDEntity entity = (DTDEntity)this.dtd.entities.get(name.value);
        boolean skip = false;
        if (entity == null) {
            entity = new DTDEntity(name.value, this.defaultLocation);
            this.dtd.entities.put(entity.name, entity);
        } else {
            entity = new DTDEntity(name.value, this.defaultLocation);
            skip = true;
        }
        this.dtd.items.addElement(entity);
        entity.isParsed = isParsed;
        this.parseEntityDef(entity);
        if (entity.isParsed && entity.value != null && !skip) {
            this.scanner.addEntity(entity.name, entity.value);
        }
    }

    protected void parseEntityDef(DTDEntity entity) throws IOException {
        Token token2 = this.scanner.get();
        if (token2.type == Scanner.STRING) {
            if (entity.value == null) {
                entity.value = token2.value;
            }
        } else if (token2.type == Scanner.IDENTIFIER) {
            if (token2.value.equals("SYSTEM")) {
                DTDSystem sys = new DTDSystem();
                token2 = this.expect(Scanner.STRING);
                sys.system = token2.value;
                entity.externalID = sys;
            } else if (token2.value.equals("PUBLIC")) {
                DTDPublic pub = new DTDPublic();
                token2 = this.expect(Scanner.STRING);
                pub.pub = token2.value;
                token2 = this.expect(Scanner.STRING);
                pub.system = token2.value;
                entity.externalID = pub;
            } else {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid External ID specification", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            if (!entity.isParsed) {
                token2 = this.scanner.peek();
                if (token2.type == Scanner.IDENTIFIER) {
                    if (!token2.value.equals("NDATA")) {
                        throw new DTDParseException(this.scanner.getUriId(), "Invalid NData declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
                    }
                    token2 = this.scanner.get();
                    token2 = this.expect(Scanner.IDENTIFIER);
                    entity.ndata = token2.value;
                }
            }
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity definition", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        this.expect(Scanner.GT);
    }

    protected void parseNotation() throws IOException {
        DTDNotation notation = new DTDNotation();
        Token token2 = this.expect(Scanner.IDENTIFIER);
        notation.name = token2.value;
        this.dtd.notations.put(notation.name, notation);
        this.dtd.items.addElement(notation);
        token2 = this.expect(Scanner.IDENTIFIER);
        if (token2.value.equals("SYSTEM")) {
            DTDSystem sys = new DTDSystem();
            token2 = this.expect(Scanner.STRING);
            sys.system = token2.value;
            notation.externalID = sys;
        } else if (token2.value.equals("PUBLIC")) {
            DTDPublic pub = new DTDPublic();
            token2 = this.expect(Scanner.STRING);
            pub.pub = token2.value;
            pub.system = null;
            token2 = this.scanner.peek();
            if (token2.type == Scanner.STRING) {
                token2 = this.scanner.get();
                pub.system = token2.value;
            }
            notation.externalID = pub;
        }
        this.expect(Scanner.GT);
    }

    public DTDEntity expandEntity(String name) {
        return (DTDEntity)this.dtd.entities.get(name);
    }
}

