/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member;

import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.member.AbstractMemberExpression;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.MemberExpressionEvaluatorVisitor;

public class ObjectKeyExpression
extends AbstractMemberExpression {
    private String objectKey;
    private boolean isWildcard;

    public ObjectKeyExpression(MemberExpression.DIRECTION direction) {
        this.isWildcard = true;
        this.setDirection(direction);
    }

    public ObjectKeyExpression(MemberExpression.DIRECTION direction, String objectKey) {
        this.objectKey = objectKey;
        this.isWildcard = false;
        this.setDirection(direction);
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer nodeContainer, MemberExpressionEvaluatorVisitor evaluator) {
        return evaluator.evaluateObjectKey(this, nodeContainer);
    }

    public String toString() {
        String result = (Object)((Object)this.getDirection()) + " " + (this.objectKey != null ? this.objectKey : "wildcard");
        if (this.getFilterExpression() != null) {
            result = result + "(" + this.getFilterExpression() + ")";
        }
        return result;
    }
}

