/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.actions;

import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.type.ZoomTypeEnum;
import net.sf.jasperreports.web.commands.Command;

public class SaveZoomCommand
implements Command {
    public static final String PROPERTY_VIEWER_ZOOM = "net.sf.jasperreports.viewer.zoom";
    private String zoomValue;
    private String oldZoomValue;
    private JasperDesign jasperDesign;

    public SaveZoomCommand(JasperDesign jasperDesign, String zoomValue) {
        this.zoomValue = zoomValue;
        this.jasperDesign = jasperDesign;
    }

    @Override
    public void execute() {
        ZoomTypeEnum zoomType;
        this.oldZoomValue = this.jasperDesign.getProperty(PROPERTY_VIEWER_ZOOM);
        if (this.oldZoomValue == null) {
            this.oldZoomValue = "1";
        }
        if ((zoomType = ZoomTypeEnum.getByName(this.zoomValue)) != null) {
            this.zoomValue = zoomType.getName();
        }
        this.jasperDesign.setProperty(PROPERTY_VIEWER_ZOOM, this.zoomValue);
    }

    @Override
    public void undo() {
        this.jasperDesign.setProperty(PROPERTY_VIEWER_ZOOM, this.oldZoomValue);
    }

    @Override
    public void redo() {
        this.jasperDesign.setProperty(PROPERTY_VIEWER_ZOOM, this.zoomValue);
    }
}

