/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringValueEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function3Arg;
import org.apache.poi.ss.formula.functions.IDStarAlgorithm;
import org.apache.poi.ss.util.NumberComparer;

public final class DStarRunner
implements Function3Arg {
    private IDStarAlgorithm algorithm;

    public DStarRunner(IDStarAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length == 3) {
            return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2]);
        }
        return ErrorEval.VALUE_INVALID;
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval database, ValueEval filterColumn, ValueEval conditionDatabase) {
        int fc;
        if (!(database instanceof TwoDEval) || !(conditionDatabase instanceof TwoDEval)) {
            return ErrorEval.VALUE_INVALID;
        }
        TwoDEval db = (TwoDEval)database;
        TwoDEval cdb = (TwoDEval)conditionDatabase;
        try {
            fc = DStarRunner.getColumnForName(filterColumn, db);
        }
        catch (EvaluationException e) {
            return ErrorEval.VALUE_INVALID;
        }
        if (fc == -1) {
            return ErrorEval.VALUE_INVALID;
        }
        this.algorithm.reset();
        for (int row = 1; row < db.getHeight(); ++row) {
            boolean matches = true;
            try {
                matches = DStarRunner.fullfillsConditions(db, row, cdb);
            }
            catch (EvaluationException e) {
                return ErrorEval.VALUE_INVALID;
            }
            if (!matches) continue;
            try {
                ValueEval currentValueEval = DStarRunner.solveReference(db.getValue(row, fc));
                boolean shouldContinue = this.algorithm.processMatch(currentValueEval);
                if (shouldContinue) continue;
                break;
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }
        return this.algorithm.getResult();
    }

    private static ValueEval solveReference(ValueEval field) throws EvaluationException {
        if (field instanceof RefEval) {
            RefEval refEval = (RefEval)field;
            if (refEval.getNumberOfSheets() > 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return DStarRunner.solveReference(refEval.getInnerValueEval(refEval.getFirstSheetIndex()));
        }
        return field;
    }

    private static int getColumnForTag(ValueEval nameValueEval, TwoDEval db) throws EvaluationException {
        int resultColumn = -1;
        if (nameValueEval instanceof NumericValueEval) {
            double doubleResultColumn = ((NumericValueEval)nameValueEval).getNumberValue();
            if (doubleResultColumn - (double)(resultColumn = (int)doubleResultColumn) != 0.0) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            --resultColumn;
        } else {
            resultColumn = DStarRunner.getColumnForName(nameValueEval, db);
        }
        return resultColumn;
    }

    private static int getColumnForName(ValueEval nameValueEval, TwoDEval db) throws EvaluationException {
        String name = DStarRunner.getStringFromValueEval(nameValueEval);
        return DStarRunner.getColumnForString(db, name);
    }

    private static int getColumnForString(TwoDEval db, String name) throws EvaluationException {
        int resultColumn = -1;
        for (int column = 0; column < db.getWidth(); ++column) {
            ValueEval columnNameValueEval = db.getValue(0, column);
            String columnName = DStarRunner.getStringFromValueEval(columnNameValueEval);
            if (!name.equals(columnName)) continue;
            resultColumn = column;
            break;
        }
        return resultColumn;
    }

    private static boolean fullfillsConditions(TwoDEval db, int row, TwoDEval cdb) throws EvaluationException {
        for (int conditionRow = 1; conditionRow < cdb.getHeight(); ++conditionRow) {
            boolean matches = true;
            for (int column = 0; column < cdb.getWidth(); ++column) {
                boolean columnCondition = true;
                ValueEval condition = null;
                try {
                    condition = DStarRunner.solveReference(cdb.getValue(conditionRow, column));
                }
                catch (RuntimeException e) {
                    columnCondition = false;
                }
                if (condition instanceof BlankEval) continue;
                ValueEval targetHeader = DStarRunner.solveReference(cdb.getValue(0, column));
                if (!((targetHeader = DStarRunner.solveReference(targetHeader)) instanceof StringValueEval)) {
                    columnCondition = false;
                } else if (DStarRunner.getColumnForName(targetHeader, db) == -1) {
                    columnCondition = false;
                }
                if (columnCondition) {
                    String conditionString;
                    ValueEval target = db.getValue(row, DStarRunner.getColumnForName(targetHeader, db));
                    if (DStarRunner.testNormalCondition(target, conditionString = DStarRunner.getStringFromValueEval(condition))) continue;
                    matches = false;
                    break;
                }
                throw new NotImplementedException("D* function with formula conditions");
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private static boolean testNormalCondition(ValueEval value, String condition) throws EvaluationException {
        if (condition.startsWith("<")) {
            String number = condition.substring(1);
            if (number.startsWith("=")) {
                number = number.substring(1);
                return DStarRunner.testNumericCondition(value, operator.smallerEqualThan, number);
            }
            return DStarRunner.testNumericCondition(value, operator.smallerThan, number);
        }
        if (condition.startsWith(">")) {
            String number = condition.substring(1);
            if (number.startsWith("=")) {
                number = number.substring(1);
                return DStarRunner.testNumericCondition(value, operator.largerEqualThan, number);
            }
            return DStarRunner.testNumericCondition(value, operator.largerThan, number);
        }
        if (condition.startsWith("=")) {
            String stringOrNumber = condition.substring(1);
            boolean itsANumber = false;
            try {
                Integer.parseInt(stringOrNumber);
                itsANumber = true;
            }
            catch (NumberFormatException e) {
                try {
                    Double.parseDouble(stringOrNumber);
                    itsANumber = true;
                }
                catch (NumberFormatException e2) {
                    itsANumber = false;
                }
            }
            if (itsANumber) {
                return DStarRunner.testNumericCondition(value, operator.equal, stringOrNumber);
            }
            String valueString = DStarRunner.getStringFromValueEval(value);
            return stringOrNumber.equals(valueString);
        }
        String valueString = DStarRunner.getStringFromValueEval(value);
        return valueString.startsWith(condition);
    }

    private static boolean testNumericCondition(ValueEval valueEval, operator op, String condition) throws EvaluationException {
        if (!(valueEval instanceof NumericValueEval)) {
            return false;
        }
        double value = ((NumericValueEval)valueEval).getNumberValue();
        double conditionValue = 0.0;
        try {
            int intValue = Integer.parseInt(condition);
            conditionValue = intValue;
        }
        catch (NumberFormatException e) {
            try {
                conditionValue = Double.parseDouble(condition);
            }
            catch (NumberFormatException e2) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
        }
        int result = NumberComparer.compare(value, conditionValue);
        switch (op) {
            case largerThan: {
                return result > 0;
            }
            case largerEqualThan: {
                return result >= 0;
            }
            case smallerThan: {
                return result < 0;
            }
            case smallerEqualThan: {
                return result <= 0;
            }
            case equal: {
                return result == 0;
            }
        }
        return false;
    }

    private static String getStringFromValueEval(ValueEval value) throws EvaluationException {
        if ((value = DStarRunner.solveReference(value)) instanceof BlankEval) {
            return "";
        }
        if (!(value instanceof StringValueEval)) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ((StringValueEval)value).getStringValue();
    }

    private static enum operator {
        largerThan,
        largerEqualThan,
        smallerThan,
        smallerEqualThan,
        equal;

    }
}

