/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GaugeConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Gauge
extends PropertyPage {
    private GaugeConfig config;
    private Combo gaugeType;
    private LabeledText fontName;
    private Button checkLegendInside;
    private Button checkVertical;
    private Button checkElementBorders;
    private LabeledText minValue;
    private LabeledText maxValue;
    private LabeledText leftYellowZone;
    private LabeledText leftRedZone;
    private LabeledText rightYellowZone;
    private LabeledText rightRedZone;
    private Combo colorMode;
    private ColorSelector customColor;
    private ObjectSelector drillDownObject;

    protected Control createContents(Composite parent) {
        this.config = (GaugeConfig)this.getElement().getAdapter(GaugeConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        Messages.get();
        this.gaugeType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.Gauge_Type, (Object)gd);
        Messages.get();
        this.gaugeType.add(Messages.Gauge_Dial);
        Messages.get();
        this.gaugeType.add(Messages.Gauge_Bar);
        Messages.get();
        this.gaugeType.add(Messages.Gauge_Text);
        this.gaugeType.select(this.config.getGaugeType());
        this.fontName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.fontName.setLabel(Messages.Gauge_FontName);
        this.fontName.setText(this.config.getFontName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fontName.setLayoutData((Object)gd);
        this.minValue = new LabeledText(dialogArea, 0);
        Messages.get();
        this.minValue.setLabel(Messages.DialChart_MinVal);
        this.minValue.setText(Double.toString(this.config.getMinValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.minValue.setLayoutData((Object)gd);
        this.maxValue = new LabeledText(dialogArea, 0);
        Messages.get();
        this.maxValue.setLabel(Messages.DialChart_MaxVal);
        this.maxValue.setText(Double.toString(this.config.getMaxValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxValue.setLayoutData((Object)gd);
        this.leftRedZone = new LabeledText(dialogArea, 0);
        Messages.get();
        this.leftRedZone.setLabel(Messages.DialChart_LeftRed);
        this.leftRedZone.setText(Double.toString(this.config.getLeftRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftRedZone.setLayoutData((Object)gd);
        this.leftYellowZone = new LabeledText(dialogArea, 0);
        Messages.get();
        this.leftYellowZone.setLabel(Messages.DialChart_LeftYellow);
        this.leftYellowZone.setText(Double.toString(this.config.getLeftYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftYellowZone.setLayoutData((Object)gd);
        this.rightYellowZone = new LabeledText(dialogArea, 0);
        Messages.get();
        this.rightYellowZone.setLabel(Messages.DialChart_RightYellow);
        this.rightYellowZone.setText(Double.toString(this.config.getRightYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightYellowZone.setLayoutData((Object)gd);
        this.rightRedZone = new LabeledText(dialogArea, 0);
        Messages.get();
        this.rightRedZone.setLabel(Messages.DialChart_RightRed);
        this.rightRedZone.setText(Double.toString(this.config.getRightRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.rightRedZone.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.colorMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.Gauge_ColorMode, (Object)gd);
        Messages.get();
        this.colorMode.add(Messages.Gauge_ZoneColor);
        Messages.get();
        this.colorMode.add(Messages.Gauge_FixedCustomColor);
        Messages.get();
        this.colorMode.add(Messages.Gauge_ActiveThresholdColor);
        this.colorMode.select(this.config.getColorMode());
        this.colorMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Gauge.this.onColorModeChange(Gauge.this.colorMode.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        Messages.get();
        this.customColor = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)Messages.Gauge_CustomColor, (Object)gd);
        this.customColor.setColorValue(ColorConverter.rgbFromInt((int)this.config.getCustomColor()));
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel("Drill-down object");
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drillDownObject.setObjectId(this.config.getDrillDownObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.drillDownObject.setLayoutData((Object)gd);
        this.checkLegendInside = new Button(dialogArea, 32);
        Messages.get();
        this.checkLegendInside.setText(Messages.DialChart_LegendInside);
        this.checkLegendInside.setSelection(this.config.isLegendInside());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkLegendInside.setLayoutData((Object)gd);
        this.checkVertical = new Button(dialogArea, 32);
        Messages.get();
        this.checkVertical.setText(Messages.Gauge_Vertical);
        this.checkVertical.setSelection(this.config.isVertical());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkVertical.setLayoutData((Object)gd);
        this.checkElementBorders = new Button(dialogArea, 32);
        Messages.get();
        this.checkElementBorders.setText(Messages.Gauge_ShowBorder);
        this.checkElementBorders.setSelection(this.config.isElementBordersVisible());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkElementBorders.setLayoutData((Object)gd);
        this.onColorModeChange(this.config.getColorMode());
        return dialogArea;
    }

    public boolean performOk() {
        double rr;
        double ry;
        double lr;
        double ly;
        double max;
        double min;
        try {
            min = Double.parseDouble(this.minValue.getText().trim());
            max = Double.parseDouble(this.maxValue.getText().trim());
            ly = Double.parseDouble(this.leftYellowZone.getText().trim());
            lr = Double.parseDouble(this.leftRedZone.getText().trim());
            ry = Double.parseDouble(this.rightYellowZone.getText().trim());
            rr = Double.parseDouble(this.rightRedZone.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.DialChart_Warning, (String)Messages.DialChart_WarningText);
            return false;
        }
        this.config.setGaugeType(this.gaugeType.getSelectionIndex());
        this.config.setFontName(this.fontName.getText().trim());
        this.config.setMinValue(min);
        this.config.setMaxValue(max);
        this.config.setLeftYellowZone(ly);
        this.config.setLeftRedZone(lr);
        this.config.setRightYellowZone(ry);
        this.config.setRightRedZone(rr);
        this.config.setLegendInside(this.checkLegendInside.getSelection());
        this.config.setVertical(this.checkVertical.getSelection());
        this.config.setElementBordersVisible(this.checkElementBorders.getSelection());
        this.config.setColorMode(this.colorMode.getSelectionIndex());
        this.config.setCustomColor(ColorConverter.rgbToInt((RGB)this.customColor.getColorValue()));
        this.config.setDrillDownObjectId(this.drillDownObject.getObjectId());
        return true;
    }

    private void onColorModeChange(int newMode) {
        this.leftYellowZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.leftRedZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.rightYellowZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.rightRedZone.setEnabled(newMode == GaugeColorMode.ZONE.getValue());
        this.customColor.setEnabled(newMode == GaugeColorMode.CUSTOM.getValue());
    }
}

