/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class StatusIndicatorElement
extends ElementWidget {
    private StatusIndicatorConfig config;
    private Canvas canvas;
    private ViewRefreshController refreshController;
    private Font font;
    private ObjectStatus status = ObjectStatus.UNKNOWN;
    private int xSize;
    private int ySize;
    private static final int MARGIN_X = 16;
    private static final int MARGIN_Y = 16;
    private static final int CIRCLE_SIZE = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = StatusIndicatorConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new StatusIndicatorConfig();
        }
        FillLayout layout = new FillLayout();
        this.setLayout((Layout)layout);
        this.canvas = new Canvas((Composite)this, 0x20000000);
        this.canvas.setBackground(this.colors.create(240, 240, 240));
        this.font = new Font((Device)this.getDisplay(), "Verdana", 12, 0);
        this.calcSize(parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatusIndicatorElement.this.font.dispose();
                StatusIndicatorElement.this.refreshController.dispose();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StatusIndicatorElement.this.drawContent(e);
            }
        });
        this.startRefreshTimer();
    }

    private void calcSize(DashboardControl parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(this.font);
        Point textExtent = gc.textExtent(this.config.getTitle());
        gc.dispose();
        this.xSize = 84 + textExtent.x;
        this.ySize = 68;
    }

    protected void refreshData() {
        NXCSession session = ConsoleSharedData.getSession();
        AbstractObject object = session.findObjectById(this.config.getObjectId());
        this.status = object != null ? object.getStatus() : ObjectStatus.UNKNOWN;
        this.canvas.redraw();
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController(this.viewPart, 1, new Runnable(){

            @Override
            public void run() {
                if (StatusIndicatorElement.this.isDisposed()) {
                    return;
                }
                StatusIndicatorElement.this.refreshData();
            }
        });
        this.refreshData();
    }

    public void drawContent(PaintEvent e) {
        e.gc.setAntialias(1);
        if (this.config.isFullColorRange()) {
            e.gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.status));
        } else {
            e.gc.setBackground(this.status == ObjectStatus.NORMAL ? StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL) : StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL));
        }
        e.gc.fillOval(16, 16, 36, 36);
        e.gc.setBackground(this.canvas.getBackground());
        e.gc.setFont(this.font);
        Point textExtent = e.gc.textExtent(this.config.getTitle());
        e.gc.drawText(this.config.getTitle(), 68, 34 - textExtent.y / 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.xSize, this.ySize);
    }
}

