/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.agentmanager.widgets.internal.AgentConfigDocument;
import org.netxms.ui.eclipse.agentmanager.widgets.internal.AgentConfigSourceViewerConfiguration;

public class AgentConfigEditor
extends Composite {
    private SourceViewer editor;
    private IFindReplaceTarget findReplaceTarget;

    public AgentConfigEditor(Composite parent, int style, int editorStyle) {
        this(parent, style, editorStyle, 20);
    }

    public AgentConfigEditor(Composite parent, int style, int editorStyle, int rulerWidth) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.editor = new SourceViewer((Composite)this, (IVerticalRuler)(rulerWidth > 0 ? new VerticalRuler(rulerWidth) : null), editorStyle);
        this.editor.configure((SourceViewerConfiguration)new AgentConfigSourceViewerConfiguration());
        final TextViewerUndoManager undoManager = new TextViewerUndoManager(50);
        this.editor.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.editor);
        this.findReplaceTarget = this.editor.getFindReplaceTarget();
        this.editor.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (!event.doit) {
                    return;
                }
                if (event.stateMask == SWT.MOD1) {
                    switch (event.character) {
                        case ' ': {
                            AgentConfigEditor.this.editor.doOperation(13);
                            event.doit = false;
                            break;
                        }
                        case '\u0019': {
                            undoManager.redo();
                            event.doit = false;
                            break;
                        }
                        case '\u001a': {
                            undoManager.undo();
                            event.doit = false;
                        }
                    }
                } else if (event.stateMask == 0) {
                    if (event.character == '\t' && ((AgentConfigEditor)AgentConfigEditor.this).editor.getSelectedRange().y > 0) {
                        AgentConfigEditor.this.editor.doOperation(8);
                        event.doit = false;
                    }
                } else if (event.stateMask == 131072 && event.character == '\t' && ((AgentConfigEditor)AgentConfigEditor.this).editor.getSelectedRange().y > 0) {
                    AgentConfigEditor.this.editor.doOperation(9);
                    event.doit = false;
                }
            }
        });
        StyledText control = this.editor.getTextWidget();
        control.setFont(JFaceResources.getTextFont());
        control.setWordWrap(false);
    }

    public StyledText getTextWidget() {
        return this.editor.getTextWidget();
    }

    public void setText(String text) {
        this.editor.setDocument((IDocument)new AgentConfigDocument(text));
    }

    public String getText() {
        return this.editor.getDocument().get();
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        return this.findReplaceTarget;
    }
}

