/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class InetAddressListElement {
    public static final int SUBNET = 0;
    public static final int RANGE = 1;
    private int type;
    private InetAddress baseAddress;
    private InetAddress endAddress;
    private int maskBits;
    private long zoneUIN;
    private long proxyId;

    public InetAddressListElement(InetAddress baseAddress, InetAddress endAddress, long zoneUIN, long proxyId) {
        this.type = 1;
        this.baseAddress = baseAddress;
        this.endAddress = endAddress;
        this.maskBits = 0;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
    }

    public InetAddressListElement(InetAddress baseAddress, int maskBits, long zoneUIN, long proxyId) {
        this.type = 0;
        this.baseAddress = baseAddress;
        this.endAddress = null;
        this.maskBits = maskBits;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
    }

    protected InetAddressListElement(NXCPMessage msg, long baseId) {
        this.type = msg.getFieldAsInt32(baseId);
        this.baseAddress = msg.getFieldAsInetAddress(baseId + 1L);
        if (this.type == 0) {
            this.maskBits = msg.getFieldAsInt32(baseId + 2L);
            this.endAddress = null;
        } else {
            this.endAddress = msg.getFieldAsInetAddress(baseId + 2L);
            this.maskBits = 0;
        }
        this.zoneUIN = msg.getFieldAsInt64(baseId + 3L);
        this.proxyId = msg.getFieldAsInt64(baseId + 4L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.baseAddress);
        if (this.type == 0) {
            msg.setFieldInt16(baseId + 2L, this.maskBits);
        } else {
            msg.setField(baseId + 2L, this.endAddress);
        }
        msg.setFieldInt32(baseId + 3L, (int)this.zoneUIN);
        msg.setFieldInt32(baseId + 4L, (int)this.proxyId);
    }

    public int getType() {
        return this.type;
    }

    public InetAddress getBaseAddress() {
        return this.baseAddress;
    }

    public InetAddress getEndAddress() {
        return this.endAddress;
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public long getZoneUIN() {
        return this.zoneUIN;
    }

    public long getProxyId() {
        return this.proxyId;
    }

    public String toString() {
        return "InetAddressListElement [type=" + this.type + ", baseAddress=" + this.baseAddress + ", endAddress=" + this.endAddress + ", maskBits=" + this.maskBits + ", zoneUIN=" + this.zoneUIN + ", proxyId=" + this.proxyId + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baseAddress == null ? 0 : this.baseAddress.hashCode());
        result = 31 * result + (this.endAddress == null ? 0 : this.endAddress.hashCode());
        result = 31 * result + this.maskBits;
        result = 31 * result + (int)(this.proxyId ^ this.proxyId >>> 32);
        result = 31 * result + this.type;
        result = 31 * result + (int)(this.zoneUIN ^ this.zoneUIN >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressListElement other = (InetAddressListElement)obj;
        if (this.baseAddress == null ? other.baseAddress != null : !this.baseAddress.equals(other.baseAddress)) {
            return false;
        }
        if (this.endAddress == null ? other.endAddress != null : !this.endAddress.equals(other.endAddress)) {
            return false;
        }
        if (this.maskBits != other.maskBits) {
            return false;
        }
        if (this.proxyId != other.proxyId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.zoneUIN == other.zoneUIN;
    }
}

