/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LastValues
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.view.last_values";
    private NXCSession session;
    private DataCollectionTarget dcTarget;
    private LastValuesWidget dataView;
    private Action actionRefresh;
    private Action actionAutoUpdate;
    private Action actionShowFilter;
    private boolean initShowFilter = true;
    private IDialogSettings settings;

    public void init(IViewSite site) throws PartInitException {
        String string;
        super.init(site);
        this.settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = LastValues.safeCast(this.settings.get("LastValuesView"), this.settings.getBoolean("LastValuesView"), this.initShowFilter);
        this.session = ConsoleSharedData.getSession();
        AbstractObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        this.dcTarget = obj != null && obj instanceof DataCollectionTarget ? (DataCollectionTarget)obj : null;
        Messages.get();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.LastValues_PartNamePrefix));
        if (this.dcTarget != null) {
            string = this.dcTarget.getObjectName();
        } else {
            Messages.get();
            string = Messages.LastValues_Error;
        }
        this.setPartName(stringBuilder.append(string).toString());
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.dataView = new LastValuesWidget(this, parent, 0, (AbstractObject)this.dcTarget, "LastValuesWidget", null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.dataView.setLayoutData(fd);
        this.createActions();
        this.contributeToActionBars();
        this.dataView.setFilterCloseAction(this.actionShowFilter);
        this.dataView.enableFilter(this.initShowFilter);
        this.dataView.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LastValues.this.settings.put("LastValuesView", LastValues.this.dataView.isFilterEnabled());
            }
        });
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
    }

    public void setFocus() {
        this.dataView.setFocus();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                LastValues.this.dataView.refresh();
            }
        };
        Messages.get();
        this.actionAutoUpdate = new Action(Messages.LastValues_AutoRefresh, 2){

            public void run() {
                LastValues.this.dataView.setAutoRefreshEnabled(LastValues.this.actionAutoUpdate.isChecked());
            }
        };
        this.actionAutoUpdate.setChecked(this.dataView.isAutoRefreshEnabled());
        Messages.get();
        this.actionShowFilter = new Action(Messages.LastValues_ShowFilter, 2){

            public void run() {
                LastValues.this.dataView.enableFilter(!LastValues.this.dataView.isFilterEnabled());
                LastValues.this.actionShowFilter.setChecked(LastValues.this.dataView.isFilterEnabled());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionAutoUpdate);
        manager.add((IAction)this.dataView.getActionUseMultipliers());
        manager.add((IAction)this.dataView.getActionShowErrors());
        manager.add((IAction)this.dataView.getActionShowDisabled());
        manager.add((IAction)this.dataView.getActionShowUnsupported());
        manager.add((IAction)this.dataView.getActionShowHidden());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }
}

