/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.EditObjectPropertyDialog;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.ObjectPropertiesLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectDetailsConfig;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectDetailsPropertyList
extends PropertyPage {
    private ObjectDetailsConfig config;
    private List<ObjectDetailsConfig.ObjectProperty> properties;
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    protected Control createContents(Composite parent) {
        this.config = (ObjectDetailsConfig)this.getElement().getAdapter(ObjectDetailsConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 45;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Properties to display");
        String[] names = new String[]{"Name", "Display name", "Type"};
        int[] widths = new int[]{150, 250, 90};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67586);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectPropertiesLabelProvider());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.properties = new ArrayList<ObjectDetailsConfig.ObjectProperty>();
        if (this.config.getProperties() != null) {
            for (ObjectDetailsConfig.ObjectProperty p : this.config.getProperties()) {
                if (p == null) continue;
                this.properties.add(new ObjectDetailsConfig.ObjectProperty(p));
            }
        }
        this.viewer.setInput((Object)this.properties.toArray());
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        leftButtons.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.EmbeddedDashboard_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectDetailsPropertyList.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.EmbeddedDashboard_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectDetailsPropertyList.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        rightButtons.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.EmbeddedDashboard_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectDetailsPropertyList.this.addProperty();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        Messages.get();
        this.editButton.setText(Messages.DashboardElements_Edit);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectDetailsPropertyList.this.editProperty();
            }
        });
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.EmbeddedDashboard_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectDetailsPropertyList.this.deletePropertiess();
            }
        });
        this.deleteButton.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ObjectDetailsPropertyList.this.viewer.getSelection();
                ObjectDetailsPropertyList.this.editButton.setEnabled(selection.size() == 1);
                ObjectDetailsPropertyList.this.deleteButton.setEnabled(selection.size() > 0);
                ObjectDetailsPropertyList.this.upButton.setEnabled(selection.size() == 1);
                ObjectDetailsPropertyList.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectDetailsPropertyList.this.editProperty();
            }
        });
        return dialogArea;
    }

    protected void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.properties.indexOf(element = selection.getFirstElement())) < this.properties.size() - 1 && index >= 0) {
            Collections.swap(this.properties, index + 1, index);
            this.viewer.setInput((Object)this.properties.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.properties.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.properties, index - 1, index);
            this.viewer.setInput((Object)this.properties.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void deletePropertiess() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.properties.remove(o);
        }
        this.viewer.setInput((Object)this.properties.toArray());
    }

    protected void addProperty() {
        EditObjectPropertyDialog dlg = new EditObjectPropertyDialog(this.getShell(), new ObjectDetailsConfig.ObjectProperty());
        if (dlg.open() == 0) {
            this.properties.add(dlg.getProperty());
            this.viewer.setInput((Object)this.properties.toArray());
        }
    }

    protected void editProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        EditObjectPropertyDialog dlg = new EditObjectPropertyDialog(this.getShell(), (ObjectDetailsConfig.ObjectProperty)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.viewer.refresh();
        }
    }

    public boolean performOk() {
        this.config.setProperties(this.properties);
        return true;
    }
}

