/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;

public class Log {
    private NXCSession session;
    private int handle;
    private String name;
    private LinkedHashMap<String, LogColumn> columns;
    private long numRecords;

    public Log(NXCSession session, NXCPMessage msg, String name) {
        this.session = session;
        this.name = name;
        this.handle = msg.getFieldAsInt32(338L);
        int count2 = msg.getFieldAsInt32(166L);
        this.columns = new LinkedHashMap(count2);
        long baseId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            LogColumn c = new LogColumn(msg, baseId);
            this.columns.put(c.getName(), c);
            ++i;
            baseId += 10L;
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<LogColumn> getColumns() {
        return this.columns.values();
    }

    public String getColumnDescription(String columnName) {
        LogColumn col = this.columns.get(columnName);
        return col != null ? col.getDescription() : null;
    }

    public LogColumn getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public void query(LogFilter filter) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(63);
        msg.setFieldInt32(338L, this.handle);
        filter.fillMessage(msg);
        this.session.sendMessage(msg);
        NXCPMessage response = this.session.waitForRCC(msg.getMessageId(), 1800000);
        this.numRecords = response.getFieldAsInt64(167L);
    }

    public Table retrieveData(long startRow, long rowCount) throws IOException, NXCException {
        return this.retrieveData(startRow, rowCount, false);
    }

    public Table retrieveData(long startRow, long rowCount, boolean refresh) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(43);
        msg.setFieldInt32(338L, this.handle);
        msg.setFieldInt64(339L, startRow);
        msg.setFieldInt64(167L, rowCount);
        msg.setFieldInt16(425L, refresh ? 1 : 0);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId(), 1800000);
        return this.session.receiveTable(msg.getMessageId(), 143);
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public void close() throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(62);
        msg.setFieldInt32(338L, this.handle);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.handle = -1;
    }

    protected void finalize() throws Throwable {
        if (this.handle != -1) {
            this.close();
        }
        super.finalize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Log");
        sb.append("{session=").append(this.session);
        sb.append(", handle=").append(this.handle);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", columns=").append(this.columns);
        sb.append(", numRecords=").append(this.numRecords);
        sb.append('}');
        return sb.toString();
    }
}

