/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class Route {
    private InetAddress destination;
    private int prefixLength;
    private InetAddress nextHop;
    private int ifIndex;
    private int type;
    private String ifName;

    public Route(NXCPMessage msg, long baseId) {
        this.destination = msg.getFieldAsInetAddress(baseId);
        this.prefixLength = msg.getFieldAsInt32(baseId + 1L);
        this.nextHop = msg.getFieldAsInetAddress(baseId + 2L);
        this.ifIndex = msg.getFieldAsInt32(baseId + 3L);
        this.type = msg.getFieldAsInt32(baseId + 4L);
        this.ifName = msg.getFieldAsString(baseId + 5L);
    }

    public InetAddress getDestination() {
        return this.destination;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public InetAddress getNextHop() {
        return this.nextHop;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "Route [" + this.destination.getHostAddress() + "/" + this.prefixLength + " gw=" + this.nextHop.getHostAddress() + " iface=" + this.ifIndex + " type=" + this.type + "]";
    }

    public String getIfName() {
        return this.ifName;
    }
}

