/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Instantiator;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassInstantiator
implements Instantiator {
    private final List<Creator> creators;
    private final ParameterMap registry;
    private final Creator primary;
    private final Class type;

    public ClassInstantiator(List<Creator> creators, Creator primary, ParameterMap registry, Class type) {
        this.creators = creators;
        this.registry = registry;
        this.primary = primary;
        this.type = type;
    }

    @Override
    public boolean isDefault() {
        int count2 = this.creators.size();
        if (count2 <= 1) {
            return this.primary != null;
        }
        return false;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.primary.getInstance();
    }

    @Override
    public Object getInstance(Criteria criteria) throws Exception {
        Creator creator = this.getCreator(criteria);
        if (creator == null) {
            throw new PersistenceException("Constructor not matched for %s", this.type);
        }
        return creator.getInstance(criteria);
    }

    private Creator getCreator(Criteria criteria) throws Exception {
        Creator result2 = this.primary;
        double max = 0.0;
        for (Creator instantiator : this.creators) {
            double score = instantiator.getScore(criteria);
            if (!(score > max)) continue;
            result2 = instantiator;
            max = score;
        }
        return result2;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.registry.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return this.registry.getAll();
    }

    @Override
    public List<Creator> getCreators() {
        return new ArrayList<Creator>(this.creators);
    }

    public String toString() {
        return String.format("creator for %s", this.type);
    }
}

