/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AggregationFunction {
    LAST(0),
    MIN(1),
    MAX(2),
    AVERAGE(3),
    SUM(4);

    private int value;
    private static Map<Integer, AggregationFunction> lookupTable;

    private AggregationFunction(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AggregationFunction getByValue(int value) {
        AggregationFunction element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)AggregationFunction.class.getName(), (String)("Unknown element " + value));
            return LAST;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, AggregationFunction>();
        for (AggregationFunction element : AggregationFunction.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

