/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignCategoryDataset
extends JRDesignChartDataset
implements JRCategoryDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CATEGORY_SERIES = "categorySeries";
    private List<JRCategorySeries> categorySeriesList = new ArrayList<JRCategorySeries>();

    public JRDesignCategoryDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRCategorySeries[] getSeries() {
        JRCategorySeries[] categorySeriesArray = new JRCategorySeries[this.categorySeriesList.size()];
        this.categorySeriesList.toArray(categorySeriesArray);
        return categorySeriesArray;
    }

    public List<JRCategorySeries> getSeriesList() {
        return this.categorySeriesList;
    }

    public void addCategorySeries(JRCategorySeries categorySeries) {
        this.categorySeriesList.add(categorySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, this.categorySeriesList.size() - 1);
    }

    public void addCategorySeries(int index, JRCategorySeries categorySeries) {
        this.categorySeriesList.add(index, categorySeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, index);
    }

    public JRCategorySeries removeCategorySeries(JRCategorySeries categorySeries) {
        int idx;
        if (categorySeries != null && (idx = this.categorySeriesList.indexOf(categorySeries)) >= 0) {
            this.categorySeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CATEGORY_SERIES, categorySeries, idx);
        }
        return categorySeries;
    }

    @Override
    public byte getDatasetType() {
        return 2;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRDesignCategoryDataset clone = (JRDesignCategoryDataset)super.clone();
        clone.categorySeriesList = JRCloneUtils.cloneList(this.categorySeriesList);
        return clone;
    }
}

