/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementerFactoryCache;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;

public abstract class JRFillCommonReturnValue
implements CommonReturnValue {
    public static final String EXCEPTION_MESSAGE_KEY_INCREMENTER_CLASS_NOT_FOUND = "fill.subreport.return.value.incrementer.class.not.found";
    protected final String toVariable;
    protected final String incrementerFactoryClassName;
    protected final CalculationEnum calculation;
    private boolean derived;
    protected JRIncrementer incrementer;
    protected final BaseReportFiller filler;

    protected JRFillCommonReturnValue(CommonReturnValue returnValue, JRFillObjectFactory factory, BaseReportFiller filler) {
        factory.put(returnValue, this);
        this.toVariable = returnValue.getToVariable();
        this.incrementerFactoryClassName = returnValue.getIncrementerFactoryClassName();
        this.calculation = returnValue.getCalculation();
        this.filler = filler;
    }

    protected JRFillCommonReturnValue(JRFillCommonReturnValue fillReturnValue, JRFillCloneFactory factory) {
        this.toVariable = fillReturnValue.toVariable;
        this.incrementerFactoryClassName = fillReturnValue.incrementerFactoryClassName;
        this.calculation = fillReturnValue.calculation;
        this.derived = fillReturnValue.derived;
        this.incrementer = fillReturnValue.incrementer;
        this.filler = fillReturnValue.filler;
    }

    @Override
    public String getToVariable() {
        return this.toVariable;
    }

    @Override
    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    @Override
    public CalculationEnum getCalculation() {
        return this.calculation;
    }

    public JRIncrementer getIncrementer() {
        if (this.incrementer == null) {
            JRIncrementerFactory incrementerFactory;
            String incrementerFactoryClassName = this.getIncrementerFactoryClassName();
            if (incrementerFactoryClassName == null) {
                JRFillVariable toVariable = this.filler.getVariable(this.getToVariable());
                incrementerFactory = JRDefaultIncrementerFactory.getFactory(toVariable.getValueClass());
            } else {
                try {
                    Class<?> incrementerFactoryClass = JRClassLoader.loadClassForName(incrementerFactoryClassName);
                    incrementerFactory = JRIncrementerFactoryCache.getInstance(incrementerFactoryClass);
                }
                catch (ClassNotFoundException e) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INCREMENTER_CLASS_NOT_FOUND, new Object[]{incrementerFactoryClassName}, e);
                }
            }
            this.incrementer = incrementerFactory.getIncrementer(this.getCalculation().getValue());
        }
        return this.incrementer;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    protected JRFillCommonReturnValue addReturnValue(JRFillCommonReturnValue returnValue, List<JRFillCommonReturnValue> returnValueList, JRFillObjectFactory factory, BaseReportFiller filler) {
        CalculationEnum calculation = returnValue.getCalculation();
        switch (calculation) {
            case AVERAGE: 
            case VARIANCE: {
                CommonReturnValue countVal = returnValue.createHelperReturnValue(returnValue, "_COUNT", CalculationEnum.COUNT);
                returnValue.addDerivedReturnValue(countVal, returnValueList, factory, filler);
                CommonReturnValue sumVal = returnValue.createHelperReturnValue(returnValue, "_SUM", CalculationEnum.SUM);
                returnValue.addDerivedReturnValue(sumVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                CommonReturnValue varianceVal = returnValue.createHelperReturnValue(returnValue, "_VARIANCE", CalculationEnum.VARIANCE);
                returnValue.addDerivedReturnValue(varianceVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case DISTINCT_COUNT: {
                CommonReturnValue countVal = returnValue.createDistinctCountHelperReturnValue(returnValue);
                returnValue.addDerivedReturnValue(countVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
        }
        returnValueList.add(returnValue);
        return returnValue;
    }

    protected abstract JRFillCommonReturnValue addDerivedReturnValue(CommonReturnValue var1, List<JRFillCommonReturnValue> var2, JRFillObjectFactory var3, BaseReportFiller var4);

    protected abstract CommonReturnValue createHelperReturnValue(CommonReturnValue var1, String var2, CalculationEnum var3);

    protected abstract CommonReturnValue createDistinctCountHelperReturnValue(CommonReturnValue var1);

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

