/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.base.Glob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.VPNConnector;
import org.netxms.websvc.WebSvcException;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.ResponseContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Objects
extends AbstractObjectHandler {
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);

    /*
     * Could not resolve type clashes
     */
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        if (!session.isObjectsSynchronized()) {
            session.syncObjects();
        }
        boolean topLevelOnly = query.get("topLevelOnly") != null ? Boolean.parseBoolean(query.get("topLevelOnly")) : false;
        List<AbstractObject> objects = topLevelOnly ? Arrays.asList(session.getTopLevelObjects()) : session.getAllObjects();
        String areaFilter = query.get("area");
        String classFilter = query.get("class");
        String nameFilter = query.get("name");
        String parentFilter = query.get("parent");
        String zoneFilter = query.get("zone");
        HashMap<String, String> customAttributes = null;
        for (String k : query.keySet()) {
            if (!k.startsWith("@")) continue;
            if (customAttributes == null) {
                customAttributes = new HashMap<String, String>();
            }
            customAttributes.put(k.substring(1), query.get(k));
        }
        if (areaFilter != null || classFilter != null || customAttributes != null || nameFilter != null || parentFilter != null || zoneFilter != null) {
            long parentId;
            double[] area = null;
            if (areaFilter != null) {
                String[] parts = areaFilter.split(",");
                if (parts.length == 4) {
                    try {
                        area = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            area[i] = Double.parseDouble(parts[i]);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.warn("Invalid area filter " + areaFilter);
                    }
                } else {
                    this.log.warn("Invalid area filter " + areaFilter);
                }
            }
            String[] classes = null;
            if (classFilter != null && !classFilter.isEmpty()) {
                classes = classFilter.split(",");
            }
            if (parentFilter != null) {
                try {
                    parentId = Long.parseLong(parentFilter);
                }
                catch (NumberFormatException e) {
                    throw new WebSvcException(12);
                }
            } else {
                parentId = 0L;
            }
            long[] zones = null;
            if (zoneFilter != null) {
                String[] parts = zoneFilter.split(",");
                try {
                    zones = new long[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        zones[i] = Long.parseLong(parts[i]);
                    }
                }
                catch (NumberFormatException e) {
                    this.log.warn("Invalid zone filter " + zoneFilter);
                }
            }
            ArrayList<AbstractObject> filteredObjects = new ArrayList<AbstractObject>();
            for (AbstractObject o : objects) {
                if (zones != null) {
                    long zoneUin = Objects.getZoneUin((AbstractObject)o);
                    if (zoneUin == -1L) continue;
                    int match = 0;
                    for (long z : zones) {
                        if (zoneUin != z) continue;
                        match = 1;
                        break;
                    }
                    if (match == 0) continue;
                }
                if (nameFilter != null && !nameFilter.isEmpty() && !Glob.matchIgnoreCase((String)nameFilter, (String)o.getObjectName())) continue;
                if (classes != null) {
                    boolean match = false;
                    for (String c : classes) {
                        if (!o.getObjectClassName().equalsIgnoreCase(c)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                }
                if (parentId != 0L && !o.isChildOf(parentId) || area != null && !o.getGeolocation().isWithinArea(area[0], area[1], area[2], area[3])) continue;
                if (customAttributes != null) {
                    if (o.getCustomAttributes().isEmpty()) continue;
                    boolean match = true;
                    for (Map.Entry e : customAttributes.entrySet()) {
                        String value = (String)o.getCustomAttributes().get(e.getKey());
                        if (value != null && Glob.matchIgnoreCase((String)((String)e.getValue()), (String)value)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                }
                filteredObjects.add(o);
            }
            objects = filteredObjects;
        }
        return new ResponseContainer("objects", objects);
    }

    private static long getZoneUin(AbstractObject obj) {
        if (obj instanceof AbstractNode) {
            return ((AbstractNode)obj).getZoneId();
        }
        if (obj instanceof Subnet) {
            return ((Subnet)obj).getZoneId();
        }
        if (obj instanceof Interface) {
            return ((Interface)obj).getZoneId();
        }
        if (obj instanceof NetworkService) {
            return ((NetworkService)obj).getParentNode().getZoneId();
        }
        if (obj instanceof VPNConnector) {
            return ((VPNConnector)obj).getParentNode().getZoneId();
        }
        if (obj instanceof AccessPoint) {
            return ((AccessPoint)obj).getParentNode().getZoneId();
        }
        return -1L;
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        return this.getObject();
    }

    protected String getEntityIdFieldName() {
        return "object-id";
    }
}

