/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesComparator
extends ViewerComparator {
    private boolean showErrors = true;

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        DciValue v1 = (DciValue)e1;
        DciValue v2 = (DciValue)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = (int)(v1.getId() - v2.getId());
                break;
            }
            case 1: {
                result = v1.getDescription().compareToIgnoreCase(v2.getDescription());
                break;
            }
            case 2: {
                result = this.compareValue(v1, v2);
                break;
            }
            case 3: {
                result = v1.getTimestamp().compareTo(v2.getTimestamp());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private int compareValue(DciValue dci1, DciValue dci2) {
        String v2;
        int dt2;
        String v1;
        int dt1;
        if (this.showErrors && dci1.getErrorCount() > 0) {
            dt1 = 4;
            Messages.get();
            v1 = Messages.LastValuesLabelProvider_Error;
        } else if (dci1.getDcObjectType() == 2) {
            dt1 = 4;
            Messages.get();
            v1 = Messages.LastValuesLabelProvider_Table;
        } else {
            dt1 = dci1.getDataType();
            v1 = dci1.getValue();
        }
        if (this.showErrors && dci2.getErrorCount() > 0) {
            dt2 = 4;
            Messages.get();
            v2 = Messages.LastValuesLabelProvider_Error;
        } else if (dci2.getDcObjectType() == 2) {
            dt2 = 4;
            Messages.get();
            v2 = Messages.LastValuesLabelProvider_Table;
        } else {
            dt2 = dci2.getDataType();
            v2 = dci2.getValue();
        }
        int dataType = Math.max(dt1, dt2);
        try {
            switch (dataType) {
                case 0: {
                    return Integer.signum(Integer.parseInt(v1) - Integer.parseInt(v2));
                }
                case 1: 
                case 2: 
                case 3: {
                    return Long.signum(Long.parseLong(v1) - Long.parseLong(v2));
                }
                case 5: {
                    if (dt1 == 4 || dt2 == 4) {
                        return v1.compareToIgnoreCase(v2);
                    }
                    return (int)Math.signum(Double.parseDouble(v1) - Double.parseDouble(v2));
                }
            }
            return v1.compareToIgnoreCase(v2);
        }
        catch (NumberFormatException numberFormatException) {
            return v1.compareToIgnoreCase(v2);
        }
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

