/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.agent.config.ConfigContent;
import org.netxms.client.agent.config.ConfigListElement;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.dialogs.SaveStoredConfigDialog;
import org.netxms.ui.eclipse.agentmanager.widgets.AgentConfigEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ServerStoredAgentConfigEditorView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.ServerStoredAgentConfigEditorView";
    private NXCSession session;
    private boolean modified = false;
    private boolean reselection = false;
    private ScrolledForm form;
    private AgentConfigEditor configEditor;
    private ScriptEditor filterEditor;
    private Text nameField;
    private TableViewer configList;
    private RefreshAction actionRefresh;
    private Action actionSave;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionMoveUp;
    private Action actionMoveDown;
    private List<ConfigListElement> elements;
    private ConfigContent content;
    private IStructuredSelection previousSelection;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm splitter = new SashForm(parent, 256);
        splitter.setSashWidth(3);
        Composite listContainer = new Composite((Composite)splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        listContainer.setLayout((Layout)layout);
        this.configList = new TableViewer(listContainer, 65540);
        this.configList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServerStoredAgentConfigEditorView.this.onSelectionChange(event);
            }
        });
        this.configList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(listContainer, 514).setLayoutData((Object)new GridData(131072, 4, false, true));
        FormToolkit toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        Composite formContainer = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        formContainer.setLayout((Layout)layout);
        new Label(formContainer, 514).setLayoutData((Object)new GridData(131072, 4, false, true));
        this.form = toolkit.createScrolledForm(formContainer);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        Messages.get();
        this.form.setText(Messages.ServerStoredAgentConfigEditorView_Noname);
        layout = new GridLayout();
        this.form.getBody().setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.form.getBody().setLayoutData((Object)gridData);
        splitter.setWeights(new int[]{20, 80});
        Section section = toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ServerStoredAgentConfigEditorView_Name);
        layout = new GridLayout();
        section.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gridData);
        this.nameField = new Text((Composite)section, 2048);
        section.setClient((Control)this.nameField);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerStoredAgentConfigEditorView.this.onTextModify();
            }
        });
        section = toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ServerStoredAgentConfigEditorView_Filter);
        section.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gridData);
        this.filterEditor = new ScriptEditor((Composite)section, 2048, 768, true, "Variables:\r\n\t$1\tIP address\r\n\t$2\tplatform name\r\n\t$3\tmajor agent version number\r\n\t$4\tminor agent version number\r\n\t$5\trelease number\r\n\r\nReturn value: true if this configuration should be sent to agent");
        section.setClient((Control)this.filterEditor);
        this.filterEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerStoredAgentConfigEditorView.this.onTextModify();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.filterEditor.setLayoutData((Object)gridData);
        section = toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ServerStoredAgentConfigEditorView_ConfigFile);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gridData);
        this.configEditor = new AgentConfigEditor((Composite)section, 2048, 768, 0);
        section.setClient((Control)this.configEditor);
        this.configEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerStoredAgentConfigEditorView.this.onTextModify();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.configEditor.setLayoutData(gridData);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.actionSave.setEnabled(false);
        this.getConfigList();
    }

    private void onSelectionChange(SelectionChangedEvent event) {
        IStructuredSelection selection;
        if (this.reselection) {
            this.reselection = false;
            return;
        }
        if (this.modified) {
            SaveStoredConfigDialog dlg = new SaveStoredConfigDialog(this.getSite().getShell());
            int rc = dlg.open();
            if (rc == 100) {
                this.intermediateSave();
                this.modified = false;
                this.firePropertyChange(257);
                this.actionSave.setEnabled(false);
                return;
            }
            if (rc == 1) {
                this.reselection = true;
                this.configList.setSelection((ISelection)this.previousSelection);
                return;
            }
        }
        this.previousSelection = selection = (IStructuredSelection)event.getSelection();
        if (selection == null) {
            return;
        }
        final ConfigListElement element = (ConfigListElement)selection.getFirstElement();
        Messages.get();
        new ConsoleJob(Messages.ServerStoredAgentConfigEditorView_JobTitle_GetContent, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (element != null) {
                    ServerStoredAgentConfigEditorView.this.content = ServerStoredAgentConfigEditorView.this.session.getConfigContent(element.getId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerStoredAgentConfigEditorView.this.updateContent();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_GetContent;
            }
        }.start();
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
            this.actionSave.setEnabled(true);
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)ServerStoredAgentConfigEditorView.this.actionMoveUp);
                mgr.add((IAction)ServerStoredAgentConfigEditorView.this.actionMoveDown);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)ServerStoredAgentConfigEditorView.this.actionDelete);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.configList.getControl());
        this.configList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.configList);
    }

    public void setFocus() {
        this.nameField.setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ServerStoredAgentConfigEditorView.this.getConfigList();
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.AgentConfigEditorView_Save, SharedIcons.SAVE){

            public void run() {
                ServerStoredAgentConfigEditorView.this.intermediateSave();
                ServerStoredAgentConfigEditorView.this.actionSave.setEnabled(false);
                ServerStoredAgentConfigEditorView.this.modified = false;
            }
        };
        Messages.get();
        this.actionCreate = new Action(Messages.ServerStoredAgentConfigEditorView_JobTitle_CreateNew, SharedIcons.ADD_OBJECT){

            public void run() {
                ServerStoredAgentConfigEditorView.this.createNewConfig();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.ServerStoredAgentConfigEditorView_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                ServerStoredAgentConfigEditorView.this.deleteConfig();
            }
        };
        Messages.get();
        this.actionMoveUp = new Action(Messages.ServerStoredAgentConfigEditorView_MoveUp, SharedIcons.UP){

            public void run() {
                ServerStoredAgentConfigEditorView.this.moveUp();
            }
        };
        Messages.get();
        this.actionMoveDown = new Action(Messages.ServerStoredAgentConfigEditorView_MoveDown, SharedIcons.DOWN){

            public void run() {
                ServerStoredAgentConfigEditorView.this.moveDown();
            }
        };
    }

    private void moveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        final ConfigListElement element1 = (ConfigListElement)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index <= 0) {
            return;
        }
        final ConfigListElement element2 = this.elements.get(index - 1);
        Messages.get();
        new ConsoleJob(Messages.ServerStoredAgentConfigEditorView_JobMoveUp, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerStoredAgentConfigEditorView.this.session.swapAgentConfigs(element1.getId(), element2.getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerStoredAgentConfigEditorView.this.getConfigList();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_MoveUp;
            }
        }.start();
    }

    private void moveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        final ConfigListElement element1 = (ConfigListElement)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index >= this.elements.size() - 1) {
            return;
        }
        final ConfigListElement elemen2 = this.elements.get(index + 1);
        Messages.get();
        new ConsoleJob(Messages.ServerStoredAgentConfigEditorView_JobMoveDown, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerStoredAgentConfigEditorView.this.session.swapAgentConfigs(element1.getId(), elemen2.getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerStoredAgentConfigEditorView.this.getConfigList();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_MoveDown;
            }
        }.start();
    }

    private void deleteConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        final ConfigListElement element = (ConfigListElement)selection.getFirstElement();
        Messages.get();
        new ConsoleJob(Messages.ServerStoredAgentConfigEditorView_JobDelete, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerStoredAgentConfigEditorView.this.session.deleteAgentConfig(element.getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerStoredAgentConfigEditorView.this.elements.remove(element);
                        ServerStoredAgentConfigEditorView.this.configList.setInput((Object)ServerStoredAgentConfigEditorView.this.elements.toArray(new ConfigListElement[ServerStoredAgentConfigEditorView.this.elements.size()]));
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_Delete;
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void createNewConfig() {
        this.modified = true;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(true);
        ConfigListElement newElement = new ConfigListElement();
        this.elements.add(newElement);
        this.configList.setInput((Object)this.elements.toArray(new ConfigListElement[this.elements.size()]));
        this.reselection = true;
        StructuredSelection selection = new StructuredSelection((Object)newElement);
        this.previousSelection = selection;
        this.configList.setSelection((ISelection)selection);
        this.content = new ConfigContent();
        this.updateContent();
    }

    private void updateContent() {
        this.form.setText(this.content.getName());
        this.nameField.setText(this.content.getName());
        this.configEditor.setText(this.content.getConfig());
        this.filterEditor.setText(this.content.getFilter());
        this.modified = false;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(false);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.content.setConfig(this.configEditor.getText());
            this.content.setFilter(this.filterEditor.getText());
            this.content.setName(this.nameField.getText());
            this.session.saveAgentConfig(this.content);
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.AgentConfigEditorView_Error, (String)(String.valueOf(Messages.AgentConfigEditorView_SaveError) + e.getMessage()));
        }
    }

    public void intermediateSave() {
        if (this.content == null) {
            return;
        }
        this.content.setConfig(this.configEditor.getText());
        this.content.setFilter(this.filterEditor.getText());
        this.content.setName(this.nameField.getText());
        Messages.get();
        new ConsoleJob(Messages.ServerStoredAgentConfigEditorView_JobSave, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerStoredAgentConfigEditorView.this.session.saveAgentConfig(ServerStoredAgentConfigEditorView.this.content);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerStoredAgentConfigEditorView.this.getConfigList();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_Save;
            }
        }.start();
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SaveStoredConfigDialog dlg = new SaveStoredConfigDialog(this.getSite().getShell());
        int rc = dlg.open();
        boolean bl = this.modified = rc != 100;
        return rc == 1 ? 2 : (rc == 102 ? 1 : 0);
    }

    public void getConfigList() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        final ConfigListElement element = selection == null ? null : (ConfigListElement)selection.getFirstElement();
        Messages.get();
        new ConsoleJob(Messages.PackageManager_OpenDatabase, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerStoredAgentConfigEditorView.this.elements = ServerStoredAgentConfigEditorView.this.session.getConfigList();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerStoredAgentConfigEditorView.this.configList.setInput((Object)ServerStoredAgentConfigEditorView.this.elements.toArray(new ConfigListElement[ServerStoredAgentConfigEditorView.this.elements.size()]));
                        if (element == null && ServerStoredAgentConfigEditorView.this.elements.size() > 0) {
                            StructuredSelection selection = new StructuredSelection(ServerStoredAgentConfigEditorView.this.elements.get(0));
                            ServerStoredAgentConfigEditorView.this.configList.setSelection((ISelection)selection);
                        }
                        if (element != null) {
                            long id = element.getId();
                            if (id == 0L) {
                                id = ((ConfigListElement)ServerStoredAgentConfigEditorView.this.elements.get(ServerStoredAgentConfigEditorView.this.elements.size() - 1)).getId();
                            }
                            int i = 0;
                            while (i < ServerStoredAgentConfigEditorView.this.elements.size()) {
                                if (((ConfigListElement)ServerStoredAgentConfigEditorView.this.elements.get(i)).getId() == id) {
                                    StructuredSelection selection = new StructuredSelection(ServerStoredAgentConfigEditorView.this.elements.get(i));
                                    ServerStoredAgentConfigEditorView.this.configList.setSelection((ISelection)selection);
                                }
                                ++i;
                            }
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerStoredAgentConfigEditorView_JobError_GetList;
            }
        }.start();
    }
}

