/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.TableDciValue;
import org.netxms.client.datacollection.Threshold;

public abstract class DciValue {
    protected long id;
    protected long nodeId;
    private long templateDciId;
    protected String name;
    protected String description;
    protected String value;
    protected int source;
    protected int dataType;
    protected int status;
    private int errorCount;
    private int dcObjectType;
    private Date timestamp;
    private Threshold activeThreshold;
    private int flags;

    public static DciValue createFromMessage(long nodeId, NXCPMessage msg, long base) {
        int type = msg.getFieldAsInt32(base + 9L);
        switch (type) {
            case 1: {
                return new SimpleDciValue(nodeId, msg, base);
            }
            case 2: {
                return new TableDciValue(nodeId, msg, base);
            }
        }
        return null;
    }

    protected DciValue() {
    }

    protected DciValue(long nodeId, NXCPMessage msg, long base) {
        long fieldId = base;
        this.nodeId = nodeId;
        this.id = msg.getFieldAsInt64(fieldId++);
        this.name = msg.getFieldAsString(fieldId++);
        this.flags = msg.getFieldAsInt32(fieldId++);
        this.description = msg.getFieldAsString(fieldId++);
        this.source = msg.getFieldAsInt32(fieldId++);
        this.dataType = msg.getFieldAsInt32(fieldId++);
        this.value = msg.getFieldAsString(fieldId++);
        this.timestamp = msg.getFieldAsDate(fieldId++);
        this.status = msg.getFieldAsInt32(fieldId++);
        this.dcObjectType = msg.getFieldAsInt32(fieldId++);
        this.errorCount = msg.getFieldAsInt32(fieldId++);
        this.templateDciId = msg.getFieldAsInt64(fieldId++);
        this.activeThreshold = msg.getFieldAsBoolean(fieldId++) ? new Threshold(msg, fieldId) : null;
    }

    public String format(String formatString) {
        return new DataFormatter(formatString, this.dataType).format(this.value);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name.isEmpty() ? "[" + this.getId() + "]" : this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public int getSource() {
        return this.source;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Threshold getActiveThreshold() {
        return this.activeThreshold;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final long getTemplateDciId() {
        return this.templateDciId;
    }

    public Severity getThresholdSeverity() {
        return this.activeThreshold != null ? this.activeThreshold.getCurrentSeverity() : Severity.NORMAL;
    }

    public int getFlags() {
        return this.flags;
    }
}

