/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.objectview.Messages;

public class ComponentTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] className;
    private Map<Integer, Interface> interfaces = new HashMap<Integer, Interface>();

    static {
        String[] stringArray = new String[12];
        Messages.get();
        stringArray[1] = Messages.ComponentTreeLabelProvider_ClassOther;
        Messages.get();
        stringArray[2] = Messages.ComponentTreeLabelProvider_ClassUnknown;
        Messages.get();
        stringArray[3] = Messages.ComponentTreeLabelProvider_ClassChassis;
        Messages.get();
        stringArray[4] = Messages.ComponentTreeLabelProvider_ClassBackplane;
        Messages.get();
        stringArray[5] = Messages.ComponentTreeLabelProvider_ClassContainer;
        Messages.get();
        stringArray[6] = Messages.ComponentTreeLabelProvider_ClassPS;
        Messages.get();
        stringArray[7] = Messages.ComponentTreeLabelProvider_ClassFan;
        Messages.get();
        stringArray[8] = Messages.ComponentTreeLabelProvider_ClassSensor;
        Messages.get();
        stringArray[9] = Messages.ComponentTreeLabelProvider_ClassModule;
        Messages.get();
        stringArray[10] = Messages.ComponentTreeLabelProvider_ClassPort;
        Messages.get();
        stringArray[11] = Messages.ComponentTreeLabelProvider_ClassStack;
        className = stringArray;
    }

    public void setNode(AbstractNode node) {
        this.interfaces.clear();
        if (node != null) {
            for (AbstractObject i : node.getAllChildren(3)) {
                if (((Interface)i).getIfIndex() <= 0) continue;
                this.interfaces.put(((Interface)i).getIfIndex(), (Interface)i);
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PhysicalComponent c = (PhysicalComponent)element;
        switch (columnIndex) {
            case 1: {
                try {
                    return className[c.getPhyClass()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return className[2];
                }
            }
            case 2: {
                return c.getDescription();
            }
            case 7: {
                return this.getInterfaceName(c);
            }
            case 4: {
                return c.getFirmware();
            }
            case 3: {
                return c.getModel();
            }
            case 0: {
                return c.getDisplayName();
            }
            case 5: {
                return c.getSerialNumber();
            }
            case 6: {
                return c.getVendor();
            }
        }
        return null;
    }

    private String getInterfaceName(PhysicalComponent c) {
        int ifIndex = c.getIfIndex();
        if (ifIndex <= 0) {
            return "";
        }
        Interface iface = this.interfaces.get(ifIndex);
        return iface != null ? iface.getObjectName() : null;
    }
}

