/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ColumnFilterType {
    EQUALS(0),
    RANGE(1),
    SET(2),
    LIKE(3),
    LESS(4),
    GREATER(5),
    CHILDOF(6),
    UNKNOWN(7);

    private int value;
    private static Map<Integer, ColumnFilterType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, ColumnFilterType>();
        ColumnFilterType[] columnFilterTypeArray = ColumnFilterType.values();
        int n = columnFilterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnFilterType element = columnFilterTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ColumnFilterType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ColumnFilterType getByValue(int value) {
        ColumnFilterType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)ColumnFilterType.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

