/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;

public class DciDataRow {
    private Date timestamp;
    private Object value;

    public DciDataRow(Date timestamp, Object value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value.toString();
    }

    public long getValueAsLong() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof Double) {
            return ((Double)this.value).longValue();
        }
        if (this.value instanceof String) {
            try {
                return Long.parseLong((String)this.value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public double getValueAsDouble() {
        if (this.value instanceof Long) {
            return ((Long)this.value).doubleValue();
        }
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof String) {
            try {
                return Double.parseDouble((String)this.value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public void invert() {
        if (this.value instanceof Long) {
            this.value = -((Long)this.value).longValue();
        } else if (this.value instanceof Double) {
            this.value = -((Double)this.value).doubleValue();
        }
    }

    public String toString() {
        return "DciDataRow [timestamp=" + this.timestamp + ", value=" + this.value + "]";
    }
}

