/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex$complex___abs___exposer;
import org.python.core.PyComplex$complex___coerce___exposer;
import org.python.core.PyComplex$complex___divmod___exposer;
import org.python.core.PyComplex$complex___floordiv___exposer;
import org.python.core.PyComplex$complex___hash___exposer;
import org.python.core.PyComplex$complex___lt___exposer;
import org.python.core.PyComplex$complex___mod___exposer;
import org.python.core.PyComplex$complex___nonzero___exposer;
import org.python.core.PyComplex$complex___pos___exposer;
import org.python.core.PyComplex$complex___rdiv___exposer;
import org.python.core.PyComplex$complex___rdivmod___exposer;
import org.python.core.PyComplex$complex___repr___exposer;
import org.python.core.PyComplex$complex___rmul___exposer;
import org.python.core.PyComplex$complex___rpow___exposer;
import org.python.core.PyComplex$complex___sub___exposer;
import org.python.core.PyComplex$complex___truediv___exposer;
import org.python.core.PyComplex$complex_conjugate_exposer;
import org.python.core.PyComplex$exposed___new__;
import org.python.core.PyComplex$imag_descriptor;
import org.python.core.PyComplex$real_descriptor;
import org.python.core.PyComplexDerived;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.stringlib.FloatFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="complex", doc="complex(real[, imag]) -> complex number\n\nCreate a complex number from a real part and an optional imaginary part.\nThis is equivalent to (real + imag*1j) where imag defaults to 0.")
public class PyComplex
extends PyObject {
    public static final PyType TYPE;
    static final InternalFormat.Spec SPEC_REPR;
    static final InternalFormat.Spec SPEC_STR;
    static PyComplex J;
    public static final PyComplex Inf;
    public static final PyComplex NaN;
    public double real;
    public double imag;

    public PyComplex(PyType subtype, double r, double i) {
        super(subtype);
        this.real = r;
        this.imag = i;
    }

    public PyComplex(double r, double i) {
        this(TYPE, r, i);
    }

    public PyComplex(double r) {
        this(r, 0.0);
    }

    @ExposedNew
    public static PyObject complex_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyComplex complexImag;
        PyComplex complexReal;
        PyObject imag;
        PyObject real;
        block19: {
            ArgParser ap = new ArgParser("complex", args, keywords, "real", "imag");
            real = ap.getPyObject(0, Py.Zero);
            imag = ap.getPyObject(1, null);
            if (real.getType() == TYPE && new_.for_type == subtype && imag == null) {
                return real;
            }
            if (real instanceof PyString) {
                if (imag != null) {
                    throw Py.TypeError("complex() can't take second arg if first is a string");
                }
                return real.__complex__();
            }
            if (imag != null && imag instanceof PyString) {
                throw Py.TypeError("complex() second arg can't be a string");
            }
            try {
                real = real.__complex__();
            }
            catch (PyException pye) {
                if (pye.match(Py.AttributeError)) break block19;
                throw pye;
            }
        }
        PyFloat toFloat = null;
        if (real instanceof PyComplex) {
            complexReal = (PyComplex)real;
        } else {
            try {
                toFloat = real.__float__();
            }
            catch (PyException pye) {
                if (pye.match(Py.AttributeError)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
                throw pye;
            }
            complexReal = new PyComplex(toFloat.getValue());
        }
        if (imag == null) {
            complexImag = new PyComplex(0.0);
        } else if (imag instanceof PyComplex) {
            complexImag = (PyComplex)imag;
        } else {
            toFloat = null;
            try {
                toFloat = imag.__float__();
            }
            catch (PyException pye) {
                if (pye.match(Py.AttributeError)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
                throw pye;
            }
            complexImag = new PyComplex(toFloat.getValue());
        }
        complexReal.real -= complexImag.imag;
        complexReal.imag = complexReal.imag == 0.0 ? complexImag.real : (complexReal.imag += complexImag.real);
        if (new_.for_type != subtype) {
            complexReal = new PyComplexDerived(subtype, complexReal.real, complexReal.imag);
        }
        return complexReal;
    }

    public final PyFloat getReal() {
        return Py.newFloat(this.real);
    }

    public final PyFloat getImag() {
        return Py.newFloat(this.imag);
    }

    public static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    @Override
    public String toString() {
        return this.__str__().toString();
    }

    @Override
    public PyString __str__() {
        return this.complex___str__();
    }

    final PyString complex___str__() {
        return Py.newString(this.formatComplex(SPEC_STR));
    }

    @Override
    public PyString __repr__() {
        return this.complex___repr__();
    }

    final PyString complex___repr__() {
        return Py.newString(this.formatComplex(SPEC_REPR));
    }

    private String formatComplex(InternalFormat.Spec spec) {
        int size = 2 * FloatFormatter.size(spec) + 3;
        FloatFormatter f = new FloatFormatter(new StringBuilder(size), spec);
        f.setBytes(true);
        f.setMinFracDigits(0);
        if (Double.doubleToLongBits(this.real) == 0L) {
            f.format(this.imag).append('j');
        } else {
            f.append('(').format(this.real).format(this.imag, "+").append("j)");
        }
        return f.pad().getResult();
    }

    @Override
    public int hashCode() {
        return this.complex___hash__();
    }

    final int complex___hash__() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long v = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)v ^ (int)(v >> 32);
    }

    @Override
    public boolean __nonzero__() {
        return this.complex___nonzero__();
    }

    final boolean complex___nonzero__() {
        return this.real != 0.0 || this.imag != 0.0;
    }

    @Override
    public int __cmp__(PyObject other) {
        if (!this.canCoerce(other)) {
            return -2;
        }
        PyComplex c = this.coerce(other);
        double oreal = c.real;
        double oimag = c.imag;
        if (this.real == oreal && this.imag == oimag) {
            return 0;
        }
        if (this.real != oreal) {
            return this.real < oreal ? -1 : 1;
        }
        return this.imag < oimag ? -1 : 1;
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.complex___eq__(other);
    }

    final PyObject complex___eq__(PyObject other) {
        switch (this.eq_helper(other)) {
            case 0: {
                return Py.False;
            }
            case 1: {
                return Py.True;
            }
        }
        return null;
    }

    private int eq_helper(PyObject other) {
        boolean equal;
        if (other instanceof PyComplex) {
            PyComplex c = (PyComplex)other;
            equal = this.real == c.real && this.imag == c.imag;
        } else if (other instanceof PyFloat) {
            PyFloat f = (PyFloat)other;
            equal = this.imag == 0.0 && this.real == f.getValue();
        } else if (other instanceof PyInteger || other instanceof PyLong) {
            PyFloat f;
            double r;
            equal = this.imag == 0.0 ? (Double.isInfinite(r = this.real) || Double.isNaN(r) ? false : (f = new PyFloat(r)).float___cmp__(other) == 0) : false;
        } else {
            return 2;
        }
        return equal ? 1 : 0;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.complex___ne__(other);
    }

    final PyObject complex___ne__(PyObject other) {
        switch (this.eq_helper(other)) {
            case 0: {
                return Py.True;
            }
            case 1: {
                return Py.False;
            }
        }
        return null;
    }

    private PyObject unsupported_comparison(PyObject other) {
        if (!this.canCoerce(other)) {
            return null;
        }
        throw Py.TypeError("cannot compare complex numbers using <, <=, >, >=");
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.complex___ge__(other);
    }

    final PyObject complex___ge__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.complex___gt__(other);
    }

    final PyObject complex___gt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.complex___le__(other);
    }

    final PyObject complex___le__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.complex___lt__(other);
    }

    final PyObject complex___lt__(PyObject other) {
        return this.unsupported_comparison(other);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.complex___coerce_ex__(other);
    }

    final PyObject complex___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.complex___coerce_ex__(other));
    }

    final PyObject complex___coerce_ex__(PyObject other) {
        if (other instanceof PyComplex) {
            return other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject other) {
        return other instanceof PyComplex || other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private final PyComplex coerce(PyObject other) {
        if (other instanceof PyComplex) {
            return (PyComplex)other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.complex___add__(right);
    }

    final PyObject complex___add__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        PyComplex c = this.coerce(right);
        return new PyComplex(this.real + c.real, this.imag + c.imag);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.complex___radd__(left);
    }

    final PyObject complex___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static final PyObject _sub(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real - o2.real, o1.imag - o2.imag);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.complex___sub__(right);
    }

    final PyObject complex___sub__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(right));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.complex___rsub__(left);
    }

    final PyObject complex___rsub__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._sub(this.coerce(left), this);
    }

    private static final PyObject _mul(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real * o2.real - o1.imag * o2.imag, o1.real * o2.imag + o1.imag * o2.real);
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.complex___mul__(right);
    }

    final PyObject complex___mul__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(right));
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.complex___rmul__(left);
    }

    final PyObject complex___rmul__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mul(this.coerce(left), this);
    }

    private static final PyObject _div(PyComplex a, PyComplex b) {
        double abs_bimag;
        double abs_breal = b.real < 0.0 ? -b.real : b.real;
        double d = abs_bimag = b.imag < 0.0 ? -b.imag : b.imag;
        if (abs_breal >= abs_bimag) {
            if (abs_breal == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            return new PyComplex((a.real + a.imag * ratio) / denom, (a.imag - a.real * ratio) / denom);
        }
        double ratio = b.real / b.imag;
        double denom = b.real * ratio + b.imag;
        return new PyComplex((a.real * ratio + a.imag) / denom, (a.imag * ratio - a.real) / denom);
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.complex___div__(right);
    }

    final PyObject complex___div__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        if (Options.division_warning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this, this.coerce(right));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.complex___rdiv__(left);
    }

    final PyObject complex___rdiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        if (Options.division_warning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this.coerce(left), this);
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.complex___floordiv__(right);
    }

    final PyObject complex___floordiv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right)).__finditem__(0);
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.complex___rfloordiv__(left);
    }

    final PyObject complex___rfloordiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this).__finditem__(0);
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.complex___truediv__(right);
    }

    final PyObject complex___truediv__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(right));
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.complex___rtruediv__(left);
    }

    final PyObject complex___rtruediv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._div(this.coerce(left), this);
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.complex___mod__(right);
    }

    final PyObject complex___mod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(right));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.complex___rmod__(left);
    }

    final PyObject complex___rmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mod(this.coerce(left), this);
    }

    private static PyObject _mod(PyComplex value, PyComplex right) {
        Py.warning(Py.DeprecationWarning, "complex divmod(), // and % are deprecated");
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return value.__sub__(z.__mul__(right));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.complex___divmod__(right);
    }

    final PyObject complex___divmod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right));
    }

    @Override
    public PyObject __rdivmod__(PyObject left) {
        return this.complex___rdivmod__(left);
    }

    final PyObject complex___rdivmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this);
    }

    private static PyObject _divmod(PyComplex value, PyComplex right) {
        Py.warning(Py.DeprecationWarning, "complex divmod(), // and % are deprecated");
        PyComplex z = (PyComplex)PyComplex._div(value, right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return new PyTuple(z, value.__sub__(z.__mul__(right)));
    }

    private static PyObject ipow(PyComplex value, int iexp) {
        int pow = iexp;
        if (pow < 0) {
            pow = -pow;
        }
        double xr = value.real;
        double xi = value.imag;
        double zr = 1.0;
        double zi = 0.0;
        while (pow > 0) {
            double tmp;
            if ((pow & 1) != 0) {
                tmp = zr * xr - zi * xi;
                zi = zi * xr + zr * xi;
                zr = tmp;
            }
            if ((pow >>= 1) == 0) break;
            tmp = xr * xr - xi * xi;
            xi = xr * xi * 2.0;
            xr = tmp;
        }
        PyComplex ret = new PyComplex(zr, zi);
        if (iexp < 0) {
            return new PyComplex(1.0, 0.0).__div__(ret);
        }
        return ret;
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.complex___pow__(right, modulo);
    }

    final PyObject complex___pow__(PyObject right, PyObject modulo) {
        if (modulo != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(right));
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        return this.complex___rpow__(left);
    }

    final PyObject complex___rpow__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._pow(this.coerce(left), this);
    }

    public static PyObject _pow(PyComplex value, PyComplex right) {
        double xr = value.real;
        double xi = value.imag;
        double yr = right.real;
        double yi = right.imag;
        if (yr == 0.0 && yi == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (xr == 0.0 && xi == 0.0 && (yi != 0.0 || yr < 0.0)) {
            throw Py.ZeroDivisionError("0.0 to a negative or complex power");
        }
        int iexp = (int)yr;
        if (yi == 0.0 && yr == (double)iexp && iexp >= -128 && iexp <= 128) {
            return PyComplex.ipow(value, iexp);
        }
        double abs = Math.hypot(xr, xi);
        double len = Math.pow(abs, yr);
        double at = Math.atan2(xi, xr);
        double phase = at * yr;
        if (yi != 0.0) {
            len /= Math.exp(at * yi);
            phase += yi * Math.log(abs);
        }
        return new PyComplex(len * Math.cos(phase), len * Math.sin(phase));
    }

    @Override
    public PyObject __neg__() {
        return this.complex___neg__();
    }

    final PyObject complex___neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    @Override
    public PyObject __pos__() {
        return this.complex___pos__();
    }

    final PyObject complex___pos__() {
        return this.getType() == TYPE ? this : new PyComplex(this.real, this.imag);
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyObject __abs__() {
        return this.complex___abs__();
    }

    final PyObject complex___abs__() {
        double mag = Math.hypot(this.real, this.imag);
        if (Double.isInfinite(mag) && !Double.isInfinite(this.real) && !Double.isInfinite(this.imag)) {
            throw Py.OverflowError("absolute value too large");
        }
        return new PyFloat(mag);
    }

    @Override
    public PyObject __int__() {
        return this.complex___int__();
    }

    final PyInteger complex___int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    @Override
    public PyObject __long__() {
        return this.complex___long__();
    }

    final PyObject complex___long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    @Override
    public PyFloat __float__() {
        return this.complex___float__();
    }

    final PyFloat complex___float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.real, this.imag);
    }

    @Override
    public PyComplex conjugate() {
        return this.complex_conjugate();
    }

    final PyComplex complex_conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    final PyTuple complex___getnewargs__() {
        return new PyTuple(new PyFloat(this.real), new PyFloat(this.imag));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.complex___getnewargs__();
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.complex___format__(formatSpec);
    }

    final PyObject complex___format__(PyObject formatSpec) {
        String result2;
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        PyString formatSpecStr = (PyString)formatSpec;
        switch (PyComplex.checkSpecification(spec)) {
            case 0: {
                spec = spec.withDefaults(SPEC_STR);
                result2 = this.formatComplex(spec);
                break;
            }
            case 1: {
                spec = spec.withDefaults(InternalFormat.Spec.NUMERIC);
                int size = 2 * FloatFormatter.size(spec) + 1;
                FloatFormatter f = new FloatFormatter(new StringBuilder(size), spec);
                f.setBytes(!(formatSpecStr instanceof PyUnicode));
                f.format(this.real).format(this.imag, "+").append('j');
                result2 = f.pad().getResult();
                break;
            }
            default: {
                throw InternalFormat.Formatter.unknownFormat(spec.type, "complex");
            }
        }
        return formatSpecStr.createInstance(result2);
    }

    private static int checkSpecification(InternalFormat.Spec spec) {
        switch (spec.type) {
            case 'n': {
                if (spec.grouping) {
                    throw InternalFormat.Formatter.notAllowed("Grouping", "complex", spec.type);
                }
            }
            case 'E': 
            case 'F': 
            case 'G': 
            case 'e': 
            case 'f': 
            case 'g': 
            case '\uffff': {
                if (spec.alternate) {
                    throw FloatFormatter.alternateFormNotAllowed("complex");
                }
                if (spec.fill == '0') {
                    throw FloatFormatter.zeroPaddingNotAllowed("complex");
                }
                if (spec.align == '=') {
                    throw FloatFormatter.alignmentNotAllowed('=', "complex");
                }
                return spec.type == '\uffff' ? 0 : 1;
            }
        }
        return 2;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    static {
        PyType.addBuilder(PyComplex.class, new PyComplex$PyExposer());
        TYPE = PyType.fromClass(PyComplex.class);
        SPEC_REPR = InternalFormat.fromText(" >r");
        SPEC_STR = InternalFormat.fromText(" >.12g");
        J = new PyComplex(0.0, 1.0);
        Inf = new PyComplex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        NaN = new PyComplex(Double.NaN, Double.NaN);
    }

    public class PyComplex$complex___str___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___str___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyComplex$complex___str___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___str___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___str__();
        }
    }

    public class PyComplex$complex___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___eq___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__eq__(y) <==> x==y";
        }

        public PyComplex$complex___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__eq__(y) <==> x==y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyComplex$complex___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___ge___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyComplex$complex___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___gt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyComplex$complex___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___le___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyComplex$complex___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___add___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyComplex$complex___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___radd___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyComplex$complex___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rsub___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyComplex$complex___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___mul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyComplex$complex___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___div___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___div___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__div__(y) <==> x/y";
        }

        public PyComplex$complex___div___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__div__(y) <==> x/y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___div___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___div__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rfloordiv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyComplex$complex___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rtruediv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyComplex$complex___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyComplex$complex___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___pow___exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyComplex$complex___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3 = ((PyComplex)this.self).complex___pow__(pyObject, pyObject2);
            if (pyObject3 == null) {
                return Py.NotImplemented;
            }
            return pyObject3;
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___pow__(pyObject, null);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___neg___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyComplex$complex___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___neg__();
        }
    }

    public class PyComplex$complex___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___int___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyComplex$complex___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___int__();
        }
    }

    public class PyComplex$complex___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___long___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyComplex$complex___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___long__();
        }
    }

    public class PyComplex$complex___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___float___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyComplex$complex___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___float__();
        }
    }

    public class PyComplex$complex___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___getnewargs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyComplex$complex___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___getnewargs__();
        }
    }

    public class PyComplex$complex___format___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___format___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "complex.__format__() -> str\n\nConverts to a string according to format_spec.";
        }

        public PyComplex$complex___format___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "complex.__format__() -> str\n\nConverts to a string according to format_spec.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyComplex$complex___format___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyComplex)this.self).complex___format__(pyObject);
        }
    }

    public class PyComplex$PyExposer
    extends BaseTypeBuilder {
        public PyComplex$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyComplex$complex___str___exposer("__str__"), new PyComplex$complex___repr___exposer("__repr__"), new PyComplex$complex___hash___exposer("__hash__"), new PyComplex$complex___nonzero___exposer("__nonzero__"), new PyComplex$complex___eq___exposer("__eq__"), new PyComplex$complex___ne___exposer("__ne__"), new PyComplex$complex___ge___exposer("__ge__"), new PyComplex$complex___gt___exposer("__gt__"), new PyComplex$complex___le___exposer("__le__"), new PyComplex$complex___lt___exposer("__lt__"), new PyComplex$complex___coerce___exposer("__coerce__"), new PyComplex$complex___add___exposer("__add__"), new PyComplex$complex___radd___exposer("__radd__"), new PyComplex$complex___sub___exposer("__sub__"), new PyComplex$complex___rsub___exposer("__rsub__"), new PyComplex$complex___mul___exposer("__mul__"), new PyComplex$complex___rmul___exposer("__rmul__"), new PyComplex$complex___div___exposer("__div__"), new PyComplex$complex___rdiv___exposer("__rdiv__"), new PyComplex$complex___floordiv___exposer("__floordiv__"), new PyComplex$complex___rfloordiv___exposer("__rfloordiv__"), new PyComplex$complex___truediv___exposer("__truediv__"), new PyComplex$complex___rtruediv___exposer("__rtruediv__"), new PyComplex$complex___mod___exposer("__mod__"), new PyComplex$complex___rmod___exposer("__rmod__"), new PyComplex$complex___divmod___exposer("__divmod__"), new PyComplex$complex___rdivmod___exposer("__rdivmod__"), new PyComplex$complex___pow___exposer("__pow__"), new PyComplex$complex___rpow___exposer("__rpow__"), new PyComplex$complex___neg___exposer("__neg__"), new PyComplex$complex___pos___exposer("__pos__"), new PyComplex$complex___abs___exposer("__abs__"), new PyComplex$complex___int___exposer("__int__"), new PyComplex$complex___long___exposer("__long__"), new PyComplex$complex___float___exposer("__float__"), new PyComplex$complex_conjugate_exposer("conjugate"), new PyComplex$complex___getnewargs___exposer("__getnewargs__"), new PyComplex$complex___format___exposer("__format__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyComplex$real_descriptor(), new PyComplex$imag_descriptor()};
            super("complex", PyComplex.class, Object.class, true, "complex(real[, imag]) -> complex number\n\nCreate a complex number from a real part and an optional imaginary part.\nThis is equivalent to (real + imag*1j) where imag defaults to 0.", pyBuiltinMethodArray, pyDataDescrArray, new PyComplex$exposed___new__());
        }
    }
}

