/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyXRange;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.izip$izip___init___exposer;
import org.python.modules.itertools.izip$next_exposer;
import org.python.modules.itertools.izipDerived;

@ExposedType(name="itertools.izip", base=PyObject.class, doc="izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.")
public class izip
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String izip_doc = "izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.";

    public izip() {
    }

    public izip(PyType subType) {
        super(subType);
    }

    public izip(PyObject ... args) {
        this.izip___init__(args);
    }

    @ExposedNew
    final void izip___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError(String.format("izip does not take keyword arguments", new Object[0]));
        }
        this.izip___init__(args);
    }

    private void izip___init__(PyObject[] argstar) {
        final int itemsize = argstar.length;
        if (itemsize == 0) {
            this.iter = (PyIterator)new PyXRange(0).__iter__();
            return;
        }
        final PyObject[] iters = new PyObject[itemsize];
        for (int i = 0; i < itemsize; ++i) {
            PyObject iter = argstar[i].__iter__();
            if (iter == null) {
                throw Py.TypeError("izip argument #" + (i + 1) + " must support iteration");
            }
            iters[i] = iter;
        }
        this.iter = new itertools.ItertoolsIterator(){

            @Override
            public PyObject __iternext__() {
                if (itemsize == 0) {
                    return null;
                }
                PyObject[] next = new PyObject[itemsize];
                for (int i = 0; i < itemsize; ++i) {
                    PyObject item = this.nextElement(iters[i]);
                    if (item == null) {
                        return null;
                    }
                    next[i] = item;
                }
                return new PyTuple(next);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(izip.class, new izip$PyExposer());
        TYPE = PyType.fromClass(izip.class);
    }

    public class izip$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            izip izip2 = new izip(this.for_type);
            if (bl) {
                izip2.izip___init__(pyObjectArray, stringArray);
            }
            return izip2;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new izipDerived(pyType);
        }
    }

    public class izip$PyExposer
    extends BaseTypeBuilder {
        public izip$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new izip$izip___init___exposer("__init__"), new izip$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.izip", izip.class, PyObject.class, true, "izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.", pyBuiltinMethodArray, pyDataDescrArray, new izip$exposed___new__());
        }
    }
}

