/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.ObjectKeyExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectKeyExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Log log = LogFactory.getLog(ObjectKeyExpressionEvaluator.class);
    private ObjectKeyExpression expression;
    private boolean isCalledFromFilter;

    public ObjectKeyExpressionEvaluator(EvaluationContext evaluationContext, ObjectKeyExpression expression) {
        this(evaluationContext, expression, false);
    }

    public ObjectKeyExpressionEvaluator(EvaluationContext evaluationContext, ObjectKeyExpression expression, boolean isCalledFromFilter) {
        super(evaluationContext);
        this.expression = expression;
        this.isCalledFromFilter = isCalledFromFilter;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        List<JRJsonNode> nodes = contextNode.getNodes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("---> evaluating expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")"));
        }
        JsonNodeContainer result = new JsonNodeContainer();
        for (JRJsonNode node : nodes) {
            List<JRJsonNode> evaluatedNodes = this.singleEval(node);
            if (evaluatedNodes.size() <= 0) continue;
            result.addNodes(evaluatedNodes);
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private List<JRJsonNode> singleEval(JRJsonNode jrJsonNode) {
        switch (this.expression.getDirection()) {
            case DOWN: {
                return this.goDown(jrJsonNode);
            }
            case ANYWHERE_DOWN: {
                return this.goAnywhereDown(jrJsonNode);
            }
        }
        return null;
    }

    private List<JRJsonNode> goDown(JRJsonNode jrJsonNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("going " + (Object)((Object)MemberExpression.DIRECTION.DOWN) + " by " + (this.expression.isWildcard() ? "wildcard" : "key: [" + this.expression.getObjectKey() + "]") + " on " + jrJsonNode.getDataNode()));
        }
        List<JRJsonNode> result = new ArrayList<JRJsonNode>();
        JsonNode dataNode = jrJsonNode.getDataNode();
        if (dataNode.isObject()) {
            if (this.expression.isWildcard()) {
                ArrayNode container = this.getEvaluationContext().getObjectMapper().createArrayNode();
                Iterator it = dataNode.fields();
                while (it.hasNext()) {
                    JsonNode current = (JsonNode)((Map.Entry)it.next()).getValue();
                    if (!this.applyFilter(jrJsonNode.createChild(current))) continue;
                    container.add(current);
                }
                if (container.size() > 0) {
                    result.add(jrJsonNode.createChild((JsonNode)container));
                }
            } else {
                JRJsonNode deeperNode = this.goDeeperIntoObjectNode(jrJsonNode, this.isCalledFromFilter);
                if (deeperNode != null) {
                    result.add(deeperNode);
                }
            }
        } else if (dataNode.isArray()) {
            result = this.expression.isWildcard() ? this.filterArrayNode(jrJsonNode, (ArrayNode)dataNode, null, this.isCalledFromFilter) : this.filterArrayNode(jrJsonNode, (ArrayNode)dataNode, this.expression.getObjectKey(), this.isCalledFromFilter);
        }
        return result;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("going " + (Object)((Object)MemberExpression.DIRECTION.ANYWHERE_DOWN) + " by " + (this.expression.isWildcard() ? "wildcard" : "key: [" + this.expression.getObjectKey() + "]") + " on " + jrJsonNode.getDataNode()));
        }
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        JsonNode initialDataNode = jrJsonNode.getDataNode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("initial stack population with: " + initialDataNode));
        }
        if (initialDataNode.isArray()) {
            for (JsonNode deeper : initialDataNode) {
                stack.addLast(jrJsonNode.createChild(deeper));
            }
        } else {
            stack.push(jrJsonNode);
        }
        while (!stack.isEmpty()) {
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing stack element: " + stackDataNode));
            }
            if (stackDataNode.isObject()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("stack element is object; wildcard: " + this.expression.isWildcard()));
                }
                if (this.expression.isWildcard()) {
                    if (!this.applyFilter(stackNode)) continue;
                    result.add(stackNode);
                    continue;
                }
                JRJsonNode deeperNode = this.goDeeperIntoObjectNode(stackNode, false);
                if (deeperNode == null) continue;
                result.add(deeperNode);
                continue;
            }
            if (!stackDataNode.isValueNode() && !stackDataNode.isArray()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("stack element is " + (stackDataNode.isValueNode() ? "value node" : "array") + "; wildcard: " + this.expression.isWildcard()));
            }
            if (!this.expression.isWildcard() || !this.applyFilter(stackNode)) continue;
            result.add(stackNode);
        }
        return result;
    }

    private JRJsonNode goDeeperIntoObjectNode(JRJsonNode jrJsonNode, boolean keepMissingNode) {
        ObjectNode dataNode = (ObjectNode)jrJsonNode.getDataNode();
        JsonNode deeperNode = dataNode.path(this.expression.getObjectKey());
        if (!deeperNode.isMissingNode() && (deeperNode.isObject() || deeperNode.isValueNode() || deeperNode.isArray())) {
            JRJsonNode child = jrJsonNode.createChild(deeperNode);
            if (this.applyFilter(child)) {
                return child;
            }
        } else if (keepMissingNode && deeperNode.isMissingNode()) {
            return jrJsonNode.createChild(deeperNode);
        }
        return null;
    }
}

