/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;

class FontFamilyHtmlResourceHandler
implements HtmlResourceHandler {
    private String basePath;
    private Map<String, String> fontFaceIds;

    protected FontFamilyHtmlResourceHandler(String basePath, HtmlFontFamily htmlFontFamily) {
        HtmlFont htmlFont;
        this.basePath = basePath;
        this.fontFaceIds = new HashMap<String, String>();
        FontFamily fontFamily = htmlFontFamily.getFontFamily();
        FontFace fontFace = fontFamily.getNormalFace();
        if (fontFace != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, false);
            this.addHtmlFont(htmlFont);
        }
        if ((fontFace = fontFamily.getBoldFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, false);
            this.addHtmlFont(htmlFont);
        }
        if ((fontFace = fontFamily.getItalicFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, true);
            this.addHtmlFont(htmlFont);
        }
        if ((fontFace = fontFamily.getBoldItalicFace()) != null) {
            htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, true);
            this.addHtmlFont(htmlFont);
        }
    }

    protected void addHtmlFont(HtmlFont htmlFont) {
        this.fontFaceIds.put(htmlFont.getId() + ".ttf", htmlFont.getTtf());
        this.fontFaceIds.put(htmlFont.getId() + ".eot", htmlFont.getEot());
        this.fontFaceIds.put(htmlFont.getId() + ".woff", htmlFont.getWoff());
        this.fontFaceIds.put(htmlFont.getId() + ".svg", htmlFont.getSvg());
    }

    @Override
    public String getResourcePath(String id) {
        if (this.fontFaceIds.containsKey(id)) {
            return this.basePath + this.fontFaceIds.get(id);
        }
        return this.basePath + id;
    }

    @Override
    public void handleResource(String id, byte[] data) {
    }
}

