/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateParameterParser {
    private static final int TYPE_YEAR = 0;
    private static final int TYPE_MONTH = 1;
    private static final int TYPE_DAY = 2;
    private static final int TYPE_HOUR = 3;
    private static final int TYPE_MINUTE = 4;
    private static Map<String, Integer> stringValues = new HashMap<String, Integer>(0);

    public static Date getDateTime(String textValue, boolean endOfDay) {
        String[] textValues;
        if (!textValue.isEmpty() && textValue.contains(";") && (textValues = textValue.split(";")).length > 2) {
            Calendar calendar = Calendar.getInstance();
            for (int i = 0; i < textValues.length; ++i) {
                DateParameterParser.parseDateString(calendar, textValues[i], i);
            }
            if (endOfDay) {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
            }
            return calendar.getTime();
        }
        return null;
    }

    private static void parseDateString(Calendar calendar, String strValue, int type) {
        boolean stringValue = false;
        int value = 0;
        int offset = 0;
        try {
            value = Integer.valueOf(strValue.trim());
        }
        catch (Exception ex) {
            stringValue = true;
        }
        if (stringValue) {
            try {
                for (Map.Entry<String, Integer> str : stringValues.entrySet()) {
                    if (!strValue.contains(str.getKey())) continue;
                    int strVal = str.getValue();
                    if ((strValue = strValue.replaceAll(str.getKey(), "")).trim().isEmpty()) {
                        offset = strVal;
                        break;
                    }
                    int secondVal = Integer.valueOf(strValue.trim().substring(1).trim());
                    switch (strValue.trim().charAt(0)) {
                        case '+': {
                            offset = strVal + secondVal;
                            break;
                        }
                        case '-': {
                            offset = strVal - secondVal;
                            break;
                        }
                        case '*': {
                            offset = strVal * secondVal;
                            break;
                        }
                        case '/': {
                            offset = strVal / secondVal;
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int calendarIndication = -1;
        switch (type) {
            case 0: {
                calendarIndication = 1;
                break;
            }
            case 1: {
                calendarIndication = 2;
                break;
            }
            case 2: {
                calendarIndication = 5;
                break;
            }
            case 3: {
                calendarIndication = 11;
                break;
            }
            case 4: {
                calendarIndication = 12;
                break;
            }
        }
        if (stringValue) {
            calendar.add(calendarIndication, offset);
        } else {
            calendar.set(calendarIndication, type == 1 ? value - 1 : value);
        }
    }

    static {
        stringValues.put("current", 0);
        stringValues.put("previous", -1);
        stringValues.put("next", 1);
    }
}

