/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.dashboards;

import org.netxms.base.NXCPMessage;

public class DashboardElement {
    public static final int LABEL = 0;
    public static final int LINE_CHART = 1;
    public static final int BAR_CHART = 2;
    public static final int PIE_CHART = 3;
    public static final int TUBE_CHART = 4;
    public static final int STATUS_CHART = 5;
    public static final int STATUS_INDICATOR = 6;
    public static final int DASHBOARD = 7;
    public static final int NETWORK_MAP = 8;
    public static final int CUSTOM = 9;
    public static final int GEO_MAP = 10;
    public static final int ALARM_VIEWER = 11;
    public static final int AVAILABLITY_CHART = 12;
    public static final int DIAL_CHART = 13;
    public static final int WEB_PAGE = 14;
    public static final int TABLE_BAR_CHART = 15;
    public static final int TABLE_PIE_CHART = 16;
    public static final int TABLE_TUBE_CHART = 17;
    public static final int SEPARATOR = 18;
    public static final int TABLE_VALUE = 19;
    public static final int STATUS_MAP = 20;
    public static final int DCI_SUMMARY_TABLE = 21;
    public static final int SYSLOG_MONITOR = 22;
    public static final int SNMP_TRAP_MONITOR = 23;
    public static final int EVENT_MONITOR = 24;
    public static final int SERVICE_COMPONENTS = 25;
    public static final int RACK_DIAGRAM = 26;
    public static final int FILL = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int type;
    private String data;
    private String layout;

    public DashboardElement(int type, String data) {
        this.type = type;
        this.data = data;
        this.layout = "<layout><horizontalSpan>1</horizontalSpan><verticalSpan>1</verticalSpan><horizontalAlignment>0</horizontalAlignment><verticalAlignment>0</verticalAlignment></layout>";
    }

    public DashboardElement(NXCPMessage msg, long baseId) {
        this.type = msg.getFieldAsInt32(baseId);
        this.data = msg.getFieldAsString(baseId + 1L);
        this.layout = msg.getFieldAsString(baseId + 2L);
    }

    public DashboardElement(DashboardElement src) {
        this.type = src.type;
        this.data = src.data;
        this.layout = src.layout;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.data);
        msg.setField(baseId + 2L, this.layout);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }
}

