/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.ObjectAction;

public class ObjectTool
implements ObjectAction {
    public static final int TYPE_INTERNAL = 0;
    public static final int TYPE_ACTION = 1;
    public static final int TYPE_TABLE_SNMP = 2;
    public static final int TYPE_TABLE_AGENT = 3;
    public static final int TYPE_URL = 4;
    public static final int TYPE_LOCAL_COMMAND = 5;
    public static final int TYPE_SERVER_COMMAND = 6;
    public static final int TYPE_FILE_DOWNLOAD = 7;
    public static final int TYPE_SERVER_SCRIPT = 8;
    public static final int ASK_CONFIRMATION = 1;
    public static final int GENERATES_OUTPUT = 2;
    public static final int DISABLED = 4;
    public static final int SHOW_IN_COMMANDS = 8;
    public static final int SNMP_INDEXED_BY_VALUE = 16;
    protected long id;
    protected String name;
    protected String displayName;
    protected int type;
    protected int flags;
    protected String description;
    protected String data;
    protected String confirmationText;
    protected String commandName;
    protected String commandShortName;
    protected ObjectMenuFilter filter;
    protected byte[] imageData;
    protected Map<String, InputField> inputFields;

    protected ObjectTool() {
        this.filter = new ObjectMenuFilter();
        this.inputFields = new HashMap<String, InputField>(0);
    }

    public ObjectTool(NXCPMessage msg, long baseId) {
        block4: {
            this.id = msg.getFieldAsInt64(baseId);
            this.name = msg.getFieldAsString(baseId + 1L);
            this.type = msg.getFieldAsInt32(baseId + 2L);
            this.data = msg.getFieldAsString(baseId + 3L);
            this.flags = msg.getFieldAsInt32(baseId + 4L);
            String filterData = msg.getFieldAsString(baseId + 6L);
            this.description = msg.getFieldAsString(baseId + 5L);
            this.confirmationText = msg.getFieldAsString(baseId + 7L);
            this.commandName = msg.getFieldAsString(baseId + 8L);
            this.commandShortName = msg.getFieldAsString(baseId + 9L);
            this.imageData = msg.getFieldAsBinary(baseId + 10L);
            try {
                this.filter = ObjectMenuFilter.createFromXml(filterData);
            }
            catch (Exception e) {
                this.filter = new ObjectMenuFilter();
                if (filterData.isEmpty()) break block4;
                Logger.debug((String)"ObjectTool.ObjectTool", (String)"Failed to create object tool filter from XML");
            }
        }
        int count = msg.getFieldAsInt32(baseId + 11L);
        this.inputFields = new HashMap<String, InputField>(count);
        long fieldId = baseId + 20L;
        for (int i = 0; i < count; ++i) {
            InputField f = new InputField(msg, fieldId);
            this.inputFields.put(f.getName(), f);
            fieldId += 10L;
        }
        if (this.type == 1 || this.type == 7 || this.type == 5 || this.type == 6 || this.type == 4) {
            this.validateInputFields();
        }
        this.createDisplayName();
    }

    protected void validateInputFields() {
        HashSet<String> names = new HashSet<String>();
        char[] in = this.data.toCharArray();
        int br = 0;
        int start = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == br) {
                if (br == 41) {
                    names.add(new String(Arrays.copyOfRange(in, start, i)));
                }
                br = 0;
                continue;
            }
            if (in[i] != '%' || br != 0) continue;
            if (++i == in.length) break;
            switch (in[i]) {
                case '(': {
                    br = 41;
                    break;
                }
                case '[': {
                    br = 93;
                    break;
                }
                case '{': {
                    br = 125;
                    break;
                }
                case '<': {
                    br = 62;
                    break;
                }
            }
            start = i + 1;
        }
        for (String n : names) {
            if (this.inputFields.containsKey(n)) continue;
            this.inputFields.put(n, new InputField(n));
        }
    }

    protected void createDisplayName() {
        String[] parts = this.name.split("->");
        this.displayName = parts.length > 0 ? parts[parts.length - 1].replace("&", "").trim() : this.name.replace("&", "").trim();
    }

    @Override
    public boolean isApplicableForNode(AbstractNode node) {
        return this.filter.isApplicableForNode(node);
    }

    public InputField getInputField(String name) {
        return this.inputFields.get(name);
    }

    public InputField[] getInputFields() {
        return this.inputFields.values().toArray(new InputField[this.inputFields.size()]);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getToolType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isVisibleInCommands() {
        return (this.flags & 8) != 0;
    }

    public boolean isEnabled() {
        return (this.flags & 4) == 0;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnmpOid() {
        return this.filter.snmpOid;
    }

    public String getData() {
        return this.data;
    }

    public String getConfirmationText() {
        return this.confirmationText;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDisplayName() {
        if (this.commandName != null && !this.commandName.isEmpty()) {
            return this.commandName;
        }
        return this.displayName;
    }

    public String getCommandShortName() {
        return this.commandShortName;
    }

    public String getCommandShortDisplayName() {
        if (this.commandShortName != null && !this.commandShortName.isEmpty()) {
            return this.commandShortName;
        }
        return this.getCommandDisplayName();
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getToolNodeOS() {
        return this.filter.toolNodeOS;
    }

    public String getToolWorkstationOS() {
        return this.filter.toolWorkstationOS;
    }

    public String getToolTemplate() {
        return this.filter.toolTemplate;
    }

    @Override
    public ObjectMenuFilter getMenuFilter() {
        return this.filter;
    }

    @Override
    public void setMenuFilter(ObjectMenuFilter filter) {
        this.filter = filter;
    }
}

