/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import javax.servlet.ServletContext;
import org.json.JSONObject;
import org.netxms.websvc.SessionStore;
import org.netxms.websvc.SessionToken;
import org.netxms.websvc.handlers.AbstractHandler;
import org.restlet.data.CookieSetting;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sessions
extends AbstractHandler {
    private Logger log = LoggerFactory.getLogger(Sessions.class);

    @Post
    public Representation onPost(Representation entity) throws Exception {
        String login = null;
        String password = null;
        if (entity != null) {
            JSONObject request = new JsonRepresentation(entity).getJsonObject();
            login = request.getString("login");
            password = request.getString("password");
        } else {
            String[] values;
            this.log.warn("No POST data in login call, looking for authentication data instead...");
            String authHeader = this.getHeader("Authorization");
            if (authHeader != null && !authHeader.isEmpty() && (values = this.decodeBase64(authHeader).split(":", 2)).length == 2) {
                login = values[0];
                password = values[1];
            }
        }
        if (login == null || password == null) {
            this.log.warn("Login or password not specified in login call");
            return new StringRepresentation((CharSequence)this.createErrorResponse(3).toString(), MediaType.APPLICATION_JSON);
        }
        SessionToken token = this.login(login, password);
        this.log.info("Logged in to NetXMS server, assigned session id " + token.getGuid());
        this.getCookieSettings().add((Object)new CookieSetting(0, "session_handle", token.getGuid().toString(), "/", null));
        this.getResponse().getHeaders().add((Object)new Header("Session-Id", token.getGuid().toString()));
        JSONObject response = new JSONObject();
        response.put("session", (Object)token.getGuid().toString());
        response.put("serverVersion", (Object)this.getSession().getServerVersion());
        return new StringRepresentation((CharSequence)response.toString(), MediaType.APPLICATION_JSON);
    }

    protected Object delete(String id) throws Exception {
        if (this.getSessionToken().getGuid().toString().equals(id)) {
            this.log.info("Logout request for session " + id);
            this.getSession().disconnect();
            SessionStore.getInstance((ServletContext)this.getServletContext()).unregisterSession(this.getSessionToken().getGuid());
            return new JSONObject();
        }
        this.log.warn("Logout request for different session (" + this.getSessionToken().getGuid() + " -- " + id);
        return this.createErrorResponse(2);
    }
}

