/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.VPNConnector;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.api.ObjectDetailsProvider;
import org.netxms.ui.eclipse.objectview.widgets.ObjectPopupDialog;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusMapInterface;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusRadialWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;

public class ObjectStatusMapRadial
extends Composite
implements ISelectionProvider,
ObjectStatusMapInterface {
    private IViewPart viewPart;
    private long rootObjectId;
    private NXCSession session;
    private FilterText filterTextControl;
    private ScrolledComposite scroller;
    private Composite dataArea;
    private ISelection selection = null;
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private MenuManager menuManager;
    private Font titleFont;
    private boolean filterEnabled = true;
    private int severityFilter = 255;
    private String textFilter = "";
    private ObjectStatusRadialWidget widget;
    private SortedMap<Integer, ObjectDetailsProvider> detailsProviders = new TreeMap<Integer, ObjectDetailsProvider>();
    private Set<Runnable> refreshListeners = new HashSet<Runnable>();
    private AbstractObject tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;

    public ObjectStatusMapRadial(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(parent, style);
        this.initDetailsProviders();
        this.viewPart = viewPart;
        this.session = ConsoleSharedData.getSession();
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4 || n.getCode() == 99) {
                    ObjectStatusMapRadial.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ObjectStatusMapRadial.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectStatusMapRadial.this.session.removeListener(sessionListener);
            }
        });
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.filterTextControl = new FilterText((Composite)this, 0, null, allowFilterClose);
        this.filterTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectStatusMapRadial.this.onFilterModify();
            }
        });
        this.filterTextControl.setCloseAction(new Action(){

            public void run() {
                ObjectStatusMapRadial.this.enableFilter(false);
            }
        });
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.scroller.setBackground(this.getBackground());
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ObjectStatusMapRadial.this.getClientArea();
                ObjectStatusMapRadial.this.scroller.setMinSize(ObjectStatusMapRadial.this.dataArea.computeSize(r.width, -1));
            }
        });
        this.scroller.getVerticalBar().setIncrement(30);
        this.dataArea = new Composite((Composite)this.scroller, 0);
        this.scroller.setContent((Control)this.dataArea);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(this.getBackground());
        if (Platform.getOS().equals("win32")) {
            this.titleFont = new Font((Device)parent.getDisplay(), "Verdana", 10, 1);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ObjectStatusMapRadial.this.titleFont.dispose();
                }
            });
        } else {
            this.titleFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        }
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ObjectStatusMapRadial.this.fillContextMenu(manager);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterTextControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.scroller.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterTextControl.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterTextControl.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)(this.viewPart != null ? this.viewPart.getSite() : null), (ISelectionProvider)this);
    }

    @Override
    public void setRootObject(long objectId) {
        this.rootObjectId = objectId;
        this.refresh();
    }

    public Set<Long> createFilteredList(AbstractObject root, boolean flterByTest) {
        HashSet<Long> aceptedlist = new HashSet<Long>();
        for (AbstractObject obj : root.getAllChilds(-1)) {
            if (obj instanceof Interface || obj instanceof NetworkService || obj instanceof VPNConnector) continue;
            if (flterByTest) {
                if (!obj.getObjectName().toLowerCase().contains(this.textFilter)) continue;
                aceptedlist.add(obj.getObjectId());
                continue;
            }
            if ((1 << obj.getStatus().getValue() & this.severityFilter) == 0) continue;
            aceptedlist.add(obj.getObjectId());
        }
        return aceptedlist;
    }

    @Override
    public void refresh() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        Set<Long> aceptedlist = null;
        if (!this.textFilter.isEmpty()) {
            aceptedlist = this.createFilteredList(root, true);
        }
        if (this.severityFilter != 255) {
            aceptedlist = this.createFilteredList(root, false);
        }
        if (this.widget == null) {
            this.widget = new ObjectStatusRadialWidget(this.dataArea, root, aceptedlist);
            this.widget.setLayoutData(new GridData(4, 4, true, true));
            this.widget.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != ObjectStatusMapRadial.this.tooltipDialog.getShell()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                    ObjectStatusMapRadial.this.tooltipObject = null;
                    AbstractObject object = ObjectStatusMapRadial.this.widget.getObjectFromPoint(e.x, e.y);
                    if (object != null) {
                        ObjectStatusMapRadial.this.setSelection((ISelection)new StructuredSelection((Object)object));
                        if (e.button == 1) {
                            ObjectStatusMapRadial.this.callDetailsProvider(object);
                        }
                    } else {
                        ObjectStatusMapRadial.this.setSelection((ISelection)new StructuredSelection());
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            WidgetHelper.attachMouseTrackListener((Composite)this.widget, (MouseTrackListener)new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    AbstractObject object = ObjectStatusMapRadial.this.widget.getObjectFromPoint(e.x, e.y);
                    if (object != null && (object != ObjectStatusMapRadial.this.tooltipObject || ObjectStatusMapRadial.this.tooltipDialog == null || ObjectStatusMapRadial.this.tooltipDialog.getShell() == null || ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed())) {
                        if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed()) {
                            ObjectStatusMapRadial.this.tooltipDialog.close();
                        }
                        ObjectStatusMapRadial.this.tooltipObject = object;
                        ObjectStatusMapRadial.this.tooltipDialog = new ObjectPopupDialog(ObjectStatusMapRadial.this.getShell(), object, ObjectStatusMapRadial.this.widget.toDisplay(e.x, e.y));
                        ObjectStatusMapRadial.this.tooltipDialog.open();
                    } else if (object == null && ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                }

                public void mouseExit(MouseEvent e) {
                    if (ObjectStatusMapRadial.this.tooltipDialog != null && ObjectStatusMapRadial.this.tooltipDialog.getShell() != null && !ObjectStatusMapRadial.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != ObjectStatusMapRadial.this.tooltipDialog.getShell()) {
                        ObjectStatusMapRadial.this.tooltipDialog.close();
                        ObjectStatusMapRadial.this.tooltipDialog = null;
                    }
                    ObjectStatusMapRadial.this.tooltipObject = null;
                }

                public void mouseEnter(MouseEvent e) {
                }
            });
            Menu menu = this.menuManager.createContextMenu((Control)this.widget);
            this.widget.setMenu(menu);
            if (this.viewPart != null) {
                this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
            }
        } else {
            this.widget.updateObject(root, aceptedlist);
            this.widget.redraw();
        }
        this.dataArea.layout(true, true);
        Rectangle r = this.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    private void callDetailsProvider(AbstractObject object) {
        for (ObjectDetailsProvider p : this.detailsProviders.values()) {
            if (!p.canProvideDetails(object)) continue;
            p.provideDetails(object, this.viewPart);
            break;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(event);
        }
    }

    private void initDetailsProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.objectDetailsProvider");
        int i = 0;
        while (i < elements.length) {
            try {
                int priority;
                ObjectDetailsProvider provider = (ObjectDetailsProvider)elements[i].createExecutableExtension("class");
                try {
                    priority = Integer.parseInt(elements[i].getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {
                    priority = 65535;
                }
                this.detailsProviders.put(priority, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public int getSeverityFilter() {
        return this.severityFilter;
    }

    @Override
    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    @Override
    public void addRefreshListener(Runnable listener) {
        this.refreshListeners.add(listener);
    }

    @Override
    public void removeRefreshListener(Runnable listener) {
        this.refreshListeners.remove(listener);
    }

    @Override
    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterTextControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.scroller.getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterTextControl) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterTextControl.setFocus();
        } else {
            this.setFilterText("");
        }
    }

    @Override
    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void setFilterCloseAction(Action action) {
        this.filterTextControl.setCloseAction(action);
    }

    @Override
    public void setFilterText(String text) {
        this.filterTextControl.setText(text);
        this.onFilterModify();
    }

    @Override
    public String getFilterText() {
        return this.filterTextControl.getText();
    }

    private void onFilterModify() {
        String text = this.filterTextControl.getText().trim().toLowerCase();
        if (!this.textFilter.equals(text)) {
            this.textFilter = text;
            this.refresh();
        }
    }
}

