/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.GeoLocation;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.MobileDevice;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontTools;

public class ObjectGeoLocationViewer
extends AbstractGeoMapViewer
implements MouseTrackListener {
    private static final int OBJECT_TOOLTIP_X_MARGIN = 6;
    private static final int OBJECT_TOOLTIP_Y_MARGIN = 6;
    private static final int OBJECT_TOOLTIP_SPACING = 6;
    private static final Color ACTIVE_BORDER_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private List<AbstractObject> objects = new ArrayList<AbstractObject>();
    private AbstractObject currentObject = null;
    private List<ObjectIcon> objectIcons = new ArrayList<ObjectIcon>();
    private Point objectToolTipLocation = null;
    private Rectangle objectTooltipRectangle = null;
    private Font objectToolTipHeaderFont;
    private long rootObjectId = 0L;
    private String filterString = null;

    public ObjectGeoLocationViewer(Composite parent, int style) {
        super(parent, style);
        this.addMouseTrackListener(this);
        this.objectToolTipHeaderFont = FontTools.createFont((String[])TITLE_FONTS, (int)1, (int)1);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectGeoLocationViewer.this.objectToolTipHeaderFont.dispose();
            }
        });
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
    }

    @Override
    protected void onMapLoad() {
        this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage, this.rootObjectId, this.filterString);
        this.redraw();
    }

    @Override
    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
        GeoLocation currLocation = object.getGeolocation();
        if (currLocation.getType() != 0 && this.coverage.contains(currLocation.getLatitude(), currLocation.getLongitude()) || prevLocation != null && prevLocation.getType() != 0 && this.coverage.contains(prevLocation.getLatitude(), prevLocation.getLongitude())) {
            this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage, this.rootObjectId, this.filterString);
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
        AbstractObject object;
        if (this.objectTooltipRectangle == null && (object = this.getObjectAtPoint(new Point(e.x, e.y))) != this.currentObject) {
            this.objectToolTipLocation = object != null ? new Point(e.x, e.y) : null;
            this.setCurrentObject(object);
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.setCurrentObject(null);
    }

    @Override
    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        if (this.objectTooltipRectangle != null && !this.objectTooltipRectangle.contains(e.x, e.y)) {
            this.objectTooltipRectangle = null;
            this.objectToolTipLocation = null;
            this.currentObject = null;
            this.redraw();
        }
    }

    @Override
    public void mouseDown(MouseEvent e) {
        AbstractObject object;
        super.mouseDown(e);
        if (e.button != 1 && (object = this.getObjectAtPoint(this.currentPoint)) != this.currentObject) {
            this.setCurrentObject(object);
        }
    }

    private void setCurrentObject(AbstractObject object) {
        this.currentObject = object;
        if (this.currentObject != null) {
            int idx = this.objects.indexOf(this.currentObject);
            this.objects.remove(idx);
            this.objects.add(this.currentObject);
        } else {
            this.objectToolTipLocation = null;
            this.objectTooltipRectangle = null;
        }
        this.redraw();
    }

    @Override
    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH) {
        this.objectIcons.clear();
        Point centerXY = GeoLocationCache.coordinateToDisplay(currentLocation, this.accessor.getZoom());
        for (AbstractObject object : this.objects) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay(object.getGeolocation(), this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, object);
        }
        if (this.objectToolTipLocation != null) {
            this.drawObjectToolTip(gc);
        }
    }

    private void drawObject(GC gc, int x, int y, AbstractObject object) {
        boolean selected = this.currentObject != null && this.currentObject.getObjectId() == object.getObjectId();
        Image image = this.labelProvider.getImage((Object)object);
        if (image == null) {
            image = SharedIcons.IMG_UNKNOWN_OBJECT;
        }
        int w = image.getImageData().width + 8;
        int h = image.getImageData().height + 8;
        Rectangle rect = new Rectangle(x - w / 2 - 1, y - 5 - h, w, h);
        Color bgColor = ColorConverter.adjustColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus()), (RGB)new RGB(255, 255, 255), (float)0.5f, (ColorCache)this.colorCache);
        gc.setBackground(bgColor);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 4, 4);
        if (selected) {
            gc.setLineWidth(3);
            gc.setForeground(ACTIVE_BORDER_COLOR);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 4, 4);
        }
        gc.setLineWidth(1);
        gc.setForeground(BORDER_COLOR);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 4, 4);
        int[] arrow = new int[]{x - 4, rect.y + rect.height, x, y, x + 4, rect.y + rect.height};
        gc.fillPolygon(arrow);
        gc.setForeground(bgColor);
        gc.drawPolygon(arrow);
        if (selected) {
            gc.drawLine(arrow[0], arrow[1] - 1, arrow[4], arrow[5] - 1);
            gc.setLineWidth(3);
            gc.setForeground(ACTIVE_BORDER_COLOR);
            gc.drawPolyline(arrow);
        }
        gc.setLineWidth(1);
        gc.setForeground(BORDER_COLOR);
        gc.drawPolyline(arrow);
        gc.drawImage(image, rect.x + 4, rect.y + 4);
        this.objectIcons.add(new ObjectIcon(object, rect, x, y));
    }

    private void drawObjectToolTip(GC gc) {
        String batteryLevel;
        String lastReport;
        String locationDetails;
        gc.setFont(this.objectToolTipHeaderFont);
        Point titleSize = gc.textExtent(this.currentObject.getObjectName());
        gc.setFont(JFaceResources.getDefaultFont());
        int width = Math.max(titleSize.x + 12, 128);
        int height = 12 + titleSize.y + 2 + 6;
        String location = this.currentObject.getGeolocation().toString();
        Point pt = gc.textExtent(location);
        if (width < pt.x) {
            width = pt.x;
        }
        height += pt.y;
        if (this.currentObject.getGeolocation().getTimestamp().getTime() > 0L && this.currentObject.getGeolocation().isAutomatic()) {
            String string;
            Messages.get();
            Object[] objectArray = new Object[2];
            objectArray[0] = RegionalSettings.getDateTimeFormat().format(this.currentObject.getGeolocation().getTimestamp());
            if (this.currentObject.getGeolocation().getType() == 2) {
                Messages.get();
                string = Messages.ObjectGeoLocationViewer_GPS;
            } else {
                Messages.get();
                string = Messages.ObjectGeoLocationViewer_Network;
            }
            objectArray[1] = string;
            locationDetails = String.format(Messages.ObjectGeoLocationViewer_ObtainedFrom, objectArray);
            pt = gc.textExtent(locationDetails);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y;
        } else {
            locationDetails = null;
        }
        String postalAddress = this.currentObject.getPostalAddress().getAddressLine();
        if (!postalAddress.isEmpty()) {
            pt = gc.textExtent(postalAddress);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 6;
        }
        if (this.currentObject instanceof MobileDevice) {
            String string;
            Messages.get();
            Object[] objectArray = new Object[1];
            if (((MobileDevice)this.currentObject).getLastReportTime().getTime() > 0L) {
                string = RegionalSettings.getDateTimeFormat().format(((MobileDevice)this.currentObject).getLastReportTime());
            } else {
                Messages.get();
                string = Messages.ObjectGeoLocationViewer_Never;
            }
            objectArray[0] = string;
            lastReport = String.format(Messages.ObjectGeoLocationViewer_LastReport, objectArray);
            pt = gc.textExtent(lastReport);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 12 + 1;
            if (((MobileDevice)this.currentObject).getBatteryLevel() >= 0) {
                Messages.get();
                batteryLevel = String.format(Messages.ObjectGeoLocationViewer_BatteryLevel, ((MobileDevice)this.currentObject).getBatteryLevel());
                pt = gc.textExtent(batteryLevel);
                if (width < pt.x) {
                    width = pt.x;
                }
                height += pt.y;
            } else {
                batteryLevel = null;
            }
        } else {
            lastReport = null;
            batteryLevel = null;
        }
        if (this.currentObject.getComments() != null && !this.currentObject.getComments().isEmpty()) {
            pt = gc.textExtent(this.currentObject.getComments());
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 12 + 1;
        }
        Rectangle ca = this.getClientArea();
        Rectangle rect = new Rectangle(this.objectToolTipLocation.x - (width += 12) / 2, this.objectToolTipLocation.y - height / 2, width, height);
        if (rect.x < 0) {
            rect.x = 0;
        } else if (rect.x + rect.width >= ca.width) {
            rect.x = ca.width - rect.width - 1;
        }
        if (rect.y < 0) {
            rect.y = 0;
        } else if (rect.y + rect.height >= ca.height) {
            rect.y = ca.height - rect.height - 1;
        }
        gc.setBackground(this.colorCache.create(224, 224, 224));
        gc.setAlpha(192);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setForeground(this.colorCache.create(92, 92, 92));
        gc.setAlpha(255);
        gc.setLineWidth(3);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setLineWidth(1);
        int y = rect.y + 6 + titleSize.y + 2;
        gc.drawLine(rect.x + 1, y, rect.x + rect.width - 1, y);
        gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.currentObject.getStatus()));
        gc.fillOval(rect.x + 6, rect.y + 6 + titleSize.y / 2 - 4, 8, 8);
        gc.setForeground(this.colorCache.create(0, 0, 0));
        gc.setFont(this.objectToolTipHeaderFont);
        gc.drawText(this.currentObject.getObjectName(), rect.x + 6 + 12, rect.y + 6, true);
        gc.setFont(JFaceResources.getDefaultFont());
        int textLineHeight = gc.textExtent((String)"M").y;
        y = rect.y + 6 + titleSize.y + 6 + 2;
        gc.drawText(location, rect.x + 6, y, true);
        if (locationDetails != null) {
            gc.drawText(locationDetails, rect.x + 6, y += textLineHeight, true);
        }
        if (!postalAddress.isEmpty()) {
            gc.drawText(postalAddress, rect.x + 6, y += textLineHeight, true);
        }
        if (lastReport != null) {
            gc.setForeground(this.colorCache.create(92, 92, 92));
            gc.drawLine(rect.x + 1, y += textLineHeight + 6, rect.x + rect.width - 1, y);
            gc.setForeground(this.colorCache.create(0, 0, 0));
            gc.drawText(lastReport, rect.x + 6, y += 6, true);
            if (batteryLevel != null) {
                gc.drawText(batteryLevel, rect.x + 6, y += textLineHeight, true);
            }
        }
        if (this.currentObject.getComments() != null && !this.currentObject.getComments().isEmpty()) {
            gc.setForeground(this.colorCache.create(92, 92, 92));
            gc.drawLine(rect.x + 1, y += textLineHeight + 6, rect.x + rect.width - 1, y);
            gc.setForeground(this.colorCache.create(0, 0, 0));
            gc.drawText(this.currentObject.getComments(), rect.x + 6, y += 6, true);
        }
        this.objectTooltipRectangle = rect;
    }

    @Override
    public AbstractObject getObjectAtPoint(Point p) {
        int i = this.objectIcons.size() - 1;
        while (i >= 0) {
            ObjectIcon icon = this.objectIcons.get(i);
            if (icon.contains(p)) {
                return icon.object;
            }
            --i;
        }
        return null;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    private class ObjectIcon {
        public Rectangle rect;
        public Polygon arrow;
        public AbstractObject object;

        public ObjectIcon(AbstractObject object, Rectangle rect, int x, int y) {
            this.rect = rect;
            this.object = object;
            this.arrow = new Polygon();
            this.arrow.addPoint(x, y);
            this.arrow.addPoint(x - 4, rect.y + rect.height);
            this.arrow.addPoint(x + 4, rect.y + rect.height);
        }

        public boolean contains(Point p) {
            return this.rect.contains(p) || this.arrow.contains(p.x, p.y);
        }
    }
}

