/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.tweaklets.WorkbenchImplementation;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.ServerClockContributionItem;
import org.netxms.ui.eclipse.console.ServerNameStatusLineItem;
import org.netxms.ui.eclipse.console.StatusLineContributionItem;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction actionExit;
    private ActionFactory.IWorkbenchAction actionAbout;
    private Action actionAboutCustom;
    private ActionFactory.IWorkbenchAction actionShowPreferences;
    private ActionFactory.IWorkbenchAction actionCustomizePerspective;
    private ActionFactory.IWorkbenchAction actionSavePerspective;
    private ActionFactory.IWorkbenchAction actionResetPerspective;
    private ActionFactory.IWorkbenchAction actionClosePerspective;
    private ActionFactory.IWorkbenchAction actionCloseAllPerspectives;
    private Action actionExportPerspective;
    private Action actionImportPerspective;
    private ActionFactory.IWorkbenchAction actionMinimize;
    private ActionFactory.IWorkbenchAction actionMaximize;
    private Action actionClose;
    private ActionFactory.IWorkbenchAction actionPrevView;
    private ActionFactory.IWorkbenchAction actionNextView;
    private ActionFactory.IWorkbenchAction actionQuickAccess;
    private ActionFactory.IWorkbenchAction actionShowViewMenu;
    private Action actionOpenProgressView;
    private Action actionFullScreen;
    private Action actionLangArabic;
    private Action actionLangChinese;
    private Action actionLangCzech;
    private Action actionLangEnglish;
    private Action actionLangFrench;
    private Action actionLangGerman;
    private Action actionLangPortuguese;
    private Action actionLangRussian;
    private Action actionLangSpanish;
    private IContributionItem contribItemShowView;
    private IContributionItem contribItemOpenPerspective;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.contribItemShowView = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.contribItemOpenPerspective = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        this.actionExit = ActionFactory.QUIT.create(window);
        this.register((IAction)this.actionExit);
        this.actionAbout = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.actionAbout);
        Messages.get();
        this.actionAboutCustom = new Action(Messages.ApplicationActionBarAdvisor_About){

            public void run() {
                Dialog dlg = BrandingManager.getInstance().getAboutDialog(window.getShell());
                if (dlg != null) {
                    dlg.open();
                } else {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openInformation(shell, Messages.ApplicationActionBarAdvisor_AboutTitle, String.format(Messages.ApplicationActionBarAdvisor_AboutText, "2.2.2 (9504)"));
                }
            }
        };
        this.actionShowPreferences = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.actionShowPreferences);
        this.actionCustomizePerspective = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.actionCustomizePerspective);
        this.actionSavePerspective = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionSavePerspective);
        this.actionResetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.actionResetPerspective);
        this.actionClosePerspective = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionClosePerspective);
        this.actionCloseAllPerspectives = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.actionCloseAllPerspectives);
        this.actionMinimize = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.actionMinimize);
        this.actionMaximize = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.actionMaximize);
        this.actionClose = new CommandAction((IServiceLocator)window, "org.eclipse.ui.file.closePart");
        this.register((IAction)this.actionClose);
        this.actionPrevView = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.actionPrevView);
        this.actionNextView = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.actionNextView);
        this.actionQuickAccess = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.register((IAction)this.actionQuickAccess);
        this.actionShowViewMenu = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.actionShowViewMenu);
        this.actionOpenProgressView = new Action(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow win;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (win = wb.getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null) {
                    try {
                        page.showView("org.eclipse.ui.views.ProgressView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Messages.get();
        this.actionOpenProgressView.setText(Messages.ApplicationActionBarAdvisor_Progress);
        this.actionOpenProgressView.setImageDescriptor(Activator.getImageDescriptor("icons/pview.gif"));
        Messages.get();
        this.actionFullScreen = new Action(Messages.ApplicationActionBarAdvisor_FullScreen, 2){

            public void run() {
                boolean fullScreen = !PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getFullScreen();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setFullScreen(fullScreen);
                ApplicationActionBarAdvisor.this.actionFullScreen.setChecked(fullScreen);
            }
        };
        this.actionFullScreen.setChecked(false);
        this.actionFullScreen.setId("org.netxms.ui.eclipse.console.actions.full_screen");
        this.actionFullScreen.setActionDefinitionId("org.netxms.ui.eclipse.console.commands.full_screen");
        this.getActionBarConfigurer().registerGlobalAction((IAction)this.actionFullScreen);
        ConsoleSharedData.setProperty("FullScreenAction", this.actionFullScreen);
        Messages.get();
        this.actionExportPerspective = new Action(Messages.ApplicationActionBarAdvisor_ActionExportPerspective){

            public void run() {
                ApplicationActionBarAdvisor.this.exportPerspective(window);
            }
        };
        Messages.get();
        this.actionImportPerspective = new Action(Messages.ApplicationActionBarAdvisor_ActionImportPerspective){

            public void run() {
                ApplicationActionBarAdvisor.this.importPerspective(window);
            }
        };
        this.actionLangArabic = new Action("&Arabic", Activator.getImageDescriptor("icons/lang/ar.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("ar");
            }
        };
        this.actionLangChinese = new Action("C&hinese", Activator.getImageDescriptor("icons/lang/zh.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("zh");
            }
        };
        this.actionLangCzech = new Action("&Czech", Activator.getImageDescriptor("icons/lang/cs.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("cs");
            }
        };
        this.actionLangEnglish = new Action("&English", Activator.getImageDescriptor("icons/lang/gb.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("en");
            }
        };
        this.actionLangFrench = new Action("&French", Activator.getImageDescriptor("icons/lang/fr.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("fr");
            }
        };
        this.actionLangGerman = new Action("&German", Activator.getImageDescriptor("icons/lang/de.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("de");
            }
        };
        this.actionLangPortuguese = new Action("&Portuguese", Activator.getImageDescriptor("icons/lang/pt.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("pt");
            }
        };
        this.actionLangRussian = new Action("&Russian", Activator.getImageDescriptor("icons/lang/ru.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("ru");
            }
        };
        this.actionLangSpanish = new Action("&Spanish", Activator.getImageDescriptor("icons/lang/es.png")){

            public void run() {
                ApplicationActionBarAdvisor.this.setLanguage("es");
            }
        };
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        Messages.get();
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_File, "file");
        Messages.get();
        MenuManager viewMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_View, "view");
        Messages.get();
        MenuManager monitorMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Monitor, "monitor");
        Messages.get();
        MenuManager configMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Configuration, "config");
        Messages.get();
        MenuManager toolsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Tools, "tools");
        Messages.get();
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Window, "window");
        Messages.get();
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Help, "help");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)viewMenu);
        menuBar.add((IContributionItem)monitorMenu);
        menuBar.add((IContributionItem)configMenu);
        menuBar.add((IContributionItem)toolsMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        if (!Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WINDOW_MENU")) {
            menuBar.add((IContributionItem)windowMenu);
        }
        menuBar.add((IContributionItem)helpMenu);
        MenuManager langMenu = new MenuManager("&Language");
        langMenu.add((IAction)this.actionLangArabic);
        langMenu.add((IAction)this.actionLangChinese);
        langMenu.add((IAction)this.actionLangCzech);
        langMenu.add((IAction)this.actionLangEnglish);
        langMenu.add((IAction)this.actionLangFrench);
        langMenu.add((IAction)this.actionLangGerman);
        langMenu.add((IAction)this.actionLangPortuguese);
        langMenu.add((IAction)this.actionLangRussian);
        langMenu.add((IAction)this.actionLangSpanish);
        fileMenu.add((IAction)this.actionShowPreferences);
        fileMenu.add((IContributionItem)langMenu);
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.actionExit);
        viewMenu.add((IContributionItem)new GroupMarker("product"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("primary"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("logs"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.actionOpenProgressView);
        viewMenu.add((IContributionItem)new GroupMarker("tools"));
        monitorMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        Messages.get();
        MenuManager openPerspectiveMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_OpenPerspective, "openPerspective");
        openPerspectiveMenuMgr.add(this.contribItemOpenPerspective);
        windowMenu.add((IContributionItem)openPerspectiveMenuMgr);
        Messages.get();
        MenuManager showViewMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_ShowView, "showView");
        showViewMenuMgr.add(this.contribItemShowView);
        windowMenu.add((IContributionItem)showViewMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.actionCustomizePerspective);
        windowMenu.add((IAction)this.actionSavePerspective);
        windowMenu.add((IAction)this.actionResetPerspective);
        windowMenu.add((IAction)this.actionClosePerspective);
        windowMenu.add((IAction)this.actionCloseAllPerspectives);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.actionExportPerspective);
        windowMenu.add((IAction)this.actionImportPerspective);
        windowMenu.add((IContributionItem)new Separator());
        Messages.get();
        MenuManager navMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_Navigation, "navigate");
        windowMenu.add((IContributionItem)navMenu);
        navMenu.add((IAction)this.actionQuickAccess);
        navMenu.add((IAction)this.actionShowViewMenu);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionMaximize);
        navMenu.add((IAction)this.actionMinimize);
        navMenu.add((IAction)this.actionClose);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionNextView);
        navMenu.add((IAction)this.actionPrevView);
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IAction)(BrandingManager.getInstance().getAboutDialog(null) != null ? this.actionAboutCustom : this.actionAbout));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "product"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "view"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "logs"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "tools"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "config"));
        if (Activator.getDefault().getPreferenceStore().getBoolean("SHOW_SERVER_CLOCK")) {
            coolBar.add((IContributionItem)new ServerClockContributionItem());
        }
        ConsoleSharedData.setProperty("CoolBarManager", coolBar);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        Activator.getDefault().setStatusLine(statusLine);
        StatusLineContributionItem statusItem = new StatusLineContributionItem("ConnectionStatus", -1);
        statusItem.setText("");
        statusLine.add((IContributionItem)statusItem);
        statusLine.add((IContributionItem)new ServerNameStatusLineItem("ServerName"));
    }

    private void setLanguage(String locale) {
        block24: {
            Messages.get();
            Messages.get();
            if (!MessageDialogHelper.openConfirm(null, Messages.ApplicationActionBarAdvisor_ConfirmRestart, Messages.ApplicationActionBarAdvisor_RestartConsoleMessage)) {
                return;
            }
            Activator.getDefault().getPreferenceStore().setValue("NL", locale);
            Location configArea = Platform.getInstallLocation();
            if (configArea != null) {
                BufferedReader in = null;
                BufferedWriter out = null;
                try {
                    try {
                        String line;
                        URL iniFileUrl = new URL(String.valueOf(configArea.getURL().toExternalForm()) + "nxmc.ini");
                        String iniFileName = iniFileUrl.getFile();
                        File iniFile = new File(iniFileName);
                        File iniFileBackup = new File(String.valueOf(iniFileName) + ".bak");
                        iniFileBackup.delete();
                        iniFile.renameTo(iniFileBackup);
                        in = new BufferedReader(new FileReader(String.valueOf(iniFileName) + ".bak"));
                        out = new BufferedWriter(new FileWriter(iniFileName));
                        int state = 0;
                        while ((line = in.readLine()) != null) {
                            switch (state) {
                                case 0: {
                                    if (!line.equals("-nl")) break;
                                    state = 1;
                                    break;
                                }
                                case 1: {
                                    line = locale;
                                    state = 0;
                                }
                            }
                            out.write(line);
                            out.newLine();
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.netxms.ui.eclipse.console", 0, "Exception in setLanguage()", (Throwable)e));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException) {}
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        System.getProperties().setProperty("eclipse.exitdata", "-nl " + locale);
        PlatformUI.getWorkbench().restart();
    }

    private void exportPerspective(IWorkbenchWindow window) {
        try {
            SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(window.getShell(), window.getWorkbench().getPerspectiveRegistry());
            if (dlg.open() == 0) {
                WorkbenchPage page = (WorkbenchPage)window.getActivePage();
                Perspective p = page.findPerspective(dlg.getSelection());
                final XMLMemento memento = XMLMemento.createWriteRoot((String)"perspective");
                p.saveState((IMemento)memento);
                FileDialog fd = new FileDialog(window.getShell());
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String[] stringArray = new String[2];
                Messages.get();
                stringArray[0] = Messages.ApplicationActionBarAdvisor_XMLFiles;
                Messages.get();
                stringArray[1] = Messages.ApplicationActionBarAdvisor_AllFiles;
                fd.setFilterNames(stringArray);
                fd.setOverwrite(true);
                Messages.get();
                fd.setText(Messages.ApplicationActionBarAdvisor_ExportPerspective);
                final String fileName = fd.open();
                if (fileName != null) {
                    Messages.get();
                    new ConsoleJob(Messages.ApplicationActionBarAdvisor_ExportPerspective, null, "org.netxms.ui.eclipse.console", null){

                        @Override
                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            try (FileWriter writer = null;){
                                writer = new FileWriter(fileName);
                                memento.save((Writer)writer);
                            }
                        }

                        @Override
                        protected String getErrorMessage() {
                            Messages.get();
                            return Messages.ApplicationActionBarAdvisor_PerspectiveExportFailed;
                        }
                    }.start();
                }
            }
        }
        catch (Exception e) {
            Activator.logError("Exception in exportPerspective", e);
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError(shell, Messages.ApplicationActionBarAdvisor_Error, Messages.ApplicationActionBarAdvisor_PerspectiveExportFailed);
        }
    }

    private void importPerspective(final IWorkbenchWindow window) {
        FileDialog fd = new FileDialog(window.getShell());
        fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ApplicationActionBarAdvisor_XMLFiles;
        Messages.get();
        stringArray[1] = Messages.ApplicationActionBarAdvisor_AllFiles;
        fd.setFilterNames(stringArray);
        Messages.get();
        fd.setText(Messages.ApplicationActionBarAdvisor_ImportPerspective);
        final String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        Shell shell = window.getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm(shell, Messages.ApplicationActionBarAdvisor_ConfirmRestart, Messages.ApplicationActionBarAdvisor_RestartConfirmationMessage)) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.ApplicationActionBarAdvisor_ImportPerspective, null, "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try (FileReader reader = null;){
                    reader = new FileReader(fileName);
                    final XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Perspective p = ((WorkbenchImplementation)Tweaklets.get((Tweaklets.TweakKey)WorkbenchImplementation.KEY)).createPerspective(null, (WorkbenchPage)window.getActivePage());
                                p.restoreState((IMemento)memento);
                                PerspectiveRegistry reg = (PerspectiveRegistry)window.getWorkbench().getPerspectiveRegistry();
                                PerspectiveDescriptor pd = reg.createPerspective(p.getDesc().getLabel(), (PerspectiveDescriptor)p.getDesc());
                                WorkbenchPage page = (WorkbenchPage)window.getActivePage();
                                page.savePerspectiveAs((IPerspectiveDescriptor)pd);
                                p = page.findPerspective((IPerspectiveDescriptor)pd);
                                p.restoreState((IMemento)memento);
                                p.restoreState();
                                window.getWorkbench().showPerspective(pd.getId(), window);
                                page.savePerspective();
                                PlatformUI.getWorkbench().restart();
                            }
                            catch (Exception e) {
                                Activator.logError("Exception in importPerspective", e);
                                Shell shell = window.getShell();
                                Messages.get();
                                Messages.get();
                                MessageDialogHelper.openError(shell, Messages.ApplicationActionBarAdvisor_Error, Messages.ApplicationActionBarAdvisor_PerspectiveImportFailed);
                            }
                        }
                    });
                }
            }

            @Override
            protected String getErrorMessage() {
                Messages.get();
                return Messages.ApplicationActionBarAdvisor_PerspectiveImportFailed;
            }
        }.start();
    }
}

