/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.dialogs.SetEntryEditDialog;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.helpers.AttributeLabelProvider;

public class PersistentStorageView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.PersistentStorageView";
    private NXCSession session;
    private SortableTableViewer viewerSetValue;
    private Action actionRefresh;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Map<String, String> pStorageSet = new HashMap<String, String>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        String[] setColumnNames = new String[]{"Key", "Value"};
        int[] setColumnWidths = new int[]{150, 200};
        this.viewerSetValue = new SortableTableViewer(parent, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewerSetValue.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerSetValue.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.viewerSetValue.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewerSetValue.getLabelProvider()));
        this.viewerSetValue.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)PersistentStorageView.this.viewerSetValue.getSelection()).size();
                PersistentStorageView.this.actionEdit.setEnabled(size == 1);
                PersistentStorageView.this.actionDelete.setEnabled(size > 0);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PersistentStorageView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewerSetValue.getControl());
        this.viewerSetValue.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewerSetValue);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewerSetValue.getSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionEdit);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCreate);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PersistentStorageView.this.refresh();
            }
        };
        this.actionCreate = new Action("Create new", SharedIcons.ADD_OBJECT){

            public void run() {
                PersistentStorageView.this.createValue();
            }
        };
        this.actionCreate.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.new_task");
        handlerService.activateHandler(this.actionCreate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCreate));
        this.actionEdit = new Action("Set", SharedIcons.EDIT){

            public void run() {
                PersistentStorageView.this.editValue();
            }
        };
        this.actionEdit.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.edit_task");
        handlerService.activateHandler(this.actionEdit.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionEdit));
        this.actionDelete = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                PersistentStorageView.this.deleteValue();
            }
        };
    }

    private void refresh() {
        new ConsoleJob("Reloading scheduled task list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.pStorageSet = PersistentStorageView.this.session.getPersistentStorageList();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PersistentStorageView.this.viewerSetValue.setInput((Object)PersistentStorageView.this.pStorageSet.entrySet().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of scheduled tasks";
            }
        }.start();
    }

    private void createValue() {
        final SetEntryEditDialog dlg = new SetEntryEditDialog(this.getSite().getShell(), null, null, true, true);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Reloading scheduled task list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.session.setPersistentStorageValue(dlg.getAtributeName(), dlg.getAttributeValue());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PersistentStorageView.this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
                        PersistentStorageView.this.viewerSetValue.setInput((Object)PersistentStorageView.this.pStorageSet.entrySet().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of scheduled tasks";
            }
        }.start();
    }

    private void deleteValue() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewerSetValue.getSelection();
        new ConsoleJob("Reloading scheduled task list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Iterator it = selection.iterator();
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        final Map.Entry e = (Map.Entry)it.next();
                        PersistentStorageView.this.session.deletePersistentStorageValue((String)e.getKey());
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                PersistentStorageView.this.pStorageSet.remove(e.getKey());
                                PersistentStorageView.this.viewerSetValue.setInput((Object)PersistentStorageView.this.pStorageSet.entrySet().toArray());
                            }
                        });
                    }
                }
            }

            protected String getErrorMessage() {
                return "Cannot get list of scheduled tasks";
            }
        }.start();
    }

    private void editValue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerSetValue.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        final SetEntryEditDialog dlg = new SetEntryEditDialog(this.getSite().getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Reloading scheduled task list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.session.setPersistentStorageValue(dlg.getAtributeName(), dlg.getAttributeValue());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PersistentStorageView.this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
                        PersistentStorageView.this.viewerSetValue.setInput((Object)PersistentStorageView.this.pStorageSet.entrySet().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of scheduled tasks";
            }
        }.start();
    }

    public void setFocus() {
        this.viewerSetValue.getTable().setFocus();
    }
}

