/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ObjectStatusRadialWidget
extends Canvas
implements PaintListener {
    private AbstractObject object;
    private int maxLvl;
    private int leafObjectCount;
    private float leafObjectSize;
    private int diameter;
    private int centerX;
    private int centerY;
    private ColorCache cCache;
    private Set<Long> aceptedlist;
    private List<ObjLocation> objectMap = new ArrayList<ObjLocation>();

    public ObjectStatusRadialWidget(Composite parent, AbstractObject object, Set<Long> aceptedlist) {
        super(parent, 4);
        this.object = object;
        this.aceptedlist = aceptedlist;
        this.cCache = new ColorCache((Control)this);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addPaintListener(this);
    }

    private static boolean isContainerObject(AbstractObject object) {
        return object instanceof Container || object instanceof Cluster || object instanceof Rack || object instanceof Chassis;
    }

    private float drawParts(PaintEvent e, AbstractObject object, int lvl, float degree) {
        e.gc.setAlpha(255);
        float objectSize = 0.0f;
        AbstractObject[] abstractObjectArray = object.getChildsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                float currObjsize;
                AbstractObject obj;
                block14: {
                    block13: {
                        obj = abstractObjectArray[n2];
                        currObjsize = 0.0f;
                        if (!ObjectStatusRadialWidget.isContainerObject(obj)) break block13;
                        currObjsize = this.drawParts(e, obj, lvl + 1, degree);
                        if (currObjsize != 0.0f) break block14;
                        if (this.aceptedlist != null) break block15;
                        currObjsize = this.leafObjectSize;
                        break block14;
                    }
                    if (this.aceptedlist != null && !this.aceptedlist.contains(obj.getObjectId())) break block15;
                    currObjsize = this.leafObjectSize;
                }
                int compensation = Integer.signum(Math.round(degree + currObjsize) - (Math.round(degree) + Math.round(currObjsize)));
                e.gc.setBackground(this.getDisplay().getSystemColor(1));
                e.gc.fillArc(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6, Math.round(degree), Math.round(currObjsize) + compensation);
                e.gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                e.gc.fillArc(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl, Math.round(degree), Math.round(currObjsize) - 1 + compensation);
                this.objectMap.add(new ObjLocation(degree, degree + currObjsize, lvl, obj));
                Transform oldTransform = new Transform(e.gc.getDevice());
                e.gc.getTransform(oldTransform);
                String text = obj.getObjectName();
                Transform tr = new Transform((Device)this.getDisplay());
                tr.translate((float)this.centerX, (float)this.centerY);
                int h = e.gc.textExtent((String)text, (int)3).y;
                float rotate = 0.0f;
                float middle = degree + currObjsize / 2.0f;
                if (middle >= 90.0f && middle < 180.0f) {
                    rotate = 90.0f - (middle - 90.0f);
                }
                if (middle >= 270.0f && middle <= 360.0f) {
                    rotate = 90.0f - (middle - 270.0f);
                }
                if (middle >= 0.0f && middle < 90.0f) {
                    rotate = -middle;
                }
                if (middle >= 180.0f && middle < 270.0f) {
                    rotate = -(middle - 180.0f);
                }
                tr.rotate(rotate);
                e.gc.setTransform(tr);
                int l = e.gc.textExtent((String)text, (int)3).x;
                if (l > this.diameter / 2) {
                    String name = obj.getObjectName();
                    int nameL = e.gc.textExtent((String)name, (int)3).x;
                    if (nameL > this.diameter / 2) {
                        int numOfCharToLeave = this.diameter / 2 / (nameL / name.length());
                        name = name.subSequence(0, numOfCharToLeave - 4).toString();
                        name = String.valueOf(name) + "...";
                    }
                    text = name;
                }
                e.gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()), (ColorCache)this.cCache));
                if (middle >= 90.0f && middle <= 180.0f || middle > 180.0f && middle < 270.0f) {
                    e.gc.drawText(text, -(this.diameter * lvl) / 2 + 5, -h / 2, 3);
                } else {
                    e.gc.drawText(text, this.diameter * (lvl - 1) / 2 + 5, -h / 2, 3);
                }
                e.gc.setTransform(oldTransform);
                tr.dispose();
                oldTransform.dispose();
                degree += currObjsize;
                objectSize += currObjsize;
            }
            ++n2;
        }
        return objectSize;
    }

    private int calculateMaxLVLAndObjCount(AbstractObject object, int lvl) {
        AbstractObject[] objSet;
        int objcoutn = 0;
        int contFound = 0;
        AbstractObject[] abstractObjectArray = objSet = object.getChildsAsArray();
        int n = objSet.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject obj = abstractObjectArray[n2];
            if (this.aceptedlist != null) {
                if (ObjectStatusRadialWidget.isContainerObject(obj)) {
                    int tmp = this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                    if (tmp > 0) {
                        ++contFound;
                        objcoutn += tmp;
                    }
                } else if (this.aceptedlist.contains(obj.getObjectId())) {
                    ++objcoutn;
                }
            } else if (ObjectStatusRadialWidget.isContainerObject(obj)) {
                objcoutn += this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                ++contFound;
            } else {
                ++objcoutn;
            }
            ++n2;
        }
        if (this.aceptedlist == null && ObjectStatusRadialWidget.isContainerObject(object) && objcoutn == 0) {
            ++objcoutn;
        }
        if (contFound == 0 && this.maxLvl < lvl) {
            this.maxLvl = lvl;
        }
        return objcoutn;
    }

    public void paintControl(PaintEvent e) {
        e.gc.setAdvanced(true);
        if (!e.gc.getAdvanced()) {
            e.gc.drawText("Advanced graphics not supported", 30, 30, true);
            return;
        }
        this.objectMap.clear();
        this.leafObjectCount = this.calculateMaxLVLAndObjCount(this.object, 1);
        this.leafObjectSize = 360.0f / (float)this.leafObjectCount;
        Rectangle rect = this.getClientArea();
        --rect.width;
        --rect.height;
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        e.gc.setForeground(SharedColors.getColor((String)"Text.Normal", (Display)this.getDisplay()));
        e.gc.setLineWidth(1);
        int rectSide = Math.min(rect.width, rect.height);
        this.diameter = rectSide / (this.maxLvl + 1);
        this.centerX = rect.x + rectSide / 2;
        this.centerY = rect.y + rectSide / 2;
        this.drawParts(e, this.object, 2, 0.0f);
        e.gc.setBackground(this.getDisplay().getSystemColor(1));
        e.gc.setAlpha(255);
        e.gc.fillOval(this.centerX - this.diameter / 2 - 3, this.centerY - this.diameter / 2 - 3, this.diameter + 6, this.diameter + 6);
        e.gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        e.gc.setAlpha(255);
        e.gc.fillOval(this.centerX - this.diameter / 2, this.centerY - this.diameter / 2, this.diameter, this.diameter);
        String text = this.object instanceof AbstractNode ? String.valueOf(this.object.getObjectName()) + "\n" + ((AbstractNode)this.object).getPrimaryIP().getHostAddress() : this.object.getObjectName();
        e.gc.setClipping(rect);
        int h = e.gc.textExtent((String)text, (int)3).y;
        int l = e.gc.textExtent((String)text, (int)3).x;
        e.gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()), (ColorCache)this.cCache));
        e.gc.drawText(text, rect.x + rectSide / 2 - l / 2, rect.y + rectSide / 2 - h / 2, 3);
        this.objectMap.add(new ObjLocation(0.0f, 360.0f, 1, this.object));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.maxLvl == 0) {
            this.calculateMaxLVLAndObjCount(this.object, 1);
        }
        return new Point(240 * this.maxLvl, 240 * this.maxLvl);
    }

    public void updateObject(AbstractObject object, Set<Long> aceptedlist) {
        this.object = object;
        this.aceptedlist = aceptedlist;
        this.redraw();
    }

    public AbstractObject getObjectFromPoint(int x, int y) {
        AbstractObject object = null;
        int clickLvl = (int)(Math.sqrt(Math.pow(x - this.centerX, 2.0) + Math.pow(y - this.centerY, 2.0)) / (double)(this.diameter / 2) + 1.0);
        double clickDegree = Math.toDegrees(Math.atan2(this.centerX - x, this.centerY - y));
        if ((clickDegree += 90.0) < 0.0) {
            clickDegree += 360.0;
        }
        ObjLocation curr = new ObjLocation((float)clickDegree, (float)clickDegree, clickLvl, null);
        for (ObjLocation loc : this.objectMap) {
            if (!loc.equals(curr)) continue;
            object = loc.getObject();
            break;
        }
        return object;
    }

    class ObjLocation {
        float startDegree;
        float endDegree;
        int lvl;
        AbstractObject obj;

        public ObjLocation(float startDegree, float endDegree, int lvl, AbstractObject obj) {
            this.startDegree = startDegree;
            this.endDegree = endDegree;
            this.lvl = lvl;
            this.obj = obj;
        }

        public AbstractObject getObject() {
            return this.obj;
        }

        public boolean equals(Object arg0) {
            if (((ObjLocation)arg0).lvl != this.lvl) {
                return false;
            }
            return ((ObjLocation)arg0).startDegree >= this.startDegree && ((ObjLocation)arg0).endDegree <= this.endDegree;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.startDegree) + this.lvl;
        }
    }
}

