/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AbstractChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.BarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ComparisonChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.PieChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TubeChartConfig;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AbstractChart
extends PropertyPage {
    private AbstractChartConfig config;
    private LabeledText title;
    private Spinner timeRange;
    private Combo timeUnits;
    private LabeledSpinner refreshRate;
    private Combo legendPosition;
    private Button checkShowTitle;
    private Button checkShowLegend;
    private Button checkExtendedLegend;
    private Button checkShowGrid;
    private Button checkShowIn3D;
    private Button checkTranslucent;
    private Button checkTransposed;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkAreaChart;
    private Button checkInteractive;
    private LabeledSpinner lineWidth;
    private YAxisRangeEditor yAxisRange;

    protected Control createContents(Composite parent) {
        this.config = (AbstractChartConfig)this.getElement().getAdapter(AbstractChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.AbstractChart_Title);
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Messages.get();
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AbstractChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Left);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Right);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Top);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Bottom);
        this.legendPosition.select(this.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.AbstractChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = this.config instanceof LineChartConfig ? 3 : 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowTitle = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowTitle.setText(Messages.AbstractChart_ShowTitle);
        this.checkShowTitle.setSelection(this.config.isShowTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowTitle.setLayoutData((Object)gd);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.AbstractChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        if (this.config instanceof LineChartConfig) {
            this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkExtendedLegend.setText(Messages.AbstractChart_ExtendedLegend);
            this.checkExtendedLegend.setSelection(((LineChartConfig)this.config).isExtendedLegend());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkExtendedLegend.setLayoutData((Object)gd);
            this.checkLogScale = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkLogScale.setText(Messages.AbstractChart_LogartithmicScale);
            this.checkLogScale.setSelection(((LineChartConfig)this.config).isLogScaleEnabled());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkLogScale.setLayoutData((Object)gd);
            this.checkStacked = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkStacked.setText(Messages.AbstractChart_Stacked);
            this.checkStacked.setSelection(((LineChartConfig)this.config).isStacked());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkStacked.setLayoutData((Object)gd);
            this.checkAreaChart = new Button((Composite)optionsGroup, 32);
            this.checkAreaChart.setText("&Area chart");
            this.checkAreaChart.setSelection(((LineChartConfig)this.config).isArea());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkAreaChart.setLayoutData((Object)gd);
        }
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTranslucent.setText(Messages.AbstractChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        if (this.config instanceof ComparisonChartConfig) {
            this.checkShowIn3D = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkShowIn3D.setText(Messages.AbstractChart_3DView);
            this.checkShowIn3D.setSelection(((ComparisonChartConfig)this.config).isShowIn3D());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowIn3D.setLayoutData((Object)gd);
            if (this.config instanceof BarChartConfig || this.config instanceof TubeChartConfig) {
                this.checkTransposed = new Button((Composite)optionsGroup, 32);
                Messages.get();
                this.checkTransposed.setText(Messages.AbstractChart_Transposed);
                this.checkTransposed.setSelection(this.config instanceof BarChartConfig ? ((BarChartConfig)this.config).isTransposed() : ((TubeChartConfig)this.config).isTransposed());
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.checkTransposed.setLayoutData((Object)gd);
            }
        }
        if (this.config instanceof LineChartConfig) {
            this.checkShowGrid = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkShowGrid.setText(Messages.AbstractChart_ShowGrid);
            this.checkShowGrid.setSelection(((LineChartConfig)this.config).isShowGrid());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowGrid.setLayoutData((Object)gd);
            this.checkInteractive = new Button((Composite)optionsGroup, 32);
            this.checkInteractive.setText("&Interactive");
            this.checkInteractive.setSelection(((LineChartConfig)this.config).isInteractive());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkInteractive.setLayoutData((Object)gd);
            Composite timeRangeArea = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            timeRangeArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            timeRangeArea.setLayoutData((Object)gd);
            Messages.get();
            this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeRangeArea, (int)2048, (String)Messages.AbstractChart_TimeInterval, (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
            this.timeRange.setSelection(((LineChartConfig)this.config).getTimeRange());
            Messages.get();
            this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeRangeArea, (int)8, (String)Messages.AbstractChart_TimeUnits, (Object)"WidgetHelper::default_layout_data");
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Minutes);
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Hours);
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Days);
            this.timeUnits.select(((LineChartConfig)this.config).getTimeUnits());
        }
        Composite rateAndWidthArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = this.config instanceof LineChartConfig ? 2 : 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        layout.makeColumnsEqualWidth = true;
        rateAndWidthArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        rateAndWidthArea.setLayoutData((Object)gd);
        this.refreshRate = new LabeledSpinner(rateAndWidthArea, 0);
        Messages.get();
        this.refreshRate.setLabel(Messages.AbstractChart_RefreshInterval);
        this.refreshRate.setRange(1, 10000);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate.setLayoutData((Object)gd);
        if (this.config instanceof LineChartConfig) {
            this.lineWidth = new LabeledSpinner(rateAndWidthArea, 0);
            Messages.get();
            this.lineWidth.setLabel(Messages.AbstractChart_LineWidth);
            this.lineWidth.setRange(1, 32);
            this.lineWidth.setSelection(((LineChartConfig)this.config).getLineWidth());
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.lineWidth.setLayoutData((Object)gd);
        }
        if (!(this.config instanceof PieChartConfig)) {
            this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.yAxisRange.setLayoutData((Object)gd);
            this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.modifyYBase(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        return dialogArea;
    }

    private int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public boolean performOk() {
        this.config.setTitle(this.title.getText());
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setShowTitle(this.checkShowTitle.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        if (!(this.config instanceof PieChartConfig)) {
            this.config.setAutoScale(this.yAxisRange.isAuto());
            this.config.setMinYScaleValue(this.yAxisRange.getMinY());
            this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
            this.config.setModifyYBase(this.yAxisRange.modifyYBase());
        }
        if (this.config instanceof ComparisonChartConfig) {
            ((ComparisonChartConfig)this.config).setShowIn3D(this.checkShowIn3D.getSelection());
            if (this.config instanceof BarChartConfig) {
                ((BarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
            } else if (this.config instanceof TubeChartConfig) {
                ((TubeChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
            }
        }
        if (this.config instanceof LineChartConfig) {
            ((LineChartConfig)this.config).setTimeRange(this.timeRange.getSelection());
            ((LineChartConfig)this.config).setTimeUnits(this.timeUnits.getSelectionIndex());
            ((LineChartConfig)this.config).setShowGrid(this.checkShowGrid.getSelection());
            ((LineChartConfig)this.config).setExtendedLegend(this.checkExtendedLegend.getSelection());
            ((LineChartConfig)this.config).setLogScaleEnabled(this.checkLogScale.getSelection());
            ((LineChartConfig)this.config).setStacked(this.checkStacked.getSelection());
            ((LineChartConfig)this.config).setArea(this.checkAreaChart.getSelection());
            ((LineChartConfig)this.config).setInteractive(this.checkInteractive.getSelection());
            ((LineChartConfig)this.config).setLineWidth(this.lineWidth.getSelection());
        }
        return true;
    }
}

