/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.objecttabs.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class PerfTabGraph
extends DashboardComposite {
    private long nodeId;
    private List<PerfTabDci> items = new ArrayList<PerfTabDci>(4);
    private HistoricalDataChart chart;
    private ViewRefreshController refreshController = null;
    private boolean updateInProgress = false;
    private NXCSession session;
    private long timeInterval;
    private IViewPart viewPart;
    private VisibilityValidator validator;

    public PerfTabGraph(Composite parent, long nodeId, PerfTabDci dci, PerfTabGraphSettings settings, IViewPart viewPart, VisibilityValidator validator) {
        super(parent, 2048);
        this.nodeId = nodeId;
        this.viewPart = viewPart;
        this.validator = validator;
        this.items.add(dci);
        this.session = ConsoleSharedData.getSession();
        this.setLayout((Layout)new FillLayout());
        this.chart = ChartFactory.createLineChart((Composite)this, (int)0);
        this.chart.setZoomEnabled(false);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(settings.getRuntimeTitle());
        this.chart.setLegendVisible(settings.isShowLegendAlways());
        this.chart.setExtendedLegend(settings.isExtendedLegend());
        this.chart.setLogScaleEnabled(settings.isLogScaleEnabled());
        this.chart.setStacked(settings.isStacked());
        this.timeInterval = settings.getTimeRangeMillis();
        Date from = new Date(System.currentTimeMillis() - settings.getTimeRangeMillis());
        Date to = new Date(System.currentTimeMillis());
        this.chart.setTimeRange(from, to);
        GraphItemStyle style = new GraphItemStyle(settings.getType(), settings.getColorAsInt(), 2, settings.isInvertedValues() ? 8 : 0);
        this.chart.setItemStyles(Arrays.asList(style));
        if (!settings.isAutoScale()) {
            this.chart.setYAxisRange(settings.getMinYScaleValue(), settings.getMaxYScaleValue());
        }
        this.chart.addParameter(new GraphItem(nodeId, dci.getId(), 0, 0, "", settings.getRuntimeName(), "%s"));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PerfTabGraph.this.refreshController != null) {
                    PerfTabGraph.this.refreshController.dispose();
                }
            }
        });
        this.chart.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                PerfTabGraph.this.openHistoryGraph();
            }
        });
        this.chart.getPlotArea().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                PerfTabGraph.this.openHistoryGraph();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(PerfTabDci dci, PerfTabGraphSettings settings) {
        this.chart.setLegendVisible(true);
        if (settings.isExtendedLegend()) {
            this.chart.setExtendedLegend(true);
        }
        List<PerfTabDci> list = this.items;
        synchronized (list) {
            this.items.add(dci);
            GraphItemStyle style = new GraphItemStyle(settings.getType(), settings.getColorAsInt(), 2, settings.isInvertedValues() ? 8 : 0);
            ArrayList<GraphItemStyle> styles = new ArrayList<GraphItemStyle>(this.chart.getItemStyles());
            if (styles.size() < this.items.size()) {
                styles.add(style);
            } else {
                styles.set(this.items.size() - 1, style);
            }
            this.chart.setItemStyles(styles);
            this.chart.addParameter(new GraphItem(this.nodeId, dci.getId(), 0, 0, "", settings.getRuntimeName(), "%s"));
        }
    }

    public void start() {
        this.refreshController = new ViewRefreshController(this.viewPart, 30, new Runnable(){

            @Override
            public void run() {
                if (PerfTabGraph.this.isDisposed()) {
                    return;
                }
                PerfTabGraph.this.refreshData();
            }
        }, this.validator);
        if (this.validator.isVisible()) {
            this.refreshData();
        }
    }

    public void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        this.chart.clearErrors();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.PerfTabGraph_JobTitle, null, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){
            private PerfTabDci currentDci;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Date from = new Date(System.currentTimeMillis() - PerfTabGraph.this.timeInterval);
                final Date to = new Date(System.currentTimeMillis());
                List list = PerfTabGraph.this.items;
                synchronized (list) {
                    final DciData[] data = new DciData[PerfTabGraph.this.items.size()];
                    int i = 0;
                    while (i < data.length) {
                        this.currentDci = (PerfTabDci)PerfTabGraph.this.items.get(i);
                        data[i] = PerfTabGraph.this.session.getCollectedData(PerfTabGraph.this.nodeId, this.currentDci.getId(), from, to, 0);
                        ++i;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!((Widget)PerfTabGraph.this.chart).isDisposed()) {
                                PerfTabGraph.this.chart.setTimeRange(from, to);
                                int i = 0;
                                while (i < data.length) {
                                    PerfTabGraph.this.chart.updateParameter(i, data[i], true);
                                    ++i;
                                }
                            }
                            PerfTabGraph.this.updateInProgress = false;
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.PerfTabGraph_JobError, this.currentDci.getId(), this.currentDci.getDescription());
            }

            protected void jobFailureHandler() {
                PerfTabGraph.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PerfTabGraph.this.chart.addError(this.getErrorMessage());
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void openHistoryGraph() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.items.size()) {
            sb.append("&");
            sb.append(Integer.toString(1));
            sb.append("@");
            sb.append(this.nodeId);
            sb.append("@");
            sb.append(this.items.get(i).getId());
            sb.append("@");
            try {
                sb.append(URLEncoder.encode(this.items.get(i).getDescription(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                sb.append("<description unavailable>");
            }
            sb.append("@");
            sb.append("");
            sb.append("@");
            sb.append(((GraphItemStyle)this.chart.getItemStyles().get(i)).getFlags());
            sb.append("@");
            sb.append(((GraphItemStyle)this.chart.getItemStyles().get(i)).getType());
            sb.append("@");
            sb.append(((GraphItemStyle)this.chart.getItemStyles().get(i)).getColor());
            ++i;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", sb.toString(), 1);
        }
        catch (PartInitException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)("Could not open history graph view " + e.getLocalizedMessage()));
        }
    }
}

