/**
 * NetXMS - open source network management system
 * Copyright (C) 2003-2016 Victor Kirhenshtein
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.netxms.base;

/**
 * NXCP codes
 */
public class NXCPCodes
{
	// NXCP command codes
	public static final int CMD_LOGIN = 0x0001;
	public static final int CMD_LOGIN_RESP = 0x0002;
	public static final int CMD_KEEPALIVE = 0x0003;
	public static final int CMD_OPEN_HELPDESK_ISSUE = 0x0004;
	public static final int CMD_GET_OBJECTS = 0x0005;
	public static final int CMD_OBJECT = 0x0006;
	public static final int CMD_DELETE_OBJECT = 0x0007;
	public static final int CMD_MODIFY_OBJECT = 0x0008;
	public static final int CMD_OBJECT_LIST_END = 0x0009;
	public static final int CMD_OBJECT_UPDATE = 0x000A;
	//unused: public static final int CMD_GET_EVENTS = 0x000B;
	public static final int CMD_EVENTLOG_RECORDS = 0x000C;
	public static final int CMD_GET_CONFIG_VARLIST = 0x000D;
	public static final int CMD_SET_CONFIG_VARIABLE = 0x000E;
	public static final int CMD_GET_OBJECT_TOOLS = 0x000F;
	public static final int CMD_EXECUTE_ACTION = 0x0010;
	public static final int CMD_DELETE_CONFIG_VARIABLE = 0x0011;
	public static final int CMD_NOTIFY = 0x0012;
	public static final int CMD_TRAP = 0x0013;
	public static final int CMD_OPEN_EPP = 0x0014;
	public static final int CMD_CLOSE_EPP = 0x0015;
	public static final int CMD_SAVE_EPP = 0x0016;
	public static final int CMD_EPP_RECORD = 0x0017;
	public static final int CMD_EVENT_DB_UPDATE = 0x0018;
	public static final int CMD_TRAP_CFG_UPDATE = 0x0019;
	public static final int CMD_SET_EVENT_INFO = 0x001A;
	public static final int CMD_EVENT_DB_RECORD = 0x001B;
	public static final int CMD_LOAD_EVENT_DB = 0x001C;
	public static final int CMD_REQUEST_COMPLETED = 0x001D;
	public static final int CMD_LOAD_USER_DB = 0x001E;
	public static final int CMD_USER_DATA = 0x001F;
	public static final int CMD_GROUP_DATA = 0x0020;
	public static final int CMD_USER_DB_EOF = 0x0021;
	public static final int CMD_UPDATE_USER = 0x0022;
	public static final int CMD_DELETE_USER = 0x0023;
	public static final int CMD_CREATE_USER = 0x0024;
	public static final int CMD_LOCK_USER_DB = 0x0025;
	public static final int CMD_UNLOCK_USER_DB = 0x0026;
	public static final int CMD_USER_DB_UPDATE = 0x0027;
	public static final int CMD_SET_PASSWORD = 0x0028;
	public static final int CMD_GET_NODE_DCI_LIST = 0x0029;
	public static final int CMD_NODE_DCI = 0x002A;
	public static final int CMD_GET_LOG_DATA = 0x002B;
	public static final int CMD_DELETE_NODE_DCI = 0x002C;
	public static final int CMD_MODIFY_NODE_DCI = 0x002D;
	public static final int CMD_UNLOCK_NODE_DCI_LIST = 0x002E;
	public static final int CMD_SET_OBJECT_MGMT_STATUS = 0x002F;
	public static final int CMD_CREATE_NEW_DCI = 0x0030;
	public static final int CMD_GET_DCI_DATA = 0x0031;
	public static final int CMD_DCI_DATA = 0x0032;
	public static final int CMD_GET_MIB_TIMESTAMP = 0x0033;
	public static final int CMD_GET_MIB = 0x0034;
	public static final int CMD_TEST_DCI_TRANSFORMATION = 0x0035;
	public static final int CMD_GET_JOB_LIST = 0x0036;
	public static final int CMD_CREATE_OBJECT = 0x0037;
	public static final int CMD_GET_EVENT_NAMES = 0x0038;
	public static final int CMD_EVENT_NAME_LIST = 0x0039;
	public static final int CMD_BIND_OBJECT = 0x003A;
	public static final int CMD_UNBIND_OBJECT = 0x003B;
	public static final int CMD_UNINSTALL_AGENT_POLICY = 0x003C;
	public static final int CMD_OPEN_SERVER_LOG = 0x003D;
	public static final int CMD_CLOSE_SERVER_LOG = 0x003E;
	public static final int CMD_QUERY_LOG = 0x003F;
	public static final int CMD_AUTHENTICATE = 0x0040;
	public static final int CMD_GET_PARAMETER = 0x0041;
	public static final int CMD_GET_LIST = 0x0042;
	public static final int CMD_ACTION = 0x0043;
	public static final int CMD_GET_CURRENT_USER_ATTR = 0x0044;
	public static final int CMD_SET_CURRENT_USER_ATTR = 0x0045;
	public static final int CMD_GET_ALL_ALARMS = 0x0046;
	public static final int CMD_GET_ALARM_COMMENTS = 0x0047;
	public static final int CMD_ACK_ALARM = 0x0048;
	public static final int CMD_ALARM_UPDATE = 0x0049;
	public static final int CMD_ALARM_DATA = 0x004A;
	public static final int CMD_DELETE_ALARM = 0x004B;
	public static final int CMD_ADD_CLUSTER_NODE = 0x004C;
	public static final int CMD_GET_POLICY_INVENTORY = 0x004D;
	public static final int CMD_LOAD_ACTIONS = 0x004E;
	public static final int CMD_ACTION_DB_UPDATE = 0x004F;
	public static final int CMD_MODIFY_ACTION = 0x0050;
	public static final int CMD_CREATE_ACTION = 0x0051;
	public static final int CMD_DELETE_ACTION = 0x0052;
	public static final int CMD_ACTION_DATA = 0x0053;
	public static final int CMD_SETUP_AGENT_TUNNEL = 0x0054;
	public static final int CMD_EXECUTE_LIBRARY_SCRIPT = 0x0055;
	public static final int CMD_GET_PREDICTION_ENGINES = 0x0056;
	public static final int CMD_GET_PREDICTED_DATA = 0x0057;
	public static final int CMD_STOP_SERVER_COMMAND = 0x0058;
	public static final int CMD_POLL_NODE = 0x0059;
	public static final int CMD_POLLING_INFO = 0x005A;
	public static final int CMD_COPY_DCI = 0x005B;
	public static final int CMD_WAKEUP_NODE = 0x005C;
	public static final int CMD_DELETE_EVENT_TEMPLATE = 0x005D;
	public static final int CMD_GENERATE_EVENT_CODE = 0x005E;
	public static final int CMD_FIND_NODE_CONNECTION = 0x005F;
	public static final int CMD_FIND_MAC_LOCATION = 0x0060;
	public static final int CMD_CREATE_TRAP = 0x0061;
	public static final int CMD_MODIFY_TRAP = 0x0062;
	public static final int CMD_DELETE_TRAP = 0x0063;
	public static final int CMD_LOAD_TRAP_CFG = 0x0064;
	public static final int CMD_TRAP_CFG_RECORD = 0x0065;
	public static final int CMD_QUERY_PARAMETER = 0x0066;
	public static final int CMD_GET_SERVER_INFO = 0x0067;
	public static final int CMD_SET_DCI_STATUS = 0x0068;
	public static final int CMD_FILE_DATA = 0x0069;
	public static final int CMD_TRANSFER_FILE = 0x006A;
	public static final int CMD_UPGRADE_AGENT = 0x006B;
	public static final int CMD_GET_PACKAGE_LIST = 0x006C;
	public static final int CMD_PACKAGE_INFO = 0x006D;
	public static final int CMD_REMOVE_PACKAGE = 0x006E;
	public static final int CMD_INSTALL_PACKAGE = 0x006F;
	public static final int CMD_LOCK_PACKAGE_DB = 0x0070;
	public static final int CMD_UNLOCK_PACKAGE_DB = 0x0071;
	public static final int CMD_ABORT_FILE_TRANSFER = 0x0072;
	public static final int CMD_CHECK_NETWORK_SERVICE = 0x0073;
	public static final int CMD_GET_AGENT_CONFIG = 0x0074;
	public static final int CMD_UPDATE_AGENT_CONFIG = 0x0075;
	public static final int CMD_GET_PARAMETER_LIST = 0x0076;
	public static final int CMD_DEPLOY_PACKAGE = 0x0077;
	public static final int CMD_INSTALLER_INFO = 0x0078;
	public static final int CMD_GET_LAST_VALUES = 0x0079;
	public static final int CMD_APPLY_TEMPLATE = 0x007A;
	public static final int CMD_SET_USER_VARIABLE = 0x007B;
	public static final int CMD_GET_USER_VARIABLE = 0x007C;
	public static final int CMD_ENUM_USER_VARIABLES = 0x007D;
	public static final int CMD_DELETE_USER_VARIABLE = 0x007E;
	public static final int CMD_ADM_MESSAGE = 0x007F;
	public static final int CMD_ADM_REQUEST = 0x0080;
	public static final int CMD_GET_NETWORK_PATH = 0x0081;
	public static final int CMD_REQUEST_SESSION_KEY = 0x0082;
	public static final int CMD_ENCRYPTED_MESSAGE = 0x0083;
	public static final int CMD_SESSION_KEY = 0x0084;
	public static final int CMD_REQUEST_ENCRYPTION = 0x0085;
	public static final int CMD_GET_ROUTING_TABLE = 0x0086;
	public static final int CMD_EXEC_TABLE_TOOL = 0x0087;
	public static final int CMD_TABLE_DATA = 0x0088;
	public static final int CMD_CANCEL_JOB = 0x0089;
	public static final int CMD_CHANGE_SUBSCRIPTION = 0x008A;
	public static final int CMD_SET_CONFIG_TO_DEFAULT = 0x008B;
	public static final int CMD_SYSLOG_RECORDS = 0x008C;
	public static final int CMD_JOB_CHANGE_NOTIFICATION = 0x008D;
	public static final int CMD_DEPLOY_AGENT_POLICY = 0x008E;
	public static final int CMD_LOG_DATA = 0x008F;
	public static final int CMD_GET_OBJECT_TOOL_DETAILS = 0x0090;
	public static final int CMD_EXECUTE_SERVER_COMMAND = 0x0091;
	public static final int CMD_UPLOAD_FILE_TO_AGENT = 0x0092;
	public static final int CMD_UPDATE_OBJECT_TOOL = 0x0093;
	public static final int CMD_DELETE_OBJECT_TOOL = 0x0094;
	public static final int CMD_SETUP_PROXY_CONNECTION = 0x0095;
	public static final int CMD_GENERATE_OBJECT_TOOL_ID = 0x0096;
	public static final int CMD_GET_SERVER_STATS = 0x0097;
	public static final int CMD_GET_SCRIPT_LIST = 0x0098;
	public static final int CMD_GET_SCRIPT = 0x0099;
	public static final int CMD_UPDATE_SCRIPT = 0x009A;
	public static final int CMD_DELETE_SCRIPT = 0x009B;
	public static final int CMD_RENAME_SCRIPT = 0x009C;
	public static final int CMD_GET_SESSION_LIST = 0x009D;
	public static final int CMD_KILL_SESSION = 0x009E;
	public static final int CMD_SET_DB_PASSWORD = 0x009F;
	public static final int CMD_TRAP_LOG_RECORDS = 0x00A0;
	public static final int CMD_START_SNMP_WALK = 0x00A1;
	public static final int CMD_SNMP_WALK_DATA = 0x00A2;
	public static final int CMD_GET_MAP_LIST = 0x00A3;
	public static final int CMD_LOAD_MAP = 0x00A4;
	public static final int CMD_SAVE_MAP = 0x00A5;
	public static final int CMD_DELETE_MAP = 0x00A6;
	public static final int CMD_RESOLVE_MAP_NAME = 0x00A7;
	public static final int CMD_SUBMAP_DATA = 0x00A8;
	public static final int CMD_UPLOAD_SUBMAP_BK_IMAGE = 0x00A9;
	public static final int CMD_GET_SUBMAP_BK_IMAGE = 0x00AA;
	public static final int CMD_GET_MODULE_LIST = 0x00AB;
	public static final int CMD_UPDATE_MODULE_INFO = 0x00AC;
	public static final int CMD_COPY_USER_VARIABLE = 0x00AD;
	public static final int CMD_RESOLVE_DCI_NAMES = 0x00AE;
	public static final int CMD_GET_MY_CONFIG = 0x00AF;
	public static final int CMD_GET_AGENT_CFG_LIST = 0x00B0;
	public static final int CMD_OPEN_AGENT_CONFIG = 0x00B1;
	public static final int CMD_SAVE_AGENT_CONFIG = 0x00B2;
	public static final int CMD_DELETE_AGENT_CONFIG = 0x00B3;
	public static final int CMD_SWAP_AGENT_CONFIGS = 0x00B4;
	public static final int CMD_TERMINATE_ALARM = 0x00B5;
	public static final int CMD_GET_NXCP_CAPS = 0x00B6;
	public static final int CMD_NXCP_CAPS = 0x00B7;
	public static final int CMD_GET_OBJECT_COMMENTS = 0x00B8;
	public static final int CMD_UPDATE_OBJECT_COMMENTS = 0x00B9;
	public static final int CMD_ENABLE_AGENT_TRAPS = 0x00BA;
	public static final int CMD_PUSH_DCI_DATA = 0x00BB;
	public static final int CMD_GET_ADDR_LIST = 0x00BC;
	public static final int CMD_SET_ADDR_LIST = 0x00BD;
	public static final int CMD_RESET_COMPONENT = 0x00BE;
	public static final int CMD_GET_DCI_EVENTS_LIST = 0x00BF;
	public static final int CMD_EXPORT_CONFIGURATION = 0x00C0;
	public static final int CMD_IMPORT_CONFIGURATION = 0x00C1;
	public static final int CMD_GET_TRAP_CFG_RO = 0x00C2;
	public static final int CMD_SNMP_REQUEST = 0x00C3;
	public static final int CMD_GET_DCI_INFO = 0x00C4;
	public static final int CMD_GET_GRAPH_LIST = 0x00C5;
	public static final int CMD_SAVE_GRAPH = 0x00C6;
	public static final int CMD_DELETE_GRAPH = 0x00C7;
	public static final int CMD_GET_PERFTAB_DCI_LIST = 0x00C8;
	public static final int CMD_ADD_CA_CERTIFICATE = 0x00C9;
	public static final int CMD_DELETE_CERTIFICATE = 0x00CA;
	public static final int CMD_GET_CERT_LIST = 0x00CB;
	public static final int CMD_UPDATE_CERT_COMMENTS = 0x00CC;
	public static final int CMD_QUERY_L2_TOPOLOGY = 0x00CD;
	public static final int CMD_AUDIT_RECORD = 0x00CE;
	public static final int CMD_GET_AUDIT_LOG = 0x00CF;
	public static final int CMD_SEND_SMS = 0x00D0;
	public static final int CMD_GET_COMMUNITY_LIST = 0x00D1;
	public static final int CMD_UPDATE_COMMUNITY_LIST = 0x00D2;
	public static final int CMD_GET_PERSISTENT_STORAGE = 0x00D3;
	public static final int CMD_DELETE_PSTORAGE_VALUE = 0x00D4;
	public static final int CMD_SET_PSTORAGE_VALUE = 0x00D5;
	public static final int CMD_GET_AGENT_TUNNELS = 0x00D6;
	public static final int CMD_BIND_AGENT_TUNNEL = 0x00D7;
	public static final int CMD_REQUEST_CERTIFICATE = 0x00D8;
	public static final int CMD_NEW_CERTIFICATE = 0x00D9;
	public static final int CMD_CREATE_MAP = 0x00DA;
	public static final int CMD_UPLOAD_FILE = 0x00DB;
	public static final int CMD_DELETE_FILE = 0x00DC;
	public static final int CMD_CONFIG_SET_CLOB = 0x00E1;
	public static final int CMD_CONFIG_GET_CLOB = 0x00E2;
	public static final int CMD_RENAME_MAP = 0x00E3;
	public static final int CMD_CLEAR_DCI_DATA = 0x00E4;
	public static final int CMD_GET_LICENSE = 0x00E5;
	public static final int CMD_CHECK_LICENSE = 0x00E6;
	public static final int CMD_RELEASE_LICENSE = 0x00E7;
	public static final int CMD_ISC_CONNECT_TO_SERVICE = 0x00E8;
	public static final int CMD_REGISTER_AGENT = 0x00E9;
	public static final int CMD_GET_SERVER_FILE = 0x00EA;
	public static final int CMD_FORWARD_EVENT = 0x00EB;
	public static final int CMD_GET_USM_CREDENTIALS = 0x00EC;
	public static final int CMD_UPDATE_USM_CREDENTIALS = 0x00ED;
	public static final int CMD_GET_DCI_THRESHOLDS = 0x00EE;
	public static final int CMD_GET_IMAGE = 0x00EF;
	public static final int CMD_CREATE_IMAGE = 0x00F0;
	public static final int CMD_DELETE_IMAGE = 0x00F1;
	public static final int CMD_MODIFY_IMAGE = 0x00F2;
	public static final int CMD_LIST_IMAGES = 0x00F3;
	public static final int CMD_LIST_SERVER_FILES = 0x00F4;
	public static final int CMD_GET_TABLE = 0x00F5;
	public static final int CMD_QUERY_TABLE = 0x00F6;
	public static final int CMD_OPEN_CONSOLE = 0x00F7;
	public static final int CMD_CLOSE_CONSOLE = 0x00F8;
	public static final int CMD_GET_SELECTED_OBJECTS = 0x00F9;
	public static final int CMD_GET_VLANS = 0x00FA;
	public static final int CMD_HOLD_JOB = 0x00FB;
	public static final int CMD_UNHOLD_JOB = 0x00FC;
	public static final int CMD_CHANGE_ZONE = 0x00FD;
	public static final int CMD_GET_AGENT_FILE = 0x00FE;
	public static final int CMD_GET_FILE_DETAILS = 0x00FF;
	public static final int CMD_IMAGE_LIBRARY_UPDATE = 0x0100;
	public static final int CMD_GET_NODE_COMPONENTS = 0x0101;
	public static final int CMD_UPDATE_ALARM_COMMENT = 0x0102;
	public static final int CMD_GET_ALARM = 0x0103;
	public static final int CMD_GET_TABLE_LAST_VALUES = 0x0104;
	public static final int CMD_GET_TABLE_DCI_DATA = 0x0105;
	public static final int CMD_GET_THRESHOLD_SUMMARY = 0x0106;
	public static final int CMD_RESOLVE_ALARM = 0x0107;
	public static final int CMD_FIND_IP_LOCATION = 0x0108;
	public static final int CMD_REPORT_DEVICE_STATUS = 0x0109;
	public static final int CMD_REPORT_DEVICE_INFO = 0x010A;
	public static final int CMD_GET_ALARM_EVENTS = 0x010B;
	public static final int CMD_GET_ENUM_LIST = 0x010C;
	public static final int CMD_GET_TABLE_LIST = 0x010D;
	public static final int CMD_GET_MAPPING_TABLE = 0x010E;
	public static final int CMD_UPDATE_MAPPING_TABLE = 0x010F;
	public static final int CMD_DELETE_MAPPING_TABLE = 0x0110;
	public static final int CMD_LIST_MAPPING_TABLES = 0x0111;
	public static final int CMD_GET_NODE_SOFTWARE = 0x0112;
	public static final int CMD_GET_WINPERF_OBJECTS = 0x0113;
	public static final int CMD_GET_WIRELESS_STATIONS = 0x0114;
	public static final int CMD_GET_SUMMARY_TABLES = 0x0115;
	public static final int CMD_MODIFY_SUMMARY_TABLE = 0x0116;
	public static final int CMD_DELETE_SUMMARY_TABLE = 0x0117;
	public static final int CMD_GET_SUMMARY_TABLE_DETAILS = 0x0118;
	public static final int CMD_QUERY_SUMMARY_TABLE = 0x0119;
	public static final int CMD_SHUTDOWN = 0x011A;
	public static final int CMD_SNMP_TRAP = 0x011B;
	public static final int CMD_GET_SUBNET_ADDRESS_MAP = 0x011C;
	public static final int CMD_FILE_MONITORING = 0x011D;
	public static final int CMD_CANCEL_FILE_MONITORING = 0x011E;
	public static final int CMD_CHANGE_OBJECT_TOOL_STATUS = 0x011F;
	public static final int CMD_SET_ALARM_STATUS_FLOW = 0x0120;
	public static final int CMD_DELETE_ALARM_COMMENT = 0x0121;
	public static final int CMD_GET_EFFECTIVE_RIGHTS = 0x0122;
	public static final int CMD_GET_DCI_VALUES = 0x0123;
	public static final int CMD_GET_HELPDESK_URL = 0x0124;
	public static final int CMD_UNLINK_HELPDESK_ISSUE = 0x0125;
	public static final int CMD_GET_FOLDER_CONTENT = 0x0126;
   public static final int CMD_FILEMGR_DELETE_FILE = 0x0127;
   public static final int CMD_FILEMGR_RENAME_FILE = 0x0128;
   public static final int CMD_FILEMGR_MOVE_FILE = 0x0129;
   public static final int CMD_FILEMGR_UPLOAD = 0x012A;
   public static final int CMD_GET_SWITCH_FDB = 0x012B;
   public static final int CMD_COMMAND_OUTPUT = 0x012C;
   public static final int CMD_GET_LOC_HISTORY = 0x012D;
   public static final int CMD_TAKE_SCREENSHOT = 0x012E;
   public static final int CMD_EXECUTE_SCRIPT = 0x012F;
   public static final int CMD_EXECUTE_SCRIPT_UPDATE = 0x0130;
   public static final int CMD_FILEMGR_CREATE_FOLDER = 0x0131;
   public static final int CMD_QUERY_ADHOC_SUMMARY_TABLE = 0x0132;
   public static final int CMD_GRAPH_UPDATE = 0x0133;
   public static final int CMD_ENABLE_IPV6 = 0x0134;
   public static final int CMD_FORCE_DCI_POLL = 0x0135;
   public static final int CMD_GET_DCI_SCRIPT_LIST = 0x0136;
   public static final int CMD_DATA_COLLECTION_CONFIG = 0x0137;
   public static final int CMD_SET_SERVER_ID = 0x0138;
   public static final int CMD_GET_PUBLIC_CONFIG_VAR = 0x0139;
   public static final int CMD_ENABLE_FILE_UPDATES = 0x013A;
   public static final int CMD_DETACH_LDAP_USER = 0x013B;
   public static final int CMD_VALIDATE_PASSWORD = 0x013C;
   public static final int CMD_COMPILE_SCRIPT = 0x013D;
   public static final int CMD_CLEAN_AGENT_DCI_CONF = 0x013E;
   public static final int CMD_RESYNC_AGENT_DCI_CONF = 0x013F;
   public static final int CMD_LIST_SCHEDULE_CALLBACKS = 0x0140;
   public static final int CMD_LIST_SCHEDULES = 0x0141;
   public static final int CMD_ADD_SCHEDULE = 0x0142;
   public static final int CMD_UPDATE_SCHEDULE = 0x0143;
   public static final int CMD_REMOVE_SCHEDULE = 0x0144;
   public static final int CMD_ENTER_MAINT_MODE = 0x0145;
   public static final int CMD_LEAVE_MAINT_MODE = 0x0146;   
   public static final int CMD_JOIN_CLUSTER = 0x0147;   
   public static final int CMD_CLUSTER_NOTIFY = 0x0148;   
   public static final int CMD_ZMQ_SUBSCRIBE_EVENT = 0x0149;
   public static final int CMD_ZMQ_UNSUBSCRIBE_EVENT = 0x014A;
   public static final int CMD_ZMQ_SUBSCRIBE_DATA = 0x014B;
   public static final int CMD_ZMQ_UNSUBSCRIBE_DATA = 0x014C;
   public static final int CMD_ZMQ_GET_EVT_SUBSCRIPTIONS = 0x014D;
   public static final int CMD_ZMQ_GET_DATA_SUBSCRIPTIONS = 0x014E;
   public static final int CMD_GET_REPOSITORIES = 0x014F;
   public static final int CMD_ADD_REPOSITORY = 0x0150;
   public static final int CMD_MODIFY_REPOSITORY = 0x0151;
   public static final int CMD_DELETE_REPOSITORY = 0x0152;
   public static final int CMD_GET_ALARM_CATEGORIES = 0x0153;
   public static final int CMD_MODIFY_ALARM_CATEGORY = 0x0154;
   public static final int CMD_DELETE_ALARM_CATEGORY = 0x0155;
   public static final int CMD_ALARM_CATEGORY_UPDATE = 0x0156;
   public static final int CMD_BULK_TERMINATE_ALARMS = 0x0157;
   public static final int CMD_BULK_RESOLVE_ALARMS = 0x0158;
   public static final int CMD_BULK_ALARM_STATE_CHANGE = 0x0159;
   public static final int CMD_GET_FOLDER_SIZE = 0x015A;
   public static final int CMD_FIND_HOSTNAME_LOCATION = 0x015B;
   public static final int CMD_RESET_TUNNEL = 0x015C;
   public static final int CMD_CREATE_SESSION = 0x015D;
   public static final int CMD_CHANNEL_DATA = 0x015E;
   public static final int CMD_CLOSE_CHANNEL = 0x015F;
   public static final int CMD_CREATE_OBJECT_ACCESS_SNAPSHOT = 0x0160;
   public static final int CMD_UNBIND_AGENT_TUNNEL = 0x0161;
   public static final int CMD_EXPAND_MACROS = 0x0165;
   public static final int CMD_EXECUTE_ACTION_WITH_EXPANSION = 0x0166;
   public static final int CMD_HOST_BY_IP = 0x0167;
   public static final int CMD_CANCEL_FILE_DOWNLOAD = 0x0168;
   public static final int CMD_FILEMGR_COPY_FILE = 0x0169;
   public static final int CMD_DELETE_DCI_ENTRY = 0x0170;

	// CMD_RS_ - Reporting Server related codes
	public static final int CMD_RS_LIST_REPORTS = 0x1100;
	public static final int CMD_RS_GET_REPORT_DEFINITION = 0x1101;
	public static final int CMD_RS_SCHEDULE_EXECUTION = 0x1102;
	public static final int CMD_RS_LIST_RESULTS = 0x1103;
	public static final int CMD_RS_RENDER_RESULT = 0x1104;
	public static final int CMD_RS_DELETE_RESULT = 0x1105;
	public static final int CMD_RS_LIST_SCHEDULES = 0x1106;
	public static final int CMD_RS_DELETE_SCHEDULE = 0x1107;
	public static final int CMD_RS_NOTIFY = 0x1108;
	public static final int CMD_RS_ADD_REPORT_NOTIFY = 0x1109;
	public static final int CMD_RS_SEND_MAIL_NOTIFY = 0x1110;

	// Variable codes
	public static final long VID_LOGIN_NAME = 1;
	public static final long VID_PASSWORD = 2;
	public static final long VID_OBJECT_ID = 3;
	public static final long VID_OBJECT_NAME = 4;
	public static final long VID_OBJECT_CLASS = 5;
	public static final long VID_SNMP_VERSION = 6;
	public static final long VID_PARENT_CNT = 7;
	public static final long VID_IP_ADDRESS = 8;
	public static final long VID_IP_NETMASK = 9;
	public static final long VID_OBJECT_STATUS = 10;
	public static final long VID_IF_INDEX = 11;
	public static final long VID_IF_TYPE = 12;
	public static final long VID_FLAGS = 13;
	public static final long VID_CREATION_FLAGS = 14;
	public static final long VID_AGENT_PORT = 15;
	public static final long VID_AUTH_METHOD = 16;
	public static final long VID_SHARED_SECRET = 17;
	public static final long VID_SNMP_AUTH_OBJECT = 18;
	public static final long VID_SNMP_OID = 19;
	public static final long VID_NAME = 20;
	public static final long VID_VALUE = 21;
	public static final long VID_PEER_GATEWAY = 22;
	public static final long VID_NOTIFICATION_CODE = 23;
	public static final long VID_EVENT_CODE = 24;
	public static final long VID_SEVERITY = 25;
	public static final long VID_MESSAGE = 26;
	public static final long VID_DESCRIPTION = 27;
	public static final long VID_RCC = 28; /* RCC == Request Completion Code */
	public static final long VID_LOCKED_BY = 29;
	public static final long VID_IS_DELETED = 30;
	public static final long VID_CHILD_CNT = 31;
	public static final long VID_ACL_SIZE = 32;
	public static final long VID_INHERIT_RIGHTS = 33;
	public static final long VID_USER_NAME = 34;
	public static final long VID_USER_ID = 35;
	public static final long VID_USER_SYS_RIGHTS = 36;
	public static final long VID_USER_FLAGS = 37;
	public static final long VID_NUM_MEMBERS = 38; /* Number of members in users group */
	public static final long VID_IS_GROUP = 39;
	public static final long VID_USER_FULL_NAME = 40;
	public static final long VID_USER_DESCRIPTION = 41;
	public static final long VID_UPDATE_TYPE = 42;
	public static final long VID_DCI_ID = 43;
	public static final long VID_POLLING_INTERVAL = 44;
	public static final long VID_RETENTION_TIME = 45;
	public static final long VID_DCI_SOURCE_TYPE = 46;
	public static final long VID_DCI_DATA_TYPE = 47;
	public static final long VID_DCI_STATUS = 48;
	public static final long VID_MGMT_STATUS = 49;
	public static final long VID_MAX_ROWS = 50;
	public static final long VID_TIME_FROM = 51;
	public static final long VID_TIME_TO = 52;
	public static final long VID_DCI_DATA = 53;
	public static final long VID_NUM_THRESHOLDS = 54;
	public static final long VID_DCI_NUM_MAPS = 55;
	public static final long VID_DCI_MAP_IDS = 56;
	public static final long VID_DCI_MAP_INDEXES = 57;
	public static final long VID_NUM_MIBS = 58;
	public static final long VID_MIB_NAME = 59;
	public static final long VID_MIB_FILE_SIZE = 60;
	public static final long VID_MIB_FILE = 61;
	public static final long VID_PROPERTIES = 62;
	public static final long VID_ALARM_SEVERITY = 63;
	public static final long VID_ALARM_KEY = 64;
	public static final long VID_ALARM_TIMEOUT = 65;
	public static final long VID_ALARM_MESSAGE = 66;
	public static final long VID_RULE_ID = 67;
	public static final long VID_NUM_SOURCES = 68;
	public static final long VID_NUM_EVENTS = 69;
	public static final long VID_NUM_ACTIONS = 70;
	public static final long VID_RULE_SOURCES = 71;
	public static final long VID_RULE_EVENTS = 72;
	public static final long VID_RULE_ACTIONS = 73;
	public static final long VID_NUM_RULES = 74;
	public static final long VID_CATEGORY = 75;
	public static final long VID_UPDATED_CHILD_LIST = 76;
	public static final long VID_EVENT_NAME_TABLE = 77;
	public static final long VID_PARENT_ID = 78;
	public static final long VID_CHILD_ID = 79;
	public static final long VID_SNMP_PORT = 80;
	public static final long VID_CONFIG_FILE_DATA = 81;
	public static final long VID_COMMENTS = 82;
	public static final long VID_POLICY_ID = 83;
	public static final long VID_SNMP_USM_METHODS = 84;
	public static final long VID_PARAMETER = 85;
	public static final long VID_NUM_STRINGS = 86;
	public static final long VID_ACTION_NAME = 87;
	public static final long VID_NUM_ARGS = 88;
	public static final long VID_SNMP_AUTH_PASSWORD = 89;
	public static final long VID_CLASS_ID_LIST = 90;
	public static final long VID_SNMP_PRIV_PASSWORD = 91;
	public static final long VID_NOTIFICATION_DATA = 92;
	public static final long VID_ALARM_ID = 93;
	public static final long VID_TIMESTAMP = 94;
	public static final long VID_ACK_BY_USER = 95;
	public static final long VID_IS_ACK = 96;
	public static final long VID_ACTION_ID = 97;
	public static final long VID_IS_DISABLED = 98;
	public static final long VID_ACTION_TYPE = 99;
	public static final long VID_ACTION_DATA = 100;
	public static final long VID_EMAIL_SUBJECT = 101;
	public static final long VID_RCPT_ADDR = 102;
	public static final long VID_NPE_NAME = 103;
	public static final long VID_CATEGORY_ID = 104;
	public static final long VID_DCI_DELTA_CALCULATION = 105;
	public static final long VID_TRANSFORMATION_SCRIPT = 106;
	public static final long VID_POLL_TYPE = 107;
	public static final long VID_POLLER_MESSAGE = 108;
	public static final long VID_SOURCE_OBJECT_ID = 109;
	public static final long VID_DESTINATION_OBJECT_ID = 110;
	public static final long VID_NUM_ITEMS = 111;
	public static final long VID_ITEM_LIST = 112;
	public static final long VID_MAC_ADDR = 113;
	public static final long VID_TEMPLATE_VERSION = 114;
	public static final long VID_NODE_TYPE = 115;
	public static final long VID_INSTANCE = 116;
	public static final long VID_TRAP_ID = 117;
	public static final long VID_TRAP_OID = 118;
	public static final long VID_TRAP_OID_LEN = 119;
	public static final long VID_TRAP_NUM_MAPS = 120;
	public static final long VID_SERVER_VERSION = 121;
	public static final long VID_SUPPORTED_ENCRYPTION = 122;
	public static final long VID_EVENT_ID = 123;
	public static final long VID_AGENT_VERSION = 124;
	public static final long VID_FILE_NAME = 125;
	public static final long VID_PACKAGE_ID = 126;
	public static final long VID_PACKAGE_VERSION = 127;
	public static final long VID_PLATFORM_NAME = 128;
	public static final long VID_PACKAGE_NAME = 129;
	public static final long VID_SERVICE_TYPE = 130;
	public static final long VID_IP_PROTO = 131;
	public static final long VID_IP_PORT = 132;
	public static final long VID_SERVICE_REQUEST = 133;
	public static final long VID_SERVICE_RESPONSE = 134;
	public static final long VID_POLLER_NODE_ID = 135;
	public static final long VID_SERVICE_STATUS = 136;
	public static final long VID_NUM_PARAMETERS = 137;
	public static final long VID_NUM_OBJECTS = 138;
	public static final long VID_OBJECT_LIST = 139;
	public static final long VID_DEPLOYMENT_STATUS = 140;
	public static final long VID_ERROR_MESSAGE = 141;
	public static final long VID_SERVER_ID = 142;
	public static final long VID_SEARCH_PATTERN = 143;
	public static final long VID_NUM_VARIABLES = 144;
	public static final long VID_COMMAND = 145;
	public static final long VID_PROTOCOL_VERSION = 146;
	public static final long VID_ZONE_UIN = 147;
	public static final long VID_ZONING_ENABLED = 148;
	public static final long VID_ICMP_PROXY = 149;
	public static final long VID_IP_ADDRESS_COUNT = 150;
	public static final long VID_REMOVE_DCI = 152;
	public static final long VID_TEMPLATE_ID = 153;
	public static final long VID_PUBLIC_KEY = 154;
	public static final long VID_SESSION_KEY = 155;
	public static final long VID_CIPHER = 156;
	public static final long VID_KEY_LENGTH = 157;
	public static final long VID_SESSION_IV = 158;
	public static final long VID_CONFIG_FILE = 159;
	public static final long VID_STATUS_CALCULATION_ALG = 160;
	public static final long VID_NUM_LOCAL_NETS = 161;
	public static final long VID_NUM_REMOTE_NETS = 162;
	public static final long VID_APPLY_FLAG = 163;
	public static final long VID_NUM_TOOLS = 164;
	public static final long VID_TOOL_ID = 165;
	public static final long VID_NUM_COLUMNS = 166;
	public static final long VID_NUM_ROWS = 167;
	public static final long VID_TABLE_TITLE = 168;
	public static final long VID_EVENT_NAME = 169;
	public static final long VID_CLIENT_TYPE = 170;
	public static final long VID_LOG_NAME = 171;
	public static final long VID_OPERATION = 172;
	public static final long VID_MAX_RECORDS = 173;
	public static final long VID_NUM_RECORDS = 174;
	public static final long VID_CLIENT_INFO = 175;
	public static final long VID_OS_INFO = 176;
	public static final long VID_LIBNXCL_VERSION = 177;
	public static final long VID_VERSION = 178;
	public static final long VID_NUM_NODES = 179;
	public static final long VID_LOG_FILE = 180;
	public static final long VID_HOP_COUNT = 181;
	public static final long VID_NUM_SCHEDULES = 182;
	public static final long VID_STATUS_PROPAGATION_ALG = 183;
	public static final long VID_FIXED_STATUS = 184;
	public static final long VID_STATUS_SHIFT = 185;
	public static final long VID_STATUS_TRANSLATION_1 = 186;
	public static final long VID_STATUS_TRANSLATION_2 = 187;
	public static final long VID_STATUS_TRANSLATION_3 = 188;
	public static final long VID_STATUS_TRANSLATION_4 = 189;
	public static final long VID_STATUS_SINGLE_THRESHOLD = 190;
	public static final long VID_STATUS_THRESHOLD_1 = 191;
	public static final long VID_STATUS_THRESHOLD_2 = 192;
	public static final long VID_STATUS_THRESHOLD_3 = 193;
	public static final long VID_STATUS_THRESHOLD_4 = 194;
	public static final long VID_AGENT_PROXY = 195;
	public static final long VID_TOOL_TYPE = 196;
	public static final long VID_TOOL_DATA = 197;
	public static final long VID_ACL = 198;
	public static final long VID_TOOL_FILTER = 199;
	public static final long VID_SERVER_UPTIME = 200;
	public static final long VID_NUM_ALARMS = 201;
	public static final long VID_ALARMS_BY_SEVERITY = 202;
	public static final long VID_NETXMSD_PROCESS_WKSET = 203;
	public static final long VID_NETXMSD_PROCESS_VMSIZE = 204;
	public static final long VID_NUM_SESSIONS = 205;
	public static final long VID_NUM_SCRIPTS = 206;
	public static final long VID_SCRIPT_ID = 207;
	public static final long VID_SCRIPT_CODE = 208;
	public static final long VID_SESSION_ID = 209;
	public static final long VID_RECORDS_ORDER = 210;
	public static final long VID_NUM_SUBMAPS = 211;
	public static final long VID_SUBMAP_LIST = 212;
	public static final long VID_SUBMAP_ATTR = 213;
	public static final long VID_NUM_LINKS = 214;
	public static final long VID_LINK_LIST = 215;
	public static final long VID_MAP_ID = 216;
	public static final long VID_NUM_MAPS = 217;
	public static final long VID_NUM_MODULES = 218;
	public static final long VID_DST_USER_ID = 219;
	public static final long VID_MOVE_FLAG = 220;
	public static final long VID_CHANGE_PASSWD_FLAG = 221;
	public static final long VID_GUID = 222;
	public static final long VID_ACTIVATION_EVENT = 223;
	public static final long VID_DEACTIVATION_EVENT = 224;
	public static final long VID_SOURCE_OBJECT = 225;
	public static final long VID_ACTIVE_STATUS = 226;
	public static final long VID_INACTIVE_STATUS = 227;
	public static final long VID_SCRIPT = 228;
	public static final long VID_NODE_LIST = 229;
	public static final long VID_DCI_LIST = 230;
	public static final long VID_CONFIG_ID = 231;
	public static final long VID_FILTER = 232;
	public static final long VID_SEQUENCE_NUMBER = 233;
	public static final long VID_VERSION_MAJOR = 234;
	public static final long VID_VERSION_MINOR = 235;
	public static final long VID_VERSION_RELEASE = 236;
	public static final long VID_CONFIG_ID_2 = 237;
	public static final long VID_IV_LENGTH = 238;
	public static final long VID_DBCONN_STATUS = 239;
	public static final long VID_CREATION_TIME = 240;
	public static final long VID_LAST_CHANGE_TIME = 241;
	public static final long VID_TERMINATED_BY_USER = 242;
	public static final long VID_STATE = 243;
	public static final long VID_CURRENT_SEVERITY = 244;
	public static final long VID_ORIGINAL_SEVERITY = 245;
	public static final long VID_HELPDESK_STATE = 246;
	public static final long VID_HELPDESK_REF = 247;
	public static final long VID_REPEAT_COUNT = 248;
	public static final long VID_SNMP_RAW_VALUE_TYPE = 249;
	public static final long VID_CONFIRMATION_TEXT = 250;
	public static final long VID_FAILED_DCI_INDEX = 251;
	public static final long VID_ADDR_LIST_TYPE = 252;
	public static final long VID_COMPONENT_ID = 253;
	public static final long VID_SYNC_COMMENTS = 254;
	public static final long VID_EVENT_LIST = 255;
	public static final long VID_NUM_TRAPS = 256;
	public static final long VID_TRAP_LIST = 257;
	public static final long VID_NXMP_CONTENT = 258;
	public static final long VID_ERROR_TEXT = 259;
	public static final long VID_COMPONENT = 260;
	public static final long VID_CONSOLE_UPGRADE_URL = 261;
	public static final long VID_CLUSTER_TYPE = 262;
	public static final long VID_NUM_SYNC_SUBNETS = 263;
	public static final long VID_SYNC_SUBNETS = 264;
	public static final long VID_NUM_RESOURCES = 265;
	public static final long VID_RESOURCE_ID = 266;
	public static final long VID_SNMP_PROXY = 267;
	public static final long VID_PORT = 268;
	public static final long VID_PDU = 269;
	public static final long VID_PDU_SIZE = 270;
	public static final long VID_IS_SYSTEM = 271;
	public static final long VID_GRAPH_CONFIG = 272;
	public static final long VID_NUM_GRAPHS = 273;
	public static final long VID_GRAPH_ID = 274;
	public static final long VID_AUTH_TYPE = 275;
	public static final long VID_CERTIFICATE = 276;
	public static final long VID_SIGNATURE = 277;
	public static final long VID_CHALLENGE = 278;
	public static final long VID_CERT_MAPPING_METHOD = 279;
	public static final long VID_CERT_MAPPING_DATA = 280;
	public static final long VID_CERTIFICATE_ID = 281;
	public static final long VID_NUM_CERTIFICATES = 282;
	public static final long VID_ALARM_TIMEOUT_EVENT = 283;
	public static final long VID_NUM_GROUPS = 284;
	public static final long VID_QSIZE_CONDITION_POLLER = 285;
	public static final long VID_QSIZE_CONF_POLLER = 286;
	public static final long VID_QSIZE_DCI_POLLER = 287;
	public static final long VID_QSIZE_DBWRITER = 288;
	public static final long VID_QSIZE_EVENT = 289;
	public static final long VID_QSIZE_DISCOVERY = 290;
	public static final long VID_QSIZE_NODE_POLLER = 291;
	public static final long VID_QSIZE_ROUTE_POLLER = 292;
	public static final long VID_QSIZE_STATUS_POLLER = 293;
	public static final long VID_SYNTHETIC_MASK = 294;
	public static final long VID_SUBSYSTEM = 295;
	public static final long VID_SUCCESS_AUDIT = 296;
	public static final long VID_WORKSTATION = 297;
	public static final long VID_USER_TAG = 298;
	public static final long VID_REQUIRED_POLLS = 299;
	public static final long VID_SYS_DESCRIPTION = 300;
	public static final long VID_PSTORAGE_KEY = 301;
	public static final long VID_PSTORAGE_VALUE = 302;
	public static final long VID_NUM_DELETE_PSTORAGE = 303;
	public static final long VID_INSTANCE_COUNT = 304;
	public static final long VID_NUM_SET_PSTORAGE = 305;
	public static final long VID_NUM_TRUSTED_NODES = 306;
	public static final long VID_TRUSTED_NODES = 307;
	public static final long VID_TIMEZONE = 308;
	public static final long VID_NUM_CUSTOM_ATTRIBUTES = 309;
	public static final long VID_MAP_DATA = 310;
	public static final long VID_PRODUCT_ID = 311;
	public static final long VID_CLIENT_ID = 312;
	public static final long VID_LICENSE_DATA = 313;
	public static final long VID_TOKEN = 314;
	public static final long VID_SERVICE_ID = 315;
	public static final long VID_TOKEN_SOFTLIMIT = 316;
	public static final long VID_TOKEN_HARDLIMIT = 317;
	public static final long VID_USE_IFXTABLE = 318;
	public static final long VID_USE_X509_KEY_FORMAT = 319;
	public static final long VID_STICKY_FLAG = 320;
	public static final long VID_AUTOBIND_FILTER = 321;
	public static final long VID_BASE_UNITS = 322;
	public static final long VID_MULTIPLIER = 323;
	public static final long VID_CUSTOM_UNITS_NAME = 324;
	public static final long VID_PERFTAB_SETTINGS = 325;
	public static final long VID_EXECUTION_STATUS = 326;
	public static final long VID_EXECUTION_RESULT = 327;
	public static final long VID_TABLE_NUM_ROWS = 328;
	public static final long VID_TABLE_NUM_COLS = 329;
	public static final long VID_JOB_COUNT = 330;
	public static final long VID_JOB_ID = 331;
	public static final long VID_JOB_TYPE = 332;
	public static final long VID_JOB_STATUS = 333;
	public static final long VID_JOB_PROGRESS = 334;
	public static final long VID_FAILURE_MESSAGE = 335;
	public static final long VID_POLICY_TYPE = 336;
	public static final long VID_FIELDS = 337;
	public static final long VID_LOG_HANDLE = 338;
	public static final long VID_START_ROW = 339;
	public static final long VID_TABLE_OFFSET = 340;
	public static final long VID_NUM_FILTERS = 341;
	public static final long VID_GEOLOCATION_TYPE = 342;
	public static final long VID_LATITUDE = 343;
	public static final long VID_LONGITUDE = 344;
	public static final long VID_NUM_ORDERING_COLUMNS = 345;
	public static final long VID_SYSTEM_TAG = 346;
	public static final long VID_NUM_ENUMS = 347;
	public static final long VID_NUM_PUSH_PARAMETERS = 348;
	public static final long VID_OLD_PASSWORD = 349;
	public static final long VID_MIN_PASSWORD_LENGTH = 350;
	public static final long VID_LAST_LOGIN = 351;
	public static final long VID_LAST_PASSWORD_CHANGE = 352;
	public static final long VID_DISABLED_UNTIL = 353;
	public static final long VID_AUTH_FAILURES = 354;
	public static final long VID_RUNTIME_FLAGS = 355;
	public static final long VID_FILE_SIZE = 356;
	public static final long VID_MAP_TYPE = 357;
	public static final long VID_LAYOUT = 358;
	public static final long VID_SEED_OBJECTS = 359;
	public static final long VID_BACKGROUND = 360;
	public static final long VID_NUM_ELEMENTS = 361;
	public static final long VID_INTERFACE_ID = 362;
	public static final long VID_LOCAL_INTERFACE_ID = 363;
	public static final long VID_LOCAL_NODE_ID = 364;
	public static final long VID_SYS_NAME = 365;
	public static final long VID_LLDP_NODE_ID = 366;
	public static final long VID_IF_SLOT = 367;
	public static final long VID_IF_PORT = 368;
	public static final long VID_IMAGE_DATA = 369;
	public static final long VID_IMAGE_PROTECTED = 370;
	public static final long VID_NUM_IMAGES = 371;
	public static final long VID_IMAGE_MIMETYPE = 372;
	public static final long VID_PEER_NODE_ID = 373;
	public static final long VID_PEER_INTERFACE_ID = 374;
	public static final long VID_VRRP_VERSION = 375;
	public static final long VID_VRRP_VR_COUNT = 376;
	public static final long VID_DESTINATION_FILE_NAME = 377;
	public static final long VID_NUM_TABLES = 378;
	public static final long VID_IMAGE = 379;
	public static final long VID_DRIVER_NAME = 380;
	public static final long VID_DRIVER_VERSION = 381;
	public static final long VID_NUM_VLANS = 382;
	public static final long VID_CREATE_JOB_ON_HOLD = 383;
	public static final long VID_TILE_SERVER_URL = 384;
	public static final long VID_BACKGROUND_LATITUDE = 385;
	public static final long VID_BACKGROUND_LONGITUDE = 386;
	public static final long VID_BACKGROUND_ZOOM = 387;
	public static final long VID_BRIDGE_BASE_ADDRESS = 388;
	public static final long VID_DRILL_DOWN_OBJECT_ID = 389;
	public static final long VID_REPORT_DEFINITION = 390;
	public static final long VID_SLMCHECK_TYPE = 391;
	public static final long VID_REASON = 392;
	public static final long VID_NODE_ID = 393;
	public static final long VID_UPTIME_DAY = 394;
	public static final long VID_UPTIME_WEEK = 395;
	public static final long VID_UPTIME_MONTH = 396;
	public static final long VID_PRIMARY_NAME = 397;
	public static final long VID_NUM_RESULTS = 398;
	public static final long VID_RESULT_ID_LIST = 399;
	public static final long VID_RENDER_FORMAT = 400;
	public static final long VID_FILE_OFFSET = 401;
	public static final long VID_IS_TEMPLATE = 402;
	public static final long VID_DOT1X_PAE_STATE = 403;
	public static final long VID_DOT1X_BACKEND_STATE = 404;
	public static final long VID_IS_COMPLETE = 405;
	public static final long VID_MODIFICATION_TIME = 406;
	public static final long VID_IS_PHYS_PORT = 407;
	public static final long VID_CREATE_STATUS_DCI = 408;
	public static final long VID_NUM_COMMENTS = 409;
	public static final long VID_COMMENT_ID = 410;
	public static final long VID_DCOBJECT_TYPE = 411;
	public static final long VID_INSTANCE_COLUMN = 412;
	public static final long VID_DATA_COLUMN = 413;
	public static final long VID_ADMIN_STATE = 414;
	public static final long VID_OPER_STATE = 415;
	public static final long VID_EXPECTED_STATE = 416;
	public static final long VID_LINK_COLOR = 417;
	public static final long VID_CONNECTION_TYPE = 418;
	public static final long VID_RESOLVED_BY_USER = 419;
	public static final long VID_IS_STICKY = 420;
	public static final long VID_DATE_FORMAT = 421;
	public static final long VID_TIME_FORMAT = 422;
	public static final long VID_LINK_ROUTING = 423;
	public static final long VID_BACKGROUND_COLOR = 424;
	public static final long VID_FORCE_RELOAD = 425;
	public static final long VID_DISCOVERY_RADIUS = 426;
	public static final long VID_BATTERY_LEVEL = 427;
	public static final long VID_VENDOR = 428;
	public static final long VID_MODEL = 429;
	public static final long VID_OS_NAME = 430;
	public static final long VID_OS_VERSION = 431;
	public static final long VID_SERIAL_NUMBER = 432;
	public static final long VID_DEVICE_ID = 433;
	public static final long VID_MAPPING_TABLE_ID = 434;
	public static final long VID_INSTD_METHOD = 435;
	public static final long VID_INSTD_DATA = 436;
	public static final long VID_INSTD_FILTER = 437;
	public static final long VID_ACCURACY = 438;
	public static final long VID_GEOLOCATION_TIMESTAMP = 439;
	public static final long VID_SAMPLE_COUNT = 440;
	public static final long VID_HEIGHT = 441;
	public static final long VID_RADIO_COUNT = 442;
	public static final long VID_OBJECT_TOOLTIP_ONLY = 443;
	public static final long VID_SUMMARY_TABLE_ID = 444;
	public static final long VID_MENU_PATH = 445;
	public static final long VID_COLUMNS = 446;
	public static final long VID_TITLE = 447;
	public static final long VID_DAY_OF_WEEK = 448;
	public static final long VID_DAY_OF_MONTH = 449;
	public static final long VID_LOCALE = 450;
	public static final long VID_READ_ONLY = 451;
	public static final long VID_CLIENT_ADDRESS = 452;
   public static final long VID_SHORT_TIME_FORMAT = 453;
   public static final long VID_BOOT_TIME = 454;
   public static final long VID_REQUEST_ID = 455;
   public static final long VID_ADDRESS_MAP = 456;
   public static final long VID_XMPP_ID = 457;
   public static final long VID_FILE_SIZE_LIMIT = 458;
   public static final long VID_FILE_FOLLOW = 459;
   public static final long VID_FILE_DATA = 460;
   public static final long VID_ALARM_STATUS_FLOW_STATE = 461;
   public static final long VID_GROUPS = 462;
   public static final long VID_EFFECTIVE_RIGHTS = 463;
   public static final long VID_EXTENSION_COUNT = 464;
   public static final long VID_TIMED_ALARM_ACK_ENABLED = 465;
   public static final long VID_TABLE_EXTENDED_FORMAT = 466;
   public static final long VID_RS_JOB_ID = 467;
   public static final long VID_RS_JOB_TYPE = 468;
   public static final long VID_RS_REPORT_NAME  = 469;
   public static final long VID_HELPDESK_LINK_ACTIVE = 470;
   public static final long VID_URL = 471;
   public static final long VID_PEER_PROTOCOL = 472;
   public static final long VID_VIEW_REFRESH_INTERVAL = 473;
   public static final long VID_COMMAND_NAME = 474;
   public static final long VID_COMMAND_SHORT_NAME = 475;
   public static final long VID_MODULE_DATA_COUNT = 476;
   public static final long VID_NEW_FILE_NAME = 477;
   public static final long VID_ALARM_LIST_DISP_LIMIT = 478;
   public static final long VID_LANGUAGE = 479;
   public static final long VID_ROOT = 480;
   public static final long VID_INCLUDE_NOVALUE_OBJECTS = 481;
   public static final long VID_RECEIVE_OUTPUT = 482;
   public static final long VID_SESSION_STATE = 483;
   public static final long VID_PAGE_SIZE = 484;
   public static final long VID_EXECUTION_END_FLAG = 485;
   public static final long VID_COUNTRY = 486;
   public static final long VID_CITY = 487;
   public static final long VID_STREET_ADDRESS = 488;
   public static final long VID_POSTCODE = 489;
   public static final long VID_FUNCTION = 490;
   public static final long VID_RESPONSE_TIME = 491;
   public static final long VID_QSIZE_DCI_CACHE_LOADER = 492;
   public static final long VID_MTU = 493;
   public static final long VID_ALIAS = 494;
   public static final long VID_AP_INDEX = 495;
   public static final long VID_PROTOCOL_VERSION_EX = 496;
   public static final long VID_SCRIPT_LIST = 497;
   public static final long VID_TOOL_LIST = 498;
   public static final long VID_NUM_SUMMARY_TABLES = 499;
   public static final long VID_SUMMARY_TABLE_LIST = 500;
   public static final long VID_OVERVIEW_DCI_COUNT = 501;
   public static final long VID_OVERVIEW_ONLY = 502;
   public static final long VID_AGENT_CACHE_MODE = 503;
   public static final long VID_DATE = 504;
   public static final long VID_RECONCILLATION = 505;
   public static final long VID_DISPLAY_MODE = 506;
   public static final long VID_NUM_FIELDS = 507;
   public static final long VID_PASSWORD_IS_VALID = 508;
   public static final long VID_SERIALIZE = 509;
   public static final long VID_COMPILATION_STATUS = 510;
   public static final long VID_ERROR_LINE = 511;
   public static final long VID_SPEED = 512;
   public static final long VID_IFTABLE_SUFFIX = 513;
   public static final long VID_SERVER_COMMAND_TIMEOUT = 514;
   public static final long VID_SYS_CONTACT = 515;
   public static final long VID_SYS_LOCATION = 516;
   public static final long VID_RACK_ID = 517;
   public static final long VID_RACK_IMAGE_FRONT = 518;
   public static final long VID_RACK_POSITION = 519;
   public static final long VID_RACK_HEIGHT = 520;
   public static final long VID_SCHEDULE_COUNT = 521;
   public static final long VID_SCHEDULED_TASK_ID = 522;
   public static final long VID_TASK_HANDLER = 523;
   public static final long VID_SCHEDULE = 524;
   public static final long VID_EXECUTION_TIME = 525;
   public static final long VID_LAST_EXECUTION_TIME = 526;
   public static final long VID_CALLBACK_COUNT = 527;
   public static final long VID_DASHBOARDS = 528;
   public static final long VID_OWNER = 529;
   public static final long VID_MAINTENANCE_MODE = 530;
   public static final long VID_IS_MASTER = 531;
   public static final long VID_AGENT_COMM_TIME = 532;
   public static final long VID_GRAPH_TEMPALTE = 533;
   public static final long VID_OVERWRITE = 534;
   public static final long VID_IPV6_SUPPORT = 535;
   public static final long VID_BULK_RECONCILIATION = 536;
   public static final long VID_STATUS = 537;
   public static final long VID_FLAGS_MASK = 538;
   public static final long VID_TOP_BOTTOM = 539;
   public static final long VID_AUTH_TOKEN = 540;
   public static final long VID_REPOSITORY_ID = 541;
   public static final long VID_TOOLTIP_DCI_COUNT = 542;
   public static final long VID_CONTROLLER_ID = 543;
   public static final long VID_CHASSIS_ID = 544;
   public static final long VID_NODE_SUBTYPE = 545;
   public static final long VID_SSH_LOGIN = 546;
   public static final long VID_SSH_PASSWORD = 547;
   public static final long VID_SSH_PROXY = 548;
   public static final long VID_ZONE_PROXY = 549;
   public static final long VID_MESSAGE_LENGTH = 550;
   public static final long VID_LDAP_DN = 551;
   public static final long VID_LDAP_ID = 552;
   public static final long VID_FAIL_CODE_LIST = 553;
   public static final long VID_FOLDER_SIZE = 554;
   public static final long VID_ALARM_CATEGORY_ID = 555;
   public static final long VID_FILE_COUNT = 556;
   public static final long VID_ALARM_CATEGORY_ACL = 557;
   public static final long VID_ALLOW_MULTIPART = 558;
   public static final long VID_ALARM_ID_LIST = 559;
   public static final long VID_NUM_COMPONENTS = 560;
   public static final long VID_SERVER_NAME = 561;
   public static final long VID_SERVER_COLOR = 562;
   public static final long VID_MESSAGE_OF_THE_DAY = 563;
   public static final long VID_PORT_ROW_COUNT = 564;
   public static final long VID_PORT_NUMBERING_SCHEME = 565;
   public static final long VID_NUM_VALUES = 566;
	public static final long VID_NUM_PSTORAGE = 567;
   public static final long VID_COMMAND_ID = 568;
   public static final long VID_HOSTNAME = 569;
   public static final long VID_ENABLE_COMPRESSION = 570;
   public static final long VID_AGENT_COMPRESSION_MODE = 571;
   public static final long VID_TRAP_TYPE = 572;
   public static final long VID_IS_ACTIVE = 573;
   public static final long VID_CHANNEL_ID = 574;
   public static final long VID_NUM_URLS = 575;
   public static final long VID_GRACE_LOGINS = 576;
   public static final long VID_TUNNEL_GUID = 577;
   public static final long VID_ORGANIZATION = 578;
   public static final long VID_TUNNEL_ID = 579;
   public static final long VID_PARENT_INTERFACE = 580; 
   public static final long VID_SENSOR_FLAGS = 581; 
   public static final long VID_DEVICE_CLASS = 582; 
   public static final long VID_COMM_PROTOCOL = 583; 
   public static final long VID_XML_CONFIG = 584; 
   public static final long VID_DEVICE_ADDRESS = 585; 
   public static final long VID_META_TYPE = 586; 
   public static final long VID_LAST_CONN_TIME = 587;
   public static final long VID_FRAME_COUNT = 588;
   public static final long VID_SIGNAL_STRENGHT = 589;
   public static final long VID_SIGNAL_NOISE = 590;
   public static final long VID_FREQUENCY = 591;
   public static final long VID_SENSOR_PROXY = 592;
   public static final long VID_XML_REG_CONFIG = 593;
   public static final long VID_REG_TYPE = 594;
   public static final long VID_DECODER = 595;
   public static final long VID_LORA_APP_EUI = 596;
   public static final long VID_LORA_APP_KEY = 597;
   public static final long VID_LORA_APP_S_KEY = 598;
   public static final long VID_LORA_NWK_S_KWY = 599;
   public static final long VID_DCI_NAME = 600;
   public static final long VID_STATE_FLAGS = 601;
   public static final long VID_CAPABILITIES = 602;
   public static final long VID_IN_FIELD_COUNT = 603;
   public static final long VID_STRING_COUNT = 604;
   public static final long VID_EXPAND_STRING = 605;
   public static final long VID_ACTION_LIST = 606;
   public static final long VID_ZONE_SNMP_PORT_COUNT = 607;
   public static final long VID_INCLUDE_RAW_VALUES = 608;
   public static final long VID_JOB_CANCELED = 609;
   public static final long VID_INSTANCE_RETENTION = 610;
   public static final long VID_RACK_ORIENTATION = 611;
   public static final long VID_PASSIVE_ELEMENTS = 612;
   public static final long VID_RACK_IMAGE_REAR = 613;

	public static final long VID_ACL_USER_BASE = 0x00001000L;
	public static final long VID_ACL_USER_LAST = 0x00001FFFL;
	public static final long VID_ACL_RIGHTS_BASE = 0x00002000L;
	public static final long VID_ACL_RIGHTS_LAST = 0x00002FFFL;
	public static final long VID_GROUP_MEMBER_BASE = 0x00004000L;
	public static final long VID_GROUP_MEMBER_LAST = 0x00004FFFL;
	public static final long VID_THRESHOLD_BASE = 0x00800000L;
	public static final long VID_DCI_COLUMN_BASE = 0x30000000L;
	public static final long VID_DCI_THRESHOLD_BASE = 0x20000000L;
	public static final long VID_DCI_SCHEDULE_BASE = 0x10000000L;
	public static final long VID_EVENT_ARG_BASE = 0x00008000L;
	public static final long VID_EVENT_ARG_LAST = 0x00008FFFL;
	public static final long VID_TRAP_PBASE = 0x00009000L;
	public static final long VID_PARENT_ID_BASE = 0x00003000L;
	public static final long VID_PARENT_ID_LAST = 0x00003FFFL;
	public static final long VID_CHILD_ID_BASE = 0x80000000L;
	public static final long VID_CHILD_ID_LAST = 0xFFFFFFFEL;
	public static final long VID_CUSTOM_ATTRIBUTES_BASE = 0x70000000L;
   public static final long VID_MODULE_DATA_BASE = 0x71000000L;
   public static final long VID_OVERVIEW_DCI_LIST_BASE = 0x72000000L;
   public static final long VID_TOOLTIP_DCI_LIST_BASE = 0x73000000L;
   public static final long VID_URL_LIST_BASE = 0x74000000L;
	public static final long VID_RESOURCE_LIST_BASE = 0x20000000L;
	public static final long VID_IP_ADDRESS_LIST_BASE = 0x7F000000L;
   public static final long VID_SYNC_SUBNETS_BASE = 0x28000000L;
	public static final long VID_ENUM_VALUE_BASE = 0x10000000L;
	public static final long VID_ACTION_ARG_BASE = 0x10000000L;
	public static final long VID_PARAM_LIST_BASE = 0x10000000L;
	public static final long VID_ENUM_LIST_BASE = 0x20000000L;
	public static final long VID_PUSHPARAM_LIST_BASE = 0x30000000L;
	public static final long VID_TABLE_LIST_BASE = 0x40000000L;
	public static final long VID_DCI_VALUES_BASE = 0x10000000L;
	public static final long VID_VARLIST_BASE = 0x10000000L;
	public static final long VID_VPN_NETWORK_BASE = 0x10000000L;
	public static final long VID_OBJECT_TOOLS_BASE = 0x10000000L;
	public static final long VID_COLUMN_INFO_BASE = 0x10000000L;
	public static final long VID_COLUMN_NAME_BASE = 0x10000000L;
	public static final long VID_COLUMN_FMT_BASE = 0x20000000L;
	public static final long VID_ROW_DATA_BASE = 0x30000000L;
   public static final long VID_FIELD_LIST_BASE = 0x70000000L;
	public static final long VID_LPP_RULE_BASE = 0x10000000L;
	public static final long VID_LPP_LIST_BASE = 0x10000000L;
	public static final long VID_LPPGROUP_LIST_BASE = 0x20000000L;
	public static final long VID_LPP_NODE_LIST_BASE = 0x01000000L;
	public static final long VID_EVENTLOG_MSG_BASE = 0x10000000L;
	public static final long VID_SYSLOG_MSG_BASE = 0x10000000L;
	public static final long VID_TRAP_LOG_MSG_BASE = 0x10000000L;
	public static final long VID_SCRIPT_LIST_BASE = 0x10000000L;
	public static final long VID_SESSION_DATA_BASE = 0x10000000L;
	public static final long VID_SNMP_WALKER_DATA_BASE = 0x10000000L;
	public static final long VID_MAP_LIST_BASE = 0x10000000L;
	public static final long VID_MODULE_LIST_BASE = 0x10000000L;
	public static final long VID_AGENT_CFG_LIST_BASE = 0x10000000L;
	public static final long VID_DCI_LIST_BASE = 0x40000000L;
	public static final long VID_DCI_LIST_LAST = 0x4FFFFFFFL;
	public static final long VID_IMAGE_LIST_BASE = 0x10000000L;
	public static final long VID_PUSH_DCI_DATA_BASE = 0x10000000L;
	public static final long VID_ADDR_LIST_BASE = 0x10000000L;
	public static final long VID_TRAP_INFO_BASE = 0x10000000L;
	public static final long VID_GRAPH_LIST_BASE = 0x10000000L;
	public static final long VID_GRAPH_ACL_BASE = 0x20000000L;
	public static final long VID_SYSDCI_LIST_BASE = 0x10000000L;
	public static final long VID_CERT_LIST_BASE = 0x10000000L;
	public static final long VID_STRING_LIST_BASE = 0x10000000L;
   public static final long VID_PSTORAGE_SET_LIST_BASE = 0x10000000L;
   public static final long VID_PSTORAGE_DELETE_LIST_BASE = 0x20000000L;   
	public static final long VID_PSTORAGE_LIST_BASE = 0x10000000L;	
	public static final long VID_INSTANCE_LIST_BASE = 0x20000000L;
	public static final long VID_OBJECT_LINKS_BASE = 0x10000000L;
	public static final long VID_SUBMAP_LINK_NAMES_BASE = 0x20000000L;
	public static final long VID_JOB_LIST_BASE = 0x10000000L;
	public static final long VID_TABLE_COLUMN_INFO_BASE = 0x10000000L;
	public static final long VID_TABLE_DATA_BASE = 0x20000000L;
	public static final long VID_COLUMN_FILTERS_BASE = 0x10000000L;
	public static final long VID_ORDERING_COLUMNS_BASE = 0x40000000L;
	public static final long VID_USM_CRED_LIST_BASE = 0x10000000L;
	public static final long VID_ELEMENT_LIST_BASE = 0x10000000L;
	public static final long VID_LINK_LIST_BASE = 0x40000000L;
	public static final long VID_VLAN_LIST_BASE = 0x10000000L;
	public static final long VID_NETWORK_PATH_BASE = 0x40000000L;
	public static final long VID_COMPONENT_LIST_BASE = 0x20000000L;
	public static final long VID_RADIO_LIST_BASE = 0x30000000L;
	public static final long VID_UUID_LIST_BASE = 0x10000000L;
	public static final long VID_RULE_LIST_BASE = 0x10000000L;
	public static final long VID_EXTENSION_LIST_BASE = 0x10000000L;
	public static final long VID_DCI_ID_LIST_BASE = 0x10000000L;
   public static final long VID_LOC_LIST_BASE = 0x10000000L;
   public static final long VID_SCHEDULE_LIST_BASE = 0x10000000L;
   public static final long VID_CALLBACK_BASE= 0x10000000L;
   public static final long VID_ZMQ_SUBSCRIPTION_BASE= 0x10000000L;
}
