/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class EventTemplate {
    public static final int FLAG_WRITE_TO_LOG = 1;
    private long code;
    private String name;
    private Severity severity;
    private int flags;
    private String message;
    private String description;

    public EventTemplate(long code) {
        this.code = code;
        this.name = "";
        this.severity = Severity.NORMAL;
        this.flags = 1;
        this.message = "";
        this.description = "";
    }

    public EventTemplate(NXCPMessage msg) {
        this.code = msg.getFieldAsInt64(24L);
        this.severity = Severity.getByValue(msg.getFieldAsInt32(25L));
        this.flags = msg.getFieldAsInt32(13L);
        this.name = msg.getFieldAsString(20L);
        this.message = msg.getFieldAsString(26L);
        this.description = msg.getFieldAsString(27L);
    }

    public EventTemplate(EventTemplate src) {
        this.setAll(src);
    }

    public void setAll(EventTemplate src) {
        this.code = src.code;
        this.severity = src.severity;
        this.flags = src.flags;
        this.name = src.name;
        this.message = src.message;
        this.description = src.description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }
}

