/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objects;

import java.util.Map;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectContext {
    public AbstractNode object;
    public Alarm alarm;

    public ObjectContext(AbstractNode object, Alarm alarm) {
        this.object = object;
        this.alarm = alarm;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alarm == null ? 0 : this.alarm.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectContext other = (ObjectContext)obj;
        if (other.object == null || this.object == null) {
            return other.object == null && this.object == null;
        }
        return other.object.getObjectId() == this.object.getObjectId();
    }

    public String substituteMacros(String s, Map<String, String> inputValues) {
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            block44: {
                block43: {
                    if (src[i] != '%') break block43;
                    if (++i == s.length()) break;
                    switch (src[i]) {
                        case 'a': {
                            String string;
                            if (this.object != null) {
                                string = this.object.getPrimaryIP().getHostAddress();
                            } else {
                                Messages.get();
                                string = Messages.ObjectContext_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'A': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getMessage());
                                break;
                            }
                            break block44;
                        }
                        case 'c': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getSourceEventCode());
                                break;
                            }
                            break block44;
                        }
                        case 'g': {
                            String string;
                            if (this.object != null) {
                                string = this.object.getGuid().toString();
                            } else {
                                Messages.get();
                                string = Messages.ObjectContext_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'i': {
                            String string;
                            if (this.object != null) {
                                string = String.format("0x%08X", this.object.getObjectId());
                            } else {
                                Messages.get();
                                string = Messages.ObjectContext_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'I': {
                            String string;
                            if (this.object != null) {
                                string = Long.toString(this.object.getObjectId());
                            } else {
                                Messages.get();
                                string = Messages.ObjectContext_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'm': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getMessage());
                                break;
                            }
                            break block44;
                        }
                        case 'n': {
                            String string;
                            if (this.object != null) {
                                string = this.object.getObjectName();
                            } else {
                                Messages.get();
                                string = Messages.ObjectContext_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'N': {
                            if (this.alarm != null) {
                                sb.append(ConsoleSharedData.getSession().getEventName((long)this.alarm.getSourceEventCode()));
                                break;
                            }
                            break block44;
                        }
                        case 's': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getCurrentSeverity());
                                break;
                            }
                            break block44;
                        }
                        case 'S': {
                            if (this.alarm != null) {
                                sb.append(StatusDisplayInfo.getStatusText(this.alarm.getCurrentSeverity()));
                                break;
                            }
                            break block44;
                        }
                        case 'U': {
                            sb.append(ConsoleSharedData.getSession().getUserName());
                            break;
                        }
                        case 'v': {
                            sb.append("2.2.3");
                            break;
                        }
                        case 'y': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getState());
                                break;
                            }
                            break block44;
                        }
                        case 'Y': {
                            if (this.alarm != null) {
                                sb.append(this.alarm.getId());
                                break;
                            }
                            break block44;
                        }
                        case '%': {
                            sb.append('%');
                            break;
                        }
                        case '{': {
                            String value;
                            StringBuilder attr = new StringBuilder();
                            ++i;
                            while (i < s.length()) {
                                if (src[i] == '}') break;
                                attr.append(src[i]);
                                ++i;
                            }
                            if (this.object != null && attr.length() > 0 && (value = (String)this.object.getCustomAttributes().get(attr.toString())) != null) {
                                sb.append(value);
                                break;
                            }
                            break block44;
                        }
                        case '(': {
                            String value;
                            StringBuilder name = new StringBuilder();
                            ++i;
                            while (i < s.length()) {
                                if (src[i] == ')') break;
                                name.append(src[i]);
                                ++i;
                            }
                            if (name.length() > 0 && (value = inputValues.get(name.toString())) != null) {
                                sb.append(value);
                                break;
                            }
                            break block44;
                        }
                    }
                    break block44;
                }
                sb.append(src[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

