/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.policymanager.Activator;
import org.netxms.ui.eclipse.policymanager.dialogs.SavePolicyOnCloseDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public abstract class AbstractPolicyEditor
extends ViewPart
implements ISaveablePart2 {
    protected NXCSession session;
    protected AgentPolicy policy;
    protected Action actionRefresh;
    protected Action actionSave;
    private Display display;
    private boolean modified = false;
    private boolean throwExceptionOnSave = false;
    private Exception saveException = null;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.display = Display.getCurrent();
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        this.contributeToActionBars();
    }

    protected void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                AbstractPolicyEditor.this.refresh();
            }
        };
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                AbstractPolicyEditor.this.save();
            }
        };
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected abstract void doSaveInternal(IProgressMonitor var1) throws Exception;

    public final void doSave(IProgressMonitor monitor) {
        block2: {
            try {
                this.doSaveInternal(monitor);
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageDialogHelper.openQuestion((Shell)AbstractPolicyEditor.this.getSite().getShell(), (String)"Install Policy", (String)"Policy successfully saved. Install new version on all nodes where this policy is already installed?")) {
                            AbstractPolicyEditor.this.deployPolicyOnExistingNodes();
                        }
                    }
                });
            }
            catch (Exception e) {
                this.saveException = e;
                if (this.throwExceptionOnSave) break block2;
                MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error", (String)String.format("Cannot save policy object: %s", e.getLocalizedMessage()));
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SavePolicyOnCloseDialog dlg = new SavePolicyOnCloseDialog(this.getSite().getShell());
        int rc = dlg.open();
        if (rc == 100) {
            this.modified = false;
            return 0;
        }
        if (rc == 1) {
            return 2;
        }
        return 1;
    }

    protected void save() {
        this.throwExceptionOnSave = true;
        new ConsoleJob("Save agent policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.policymanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractPolicyEditor.this.saveException = null;
                AbstractPolicyEditor.this.doSave(monitor);
                if (AbstractPolicyEditor.this.saveException != null) {
                    throw AbstractPolicyEditor.this.saveException;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractPolicyEditor.this.modified = false;
                        AbstractPolicyEditor.this.firePropertyChange(257);
                        (this).AbstractPolicyEditor.this.actionSave.setEnabled(false);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot save agent policy";
            }

            protected void jobFinalize() {
                AbstractPolicyEditor.this.throwExceptionOnSave = false;
            }
        }.start();
    }

    protected void setModified() {
        if (this.modified) {
            return;
        }
        this.modified = true;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(true);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPolicy(AgentPolicy policy) {
        this.policy = policy;
        this.setPartName("Edit Policy \"" + policy.getObjectName() + "\"");
        this.doRefresh();
    }

    private void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm Refresh", (String)"This will destroy all unsaved changes. Are you sure? ")) {
            return;
        }
        this.policy = (AgentPolicy)this.session.findObjectById(this.policy.getObjectId(), AgentPolicy.class);
        this.actionSave.setEnabled(false);
        this.doRefresh();
        this.modified = false;
        this.firePropertyChange(257);
    }

    protected abstract void doRefresh();

    private void deployPolicyOnExistingNodes() {
        ConsoleJob job = new ConsoleJob("Deploy policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.policymanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long[] lArray = AbstractPolicyEditor.this.policy.getChildIdList();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long nodeId = lArray[n2];
                    try {
                        AbstractPolicyEditor.this.session.deployAgentPolicy(AbstractPolicyEditor.this.policy.getObjectId(), nodeId);
                    }
                    catch (Exception e) {
                        Activator.logError("Exception in deployPolicyOnExistingNodes", e);
                    }
                    ++n2;
                }
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.start();
    }
}

